/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.stub;

import com.arjuna.webservices.wsarjtx.ArjunaTXConstants;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsarjtx.client.TerminationCoordinatorRPCClient;
import com.arjuna.wsc11.messaging.MessageId;
import com.arjuna.wst.FaultedException;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.TransactionRolledBackException;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst11.BusinessActivityTerminator;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import org.jboss.ws.api.addressing.MAP;

public class BusinessActivityTerminatorRPCStub
implements BusinessActivityTerminator {
    private W3CEndpointReference _terminationCoordinator = null;
    private final String _id;

    public BusinessActivityTerminatorRPCStub(String id, W3CEndpointReference terminationCoordinator) throws Exception {
        this._terminationCoordinator = terminationCoordinator;
        this._id = id;
    }

    @Override
    public void close() throws TransactionRolledBackException, UnknownTransactionException, SystemException {
        MAP map = AddressingHelper.createNotificationContext(MessageId.getMessageId());
        try {
            TerminationCoordinatorRPCClient.getClient().sendClose(this._terminationCoordinator, map, new InstanceIdentifier(this._id));
        }
        catch (SoapFault11 soapFault) {
            if (ArjunaTXConstants.TRANSACTIONROLLEDBACK_ERROR_CODE_QNAME.equals(soapFault.getSubcode())) {
                throw new TransactionRolledBackException(soapFault.getMessage());
            }
            if (ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME.equals(soapFault.getSubcode())) {
                throw new UnknownTransactionException(soapFault.getMessage());
            }
            throw new SystemException(soapFault.getMessage());
        }
        catch (Exception e) {
            throw new SystemException();
        }
    }

    @Override
    public void cancel() throws FaultedException, UnknownTransactionException, SystemException {
        MAP map = AddressingHelper.createNotificationContext(MessageId.getMessageId());
        try {
            TerminationCoordinatorRPCClient.getClient().sendCancel(this._terminationCoordinator, map, new InstanceIdentifier(this._id));
        }
        catch (SoapFault11 soapFault) {
            if (ArjunaTXConstants.FAULTED_ERROR_CODE_QNAME.equals(soapFault.getSubcode())) {
                throw new FaultedException(soapFault.getMessage());
            }
            if (ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME.equals(soapFault.getSubcode())) {
                throw new UnknownTransactionException(soapFault.getMessage());
            }
            throw new SystemException(soapFault.getMessage());
        }
        catch (Exception e) {
            throw new SystemException(e.getMessage());
        }
        catch (Throwable th) {
            th.printStackTrace();
            throw new SystemException(th.getMessage());
        }
    }

    @Override
    public void complete() throws FaultedException, UnknownTransactionException, SystemException {
        MAP map = AddressingHelper.createNotificationContext(MessageId.getMessageId());
        try {
            TerminationCoordinatorRPCClient.getClient().sendComplete(this._terminationCoordinator, map, new InstanceIdentifier(this._id));
        }
        catch (SoapFault11 soapFault) {
            if (ArjunaTXConstants.FAULTED_ERROR_CODE_QNAME.equals(soapFault.getSubcode())) {
                throw new FaultedException(soapFault.getMessage());
            }
            if (ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME.equals(soapFault.getSubcode())) {
                throw new UnknownTransactionException(soapFault.getMessage());
            }
            throw new SystemException(soapFault.getMessage());
        }
        catch (Exception e) {
            throw new SystemException(e.getMessage());
        }
        catch (Throwable th) {
            th.printStackTrace();
            throw new SystemException(th.getMessage());
        }
    }

    @Override
    public W3CEndpointReference getEndpoint() {
        return this._terminationCoordinator;
    }

    public void unknown() throws SystemException {
        this.error();
    }

    public void error() throws SystemException {
    }
}

