/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.repository.spi;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.osgi.repository.RepositoryLogger;
import org.jboss.osgi.repository.RepositoryMessages;
import org.jboss.osgi.repository.RepositoryReader;
import org.jboss.osgi.repository.RepositoryStorage;
import org.jboss.osgi.repository.RepositoryStorageException;
import org.jboss.osgi.repository.XRepository;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.spi.AbstractRequirement;
import org.osgi.framework.Filter;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class MemoryRepositoryStorage
implements RepositoryStorage {
    private final XRepository repository;
    private final AtomicLong increment = new AtomicLong();
    private final Map<String, Map<String, Set<XCapability>>> capabilityCache = new HashMap<String, Map<String, Set<XCapability>>>();

    public MemoryRepositoryStorage(XRepository repository) {
        if (repository == null) {
            throw RepositoryMessages.MESSAGES.illegalArgumentNull("repository");
        }
        this.repository = repository;
    }

    protected AtomicLong getAtomicIncrement() {
        return this.increment;
    }

    @Override
    public XRepository getRepository() {
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepositoryReader getRepositoryReader() {
        Map<String, Map<String, Set<XCapability>>> map = this.capabilityCache;
        synchronized (map) {
            return new RepositoryReader(){
                private final Iterator<XResource> iterator;
                {
                    Map map = MemoryRepositoryStorage.this.capabilityCache;
                    synchronized (map) {
                        Set icaps = MemoryRepositoryStorage.this.getCachedCapabilities("osgi.identity", null);
                        final Iterator capit = icaps.iterator();
                        this.iterator = new Iterator<XResource>(){

                            @Override
                            public boolean hasNext() {
                                return capit.hasNext();
                            }

                            @Override
                            public XResource next() {
                                return (XResource)((XCapability)capit.next()).getResource();
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                }

                @Override
                public Map<String, String> getRepositoryAttributes() {
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    attributes.put("name", MemoryRepositoryStorage.this.getRepository().getName());
                    attributes.put("increment", new Long(MemoryRepositoryStorage.this.increment.get()).toString());
                    return Collections.unmodifiableMap(attributes);
                }

                @Override
                public XResource nextResource() {
                    return this.iterator.hasNext() ? this.iterator.next() : null;
                }

                @Override
                public void close() {
                }
            };
        }
    }

    @Override
    public Collection<Capability> findProviders(Requirement req) {
        Set<Capability> result = this.findCachedProviders(req);
        RepositoryLogger.LOGGER.tracef("Find cached providers: %s => %s", req, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XResource addResource(XResource res) throws RepositoryStorageException {
        if (res == null) {
            throw RepositoryMessages.MESSAGES.illegalArgumentNull("resource");
        }
        XIdentityCapability icap = res.getIdentityCapability();
        Map<String, Map<String, Set<XCapability>>> map = this.capabilityCache;
        synchronized (map) {
            Set<XCapability> icaps = this.getCachedCapabilities("osgi.identity", icap.getSymbolicName());
            for (XCapability aux : icaps) {
                XIdentityCapability iaux = (XIdentityCapability)aux.adapt(XIdentityCapability.class);
                if (!icap.getVersion().equals((Object)iaux.getVersion())) continue;
                throw RepositoryMessages.MESSAGES.illegalStateResourceAlreadyExists(res);
            }
            for (Capability cap : res.getCapabilities(null)) {
                this.addCachedCapability((XCapability)cap);
            }
            this.increment.incrementAndGet();
            RepositoryLogger.LOGGER.debugf("Resource added: %s", res);
        }
        return res;
    }

    @Override
    public XResource addResource(String mime, InputStream input) throws RepositoryStorageException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeResource(XResource res) throws RepositoryStorageException {
        if (res == null) {
            throw RepositoryMessages.MESSAGES.illegalArgumentNull("resource");
        }
        boolean found = false;
        Map<String, Map<String, Set<XCapability>>> map = this.capabilityCache;
        synchronized (map) {
            for (Capability cap : res.getCapabilities(null)) {
                XCapability xcap = (XCapability)cap;
                String namespace = cap.getNamespace();
                String nsvalue = (String)xcap.getAttribute(namespace);
                Iterator<XCapability> capit = this.getCachedCapabilities(namespace, nsvalue).iterator();
                while (capit.hasNext()) {
                    Resource auxres = capit.next().getResource();
                    if (res != auxres) continue;
                    capit.remove();
                    found = true;
                }
            }
            RepositoryLogger.LOGGER.debugf("Resource removed: %s", res);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Capability> findCachedProviders(Requirement req) {
        Map<String, Map<String, Set<XCapability>>> map = this.capabilityCache;
        synchronized (map) {
            HashSet<Capability> result = new HashSet<Capability>();
            Set<XCapability> caps = this.getCachedCapabilities(req.getNamespace(), null);
            for (XCapability cap : caps) {
                if (!this.matches(req, (Capability)cap)) continue;
                result.add((Capability)cap);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCachedCapability(XCapability cap) {
        Map<String, Map<String, Set<XCapability>>> map = this.capabilityCache;
        synchronized (map) {
            String nsvalue;
            Set<XCapability> capset;
            String namespace = cap.getNamespace();
            Map<String, Set<XCapability>> capmap = this.capabilityCache.get(namespace);
            if (capmap == null) {
                capmap = new HashMap<String, Set<XCapability>>();
                this.capabilityCache.put(namespace, capmap);
            }
            if ((capset = capmap.get(nsvalue = (String)cap.getAttribute(namespace))) == null) {
                capset = new HashSet<XCapability>();
                capmap.put(nsvalue, capset);
            }
            capset.add(cap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<XCapability> getCachedCapabilities(String namespace, String nsvalue) {
        Map<String, Map<String, Set<XCapability>>> map = this.capabilityCache;
        synchronized (map) {
            Set<XCapability> result;
            Map<String, Set<XCapability>> caps = this.capabilityCache.get(namespace);
            if (caps == null) {
                caps = new HashMap<String, Set<XCapability>>();
                this.capabilityCache.put(namespace, caps);
            }
            if (nsvalue != null) {
                result = caps.get(nsvalue);
                if (result == null) {
                    result = new HashSet<XCapability>();
                }
            } else {
                HashSet<XCapability> allcaps = new HashSet<XCapability>();
                for (Set<XCapability> set : caps.values()) {
                    allcaps.addAll(set);
                }
                result = allcaps;
            }
            return result;
        }
    }

    private boolean matches(Requirement req, Capability cap) {
        boolean result;
        if (req instanceof XRequirement) {
            XRequirement xreq = (XRequirement)req;
            result = xreq.matches(cap);
        } else {
            result = req.getNamespace().equals(cap.getNamespace()) && this.matchFilter(req, cap);
        }
        return result;
    }

    private boolean matchFilter(Requirement req, Capability cap) {
        Filter filter = AbstractRequirement.getFilterFromDirective((Requirement)req);
        return filter != null ? filter.match(new Hashtable(cap.getAttributes())) : true;
    }
}

