/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.osgi.resolver.XAttributeSupport;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XDirectiveSupport;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.internal.ResolverMessages;
import org.jboss.osgi.resolver.spi.AbstractElement;
import org.osgi.resource.Resource;

public class AbstractCapability
extends AbstractElement
implements XCapability {
    private final String namespace;
    private final Resource resource;
    private final XAttributeSupport attributes;
    private final XDirectiveSupport directives;
    private String toString;

    protected AbstractCapability(Resource resource, String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        if (resource == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("resource");
        }
        if (namespace == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("namespace");
        }
        if (atts == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("attributes");
        }
        if (dirs == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("directives");
        }
        this.resource = resource;
        this.namespace = namespace;
        this.attributes = new AbstractElement.AttributeSupporter(atts);
        this.directives = new AbstractElement.DirectiveSupporter(dirs);
        this.validateAttributes(atts);
    }

    protected void validateAttributes(Map<String, Object> atts) {
        for (String name : this.getMandatoryAttributes()) {
            if (atts.get(name) != null) continue;
            throw ResolverMessages.MESSAGES.illegalArgumentCannotObtainAttribute(name);
        }
    }

    protected Set<String> getMandatoryAttributes() {
        return Collections.emptySet();
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.directives.getDirectives();
    }

    @Override
    public String getDirective(String key) {
        return this.directives.getDirective(key);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes.getAttributes();
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.getAttribute(key);
    }

    public String toString() {
        if (this.toString == null) {
            String attstr = "atts=" + this.attributes;
            String dirstr = !this.getDirectives().isEmpty() ? ",dirs=" + this.directives : "";
            XIdentityCapability icap = ((XResource)this.getResource()).getIdentityCapability();
            String resname = ",[" + (icap != null ? icap.getSymbolicName() + ":" + icap.getVersion() : "anonymous") + "]";
            this.toString = this.getClass().getSimpleName() + "[" + attstr + dirstr + resname + "]";
        }
        return this.toString;
    }
}

