/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.framework.FrameworkException;
import org.jboss.osgi.spi.framework.GenericFrameworkWrapper;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.util.ServiceLoader;
import org.jboss.osgi.spi.util.StringPropertyReplacer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public class PropertiesBootstrapProvider
implements OSGiBootstrapProvider {
    private static final Logger log = Logger.getLogger(PropertiesBootstrapProvider.class);
    public static final String OSGI_FRAMEWORK_CONFIG = "jboss.osgi.framework.properties";
    public static final String DEFAULT_OSGI_FRAMEWORK_PROPERTIES = "jboss-osgi-framework.properties";
    public static final String PROP_OSGI_FRAMEWORK_AUTO_INSTALL = "org.jboss.osgi.framework.autoInstall";
    public static final String PROP_OSGI_FRAMEWORK_AUTO_START = "org.jboss.osgi.framework.autoStart";
    public static final String PROP_OSGI_FRAMEWORK_EXTRA = "org.jboss.osgi.framework.extra";
    private static Set<String> internalProps = new HashSet<String>();
    private Framework framework;
    private boolean configured;

    @Override
    public void configure() {
        this.configureInternal(System.getProperty(OSGI_FRAMEWORK_CONFIG, DEFAULT_OSGI_FRAMEWORK_PROPERTIES));
    }

    @Override
    public void configure(String resourceConfig) {
        if (resourceConfig == null) {
            throw new IllegalArgumentException("Null resouce name");
        }
        URL urlConfig = Thread.currentThread().getContextClassLoader().getResource(resourceConfig);
        if (urlConfig == null) {
            throw new IllegalStateException("Cannot find resource: " + resourceConfig);
        }
        this.configure(urlConfig);
    }

    @Override
    public void configure(URL urlConfig) {
        if (urlConfig == null) {
            throw new IllegalArgumentException("Null config url");
        }
        Map<String, Object> props = this.getBootstrapProperties(urlConfig);
        this.initFrameworkInstance(props);
    }

    @Override
    public void configure(InputStream streamConfig) {
        Map<String, Object> props = this.getBootstrapProperties(streamConfig);
        this.initFrameworkInstance(props);
    }

    private void configureInternal(String resourceConfig) {
        Map<String, Object> props;
        if (resourceConfig == null) {
            throw new IllegalArgumentException("Null resouce name");
        }
        URL urlConfig = Thread.currentThread().getContextClassLoader().getResource(resourceConfig);
        if (urlConfig != null) {
            props = this.getBootstrapProperties(urlConfig);
        } else {
            props = new HashMap<String, Object>();
            log.debug((Object)"Bootstrap using framework defaults");
        }
        this.initFrameworkInstance(props);
    }

    private void initFrameworkInstance(final Map<String, Object> props) {
        Framework frameworkImpl = this.createFramework(props);
        this.framework = new GenericFrameworkWrapper<Framework>(frameworkImpl){

            @Override
            public void start() throws BundleException {
                Bundle bundle;
                super.start();
                BundleContext context = this.getBundleContext();
                if (context == null) {
                    throw new FrameworkException("Cannot obtain system context");
                }
                List autoInstall = PropertiesBootstrapProvider.this.getBundleURLs(props, PropertiesBootstrapProvider.PROP_OSGI_FRAMEWORK_AUTO_INSTALL);
                List autoStart = PropertiesBootstrapProvider.this.getBundleURLs(props, PropertiesBootstrapProvider.PROP_OSGI_FRAMEWORK_AUTO_START);
                HashMap<URL, Bundle> autoBundles = new HashMap<URL, Bundle>();
                for (URL bundleURL : autoStart) {
                    autoInstall.add(bundleURL);
                }
                PropertiesBootstrapProvider.this.registerSystemServices(context);
                for (URL bundleURL : autoInstall) {
                    bundle = context.installBundle(bundleURL.toString());
                    long bundleId = bundle.getBundleId();
                    log.info((Object)("Installed bundle [" + bundleId + "]: " + bundle.getSymbolicName()));
                    autoBundles.put(bundleURL, bundle);
                }
                for (URL bundleURL : autoStart) {
                    bundle = (Bundle)autoBundles.get(bundleURL);
                    if (bundle == null) continue;
                    bundle.start();
                    log.info((Object)("Started bundle: " + bundle.getSymbolicName()));
                }
            }

            @Override
            public void stop() throws BundleException {
                PropertiesBootstrapProvider.this.unregisterSystemServices(this.getBundleContext());
                super.stop();
            }
        };
        this.configured = true;
    }

    protected Framework createFramework(Map<String, Object> properties) {
        FrameworkFactory factory = ServiceLoader.loadService(FrameworkFactory.class);
        if (factory == null) {
            throw new IllegalStateException("Cannot load: META-INF/services/org.osgi.framework.launch.FrameworkFactory");
        }
        Framework framework = factory.newFramework(properties);
        return framework;
    }

    protected void registerSystemServices(BundleContext context) {
    }

    protected void unregisterSystemServices(BundleContext context) {
    }

    private List<URL> getBundleURLs(Map<String, Object> props, String key) {
        String bundleList = (String)props.get(key);
        if (bundleList == null) {
            bundleList = "";
        }
        ArrayList<URL> bundleURLs = new ArrayList<URL>();
        for (String bundle : bundleList.split("[, ]")) {
            if (bundle.trim().length() <= 0) continue;
            URL installURL = this.toURL(bundle);
            bundleURLs.add(installURL);
        }
        return bundleURLs;
    }

    private URL toURL(String path) {
        String realPath = StringPropertyReplacer.replaceProperties(path);
        try {
            URL pathURL = new URL(realPath);
            return pathURL;
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("Invalid path: " + path, ex);
        }
    }

    @Override
    public Framework getFramework() {
        if (!this.configured) {
            this.configureInternal(System.getProperty(OSGI_FRAMEWORK_CONFIG, DEFAULT_OSGI_FRAMEWORK_PROPERTIES));
        }
        return this.framework;
    }

    private Map<String, Object> getBootstrapProperties(URL urlConfig) {
        Map<String, Object> props = null;
        try {
            InputStream propStream = urlConfig.openStream();
            props = this.getBootstrapProperties(propStream);
            propStream.close();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot configure from: " + urlConfig, ex);
        }
        return props;
    }

    private Map<String, Object> getBootstrapProperties(InputStream propStream) {
        HashMap<String, Object> propMap;
        block12: {
            if (propStream == null) {
                throw new IllegalArgumentException("Null properties stream");
            }
            propMap = new HashMap<String, Object>();
            try {
                Properties props = new Properties();
                props.load(propStream);
                propStream.close();
                Enumeration<?> keys = props.propertyNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = props.getProperty(key);
                    value = StringPropertyReplacer.replaceProperties(value);
                    propMap.put(key, value);
                    if (!key.endsWith(".instance")) continue;
                    try {
                        String subkey = key.substring(0, key.lastIndexOf(".instance"));
                        Object instance = Class.forName(value).newInstance();
                        propMap.put(subkey, instance);
                    }
                    catch (Exception ex) {
                        log.error((Object)("Cannot load " + key + "=" + value), (Throwable)ex);
                    }
                }
                String extraPropsValue = (String)propMap.get(PROP_OSGI_FRAMEWORK_EXTRA);
                if (extraPropsValue == null) break block12;
                URL extraPropsURL = null;
                try {
                    extraPropsURL = new URL(extraPropsValue);
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                if (extraPropsURL == null) {
                    File propsFile = new File(extraPropsValue);
                    try {
                        extraPropsURL = propsFile.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                }
                if (extraPropsURL == null) {
                    throw new IllegalStateException("Invalid properties URL: " + extraPropsValue);
                }
                propMap.remove(PROP_OSGI_FRAMEWORK_EXTRA);
                Map<String, Object> extraProps = this.getBootstrapProperties(extraPropsURL.openStream());
                propMap.putAll(extraProps);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot load properties", ex);
            }
        }
        return propMap;
    }

    static {
        internalProps.add(PROP_OSGI_FRAMEWORK_AUTO_INSTALL);
        internalProps.add(PROP_OSGI_FRAMEWORK_AUTO_START);
        internalProps.add(PROP_OSGI_FRAMEWORK_EXTRA);
    }
}

