/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.jboss.osgi.vfs.VFSAdaptor;
import org.jboss.osgi.vfs.VFSMessages;
import org.jboss.osgi.vfs.VirtualFile;

public abstract class AbstractVFS {
    private static VFSAdaptor adaptor;

    public static VirtualFile toVirtualFile(URI uri) throws IOException {
        return AbstractVFS.getVFSAdaptor().toVirtualFile(uri);
    }

    public static VirtualFile toVirtualFile(URL url) throws IOException {
        return AbstractVFS.getVFSAdaptor().toVirtualFile(url);
    }

    public static VirtualFile toVirtualFile(String name, InputStream input) throws IOException {
        return AbstractVFS.getVFSAdaptor().toVirtualFile(name, input);
    }

    public static VirtualFile toVirtualFile(InputStream input) throws IOException {
        return AbstractVFS.getVFSAdaptor().toVirtualFile(input);
    }

    public static VirtualFile adapt(Object virtualFile) {
        return AbstractVFS.getVFSAdaptor().adapt(virtualFile);
    }

    public static Object adapt(VirtualFile virtualFile) throws IOException {
        return AbstractVFS.getVFSAdaptor().adapt(virtualFile);
    }

    private static VFSAdaptor getVFSAdaptor() {
        if (adaptor == null) {
            Class<?> adaptorClass = null;
            try {
                String adaptorName = "org.jboss.osgi.vfs30.VFSAdaptor30";
                adaptorClass = AbstractVFS.class.getClassLoader().loadClass(adaptorName);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (adaptorClass == null) {
                throw VFSMessages.MESSAGES.illegalStateCannotLoadAdaptor();
            }
            try {
                adaptor = (VFSAdaptor)adaptorClass.newInstance();
            }
            catch (Exception ex) {
                throw VFSMessages.MESSAGES.illegalStateCannotCreateAdaptor(ex);
            }
        }
        return adaptor;
    }
}

