/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKitFactory;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.faces.BridgeException;
import org.jboss.portletbridge.BridgeConfig;
import org.jboss.portletbridge.FaceletsStrategy;
import org.jboss.portletbridge.PlainJsfStrategy;
import org.jboss.portletbridge.richfaces.RichFacesStrategy;
import org.jboss.portletbridge.seam.SeamStrategy;
import org.jboss.portletbridge.util.BridgeLogger;

public abstract class BridgeStrategy {
    private static final String SERVICE_CLASSPATH = "META-INF/services/" + BridgeStrategy.class.getName();
    public static final Logger log = BridgeLogger.BRIDGE.getLogger();
    protected final BridgeConfig config;

    public BridgeStrategy(BridgeConfig config) {
        this.config = config;
    }

    public BridgeConfig getConfig() {
        return this.config;
    }

    public abstract void init(FacesContext var1, RenderKitFactory var2);

    public abstract void beforeActionRequest(FacesContext var1);

    public abstract void afterActionRequestExecute(FacesContext var1);

    public abstract void afterActionRequest(FacesContext var1);

    public abstract void beforeEventRequest(FacesContext var1);

    public abstract void afterEventRequest(FacesContext var1);

    public abstract void beforeRenderRequest(FacesContext var1);

    public abstract void afterRenderRequest(FacesContext var1, RenderResponse var2);

    public abstract void beforeResourceRequest(FacesContext var1);

    public abstract void afterResourceRequestExecute(FacesContext var1);

    public abstract void afterResourceRequest(FacesContext var1, ResourceResponse var2);

    public abstract RenderResponse createResponseWrapper(RenderResponse var1);

    public abstract boolean serveResource(ResourceRequest var1, ResourceResponse var2) throws BridgeException;

    public abstract ResourceResponse createResponseWrapper(ResourceResponse var1);

    public abstract int getPortletSessionScopeForName(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BridgeStrategy getCurrentStrategy(BridgeConfig config) throws BridgeException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (null == loader) {
            loader = BridgeStrategy.class.getClassLoader();
        }
        BridgeStrategy strategy = new PlainJsfStrategy(config);
        strategy = BridgeStrategy.createStrategyInstance(config, strategy, loader, RichFacesStrategy.class.getName());
        strategy = BridgeStrategy.createStrategyInstance(config, strategy, loader, FaceletsStrategy.class.getName());
        strategy = BridgeStrategy.createStrategyInstance(config, strategy, loader, SeamStrategy.class.getName());
        try {
            Enumeration<URL> resources = loader.getResources(SERVICE_CLASSPATH);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                InputStream stream = null;
                try {
                    String strategyClassName;
                    URLConnection connection = resource.openConnection();
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                    BufferedReader reader = null;
                    try {
                        reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        reader = new BufferedReader(new InputStreamReader(stream));
                    }
                    while (null != (strategyClassName = reader.readLine())) {
                        int indexOfComment = strategyClassName.indexOf(35);
                        if (indexOfComment >= 0) {
                            strategyClassName = strategyClassName.substring(0, indexOfComment);
                        }
                        if ((strategyClassName = strategyClassName.trim()).length() <= 0) continue;
                        strategy = BridgeStrategy.createStrategyInstance(config, strategy, loader, strategyClassName);
                    }
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Error reading bridge service definition file", e);
                }
                catch (SecurityException e) {
                    log.log(Level.SEVERE, "Error reading bridge service definition file", e);
                }
                finally {
                    if (null == stream) continue;
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        log.log(Level.SEVERE, "Error to close input stream for a resource " + SERVICE_CLASSPATH, e);
                    }
                }
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Error geting strategy service definition resources", e);
        }
        return strategy;
    }

    private static BridgeStrategy createStrategyInstance(BridgeConfig config, BridgeStrategy strategy, ClassLoader loader, String className) throws BridgeException {
        try {
            Class<BridgeStrategy> strategyClass = loader.loadClass(className).asSubclass(BridgeStrategy.class);
            try {
                Constructor<BridgeStrategy> constructor = strategyClass.getConstructor(BridgeConfig.class, BridgeStrategy.class);
                strategy = constructor.newInstance(config, strategy);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("New strategy instance " + className + " has been created with parent strategy");
                }
            }
            catch (NoSuchMethodException e) {
                Constructor<BridgeStrategy> constructor = strategyClass.getConstructor(BridgeConfig.class);
                strategy = constructor.newInstance(config);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("New strategy instance " + className + " has been created");
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new BridgeException("Bridge Strategy class " + className + " not found");
        }
        catch (NoSuchMethodException e) {
            throw new BridgeException("Bridge Strategy " + className + " has never BridgeStrategy(BridgeConfig) nor BridgeStrategy(BridgeConfig,BridgeStrategy) constructor");
        }
        catch (IllegalArgumentException e) {
            throw new BridgeException("Illegal argument for Bridge Strategy " + className + " constructor", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BridgeException("Can't instantiate Bridge Strategy class " + className, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BridgeException("Illegal access to Bridge Strategy constructor", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof NoClassDefFoundError) {
                log.info("Bridge Strategy was not activated due to " + targetException.getMessage());
            }
            throw new BridgeException("Can't instantiate Bridge Strategy class " + className, targetException);
        }
        catch (NoClassDefFoundError e) {
            log.info("Bridge Strategy was not activated due to " + e.getMessage());
        }
        return strategy;
    }
}

