/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge;

import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portletbridge.BridgeRequestScope;
import org.jboss.portletbridge.ExceptionHandlerBase;
import org.jboss.portletbridge.context.PortletBridgeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandlerImpl
extends ExceptionHandlerBase {
    protected static final Log log = LogFactory.getLog(ExceptionHandlerImpl.class);

    @Override
    protected String processException(FacesContext facesContext, BridgeRequestScope windowState, Exception e) {
        PortletBridgeContext bridgeContext = PortletBridgeContext.getCurrentInstance(facesContext);
        Map<Class<? extends Throwable>, String> errorPages = bridgeContext.getBridgeConfig().getErrorPages();
        return this.getErrorPage(e, errorPages);
    }

    protected String getErrorPage(Throwable e, Map<Class<? extends Throwable>, String> errorPages) {
        Throwable cause = this.getCause(e);
        String errorPage = null;
        if (null != cause && null != (errorPage = this.getErrorPage(cause, errorPages))) {
            return errorPage;
        }
        for (Class<? extends Throwable> errorClass : errorPages.keySet()) {
            if (!errorClass.isInstance(e) || !errorPages.containsKey(errorClass)) continue;
            errorPage = errorPages.get(errorClass);
        }
        return errorPage;
    }

    protected Throwable getCause(Throwable exception) {
        Throwable cause = null;
        cause = exception instanceof ServletException ? ((ServletException)exception).getRootCause() : exception.getCause();
        return cause;
    }
}

