/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.jboss.portletbridge.BridgeRequestScope;
import org.jboss.portletbridge.StateId;
import org.jboss.portletbridge.context.PortalActionURL;
import org.jboss.portletbridge.util.BridgeLogger;

public class RequestScopeManager
implements Serializable {
    public static final String REQUEST_STATE_MANAGER = RequestScopeManager.class.getName();
    private static final Logger log = BridgeLogger.BRIDGE.getLogger();
    public static final String WINDOW_ID_RETRIVER = "org.jboss.portletbridge.WINDOW_ID_RETRIVER";
    public static final String STATE_ID_PARAMETER = "javax.faces.portletbridge.STATE_ID";
    public static final int DEFAULT_MAX_MANAGED_SCOPES = 1000;
    private final Map<StateId, BridgeRequestScope> states;

    private RequestScopeManager(int max) {
        this.states = new LRUMap<StateId, BridgeRequestScope>(max);
    }

    public static synchronized RequestScopeManager getInstance(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Map sessionMap = externalContext.getSessionMap();
        RequestScopeManager requestStateManager = (RequestScopeManager)sessionMap.get(REQUEST_STATE_MANAGER);
        if (null == requestStateManager) {
            int maxScopes = 1000;
            String maxScopesParameter = externalContext.getInitParameter("javax.portlet.faces.MAX_MANAGED_REQUEST_SCOPES");
            if (null != maxScopesParameter) {
                maxScopes = Integer.parseInt(maxScopesParameter);
            }
            requestStateManager = new RequestScopeManager(maxScopes);
            sessionMap.put(REQUEST_STATE_MANAGER, requestStateManager);
        }
        return requestStateManager;
    }

    public static synchronized RequestScopeManager getInstance(PortletRequest request, int maxScopes) {
        PortletSession session = request.getPortletSession(true);
        RequestScopeManager requestStateManager = (RequestScopeManager)session.getAttribute(REQUEST_STATE_MANAGER);
        if (null == requestStateManager) {
            requestStateManager = new RequestScopeManager(maxScopes);
            session.setAttribute(REQUEST_STATE_MANAGER, (Object)requestStateManager);
        }
        return requestStateManager;
    }

    public void saveRequestScope(StateId stateId, BridgeRequestScope state) {
        this.states.put(stateId, state);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (null != facesContext) {
            facesContext.getExternalContext().getSessionMap().put(REQUEST_STATE_MANAGER, this);
        }
    }

    public BridgeRequestScope getRequestScope(StateId stateId) {
        BridgeRequestScope state = null;
        if (null != stateId) {
            state = this.states.get(stateId);
        }
        return state;
    }

    public StateId getStateId(ActionRequest request, ActionResponse response) {
        return this.getStateIdForAction((PortletRequest)request);
    }

    public StateId getStateId(EventRequest request, EventResponse response) {
        return this.getStateIdForAction((PortletRequest)request);
    }

    public StateId getStateId(RenderRequest request, RenderResponse response) {
        return this.getStateIdForRender((PortletRequest)request, (PortletResponse)response);
    }

    public StateId getStateId(ResourceRequest request, ResourceResponse response) {
        return this.getStateIdForRender((PortletRequest)request, (PortletResponse)response);
    }

    private StateId getStateIdForAction(PortletRequest request) {
        UUID uuid = UUID.randomUUID();
        PortletMode portletMode = request.getPortletMode();
        StateId stateId = new StateId(portletMode, uuid.toString());
        return stateId;
    }

    private StateId getStateIdForRender(PortletRequest request, PortletResponse response) {
        PortletMode portletMode = request.getPortletMode();
        StateId stateId = null;
        PortletSession session = request.getPortletSession(false);
        String stateIdParameter = request.getParameter(STATE_ID_PARAMETER);
        if (null == stateIdParameter) {
            stateId = this.getStateIdFromViewHistory(portletMode, session);
        } else {
            stateId = new StateId(stateIdParameter);
            if (!portletMode.equals((Object)stateId.getMode())) {
                StateId historyStateId = this.getStateIdFromViewHistory(portletMode, session);
                if (null != historyStateId) {
                    stateId = historyStateId;
                } else {
                    stateId.setMode(portletMode);
                }
            }
        }
        if (null == stateId) {
            stateId = new StateId(portletMode, response.getNamespace());
        }
        return stateId;
    }

    private StateId getStateIdFromViewHistory(PortletMode portletModeName, PortletSession session) {
        String modeViewId;
        StateId stateId = null;
        if (null != session && null != (modeViewId = (String)session.getAttribute("javax.portlet.faces.viewIdHistory." + portletModeName))) {
            try {
                PortalActionURL viewUrl = new PortalActionURL(modeViewId);
                String stateIdParameter = viewUrl.getParameter(STATE_ID_PARAMETER);
                if (null != stateIdParameter) {
                    stateId = new StateId(stateIdParameter);
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return stateId;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LRUMap<K, V>
    extends LinkedHashMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = -7232885382582796665L;
        private int capacity;

        public LRUMap(int capacity) {
            super(capacity, 1.0f, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
            return this.size() > this.capacity;
        }

        public Object getMostRecent() {
            Iterator iterator = this.values().iterator();
            Object mostRecent = null;
            while (iterator.hasNext()) {
                mostRecent = iterator.next();
            }
            return mostRecent;
        }
    }
}

