/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context;

import javax.portlet.MimeResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.ResourceURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.jboss.portletbridge.context.PortalActionURL;
import org.jboss.portletbridge.context.PortletExternalContextImpl;
import org.jboss.portletbridge.util.PlatformUtil;

public abstract class MimeExternalContextImpl
extends PortletExternalContextImpl {
    public MimeExternalContextImpl(PortletContext context, PortletRequest request, MimeResponse response) {
        super(context, request, (PortletResponse)response);
    }

    public PortletRequest getRequest() {
        return super.getRequest();
    }

    public MimeResponse getResponse() {
        return (MimeResponse)super.getResponse();
    }

    public String getResponseCharacterEncoding() {
        return this.getResponse().getCharacterEncoding();
    }

    public String getResponseContentType() {
        return this.getResponse().getContentType();
    }

    protected String getNamespace() {
        return this.getResponse().getNamespace();
    }

    protected String createActionUrl(PortalActionURL url) {
        String viewId = this.getViewIdFromUrl(url);
        MimeResponse renderResponse = this.getResponse();
        PortletURL portletURL = renderResponse.createActionURL();
        portletURL.setParameter("_jsfBridgeViewId", viewId);
        for (String key : url.getParameters().keySet()) {
            String value = url.getParameter(key);
            if ("javax.portlet.faces.PortletMode".equals(key)) {
                PortletMode mode = new PortletMode(value);
                try {
                    portletURL.setPortletMode(mode);
                }
                catch (PortletModeException e) {}
                continue;
            }
            if ("javax.portlet.faces.WindowState".equals(key)) {
                try {
                    WindowState state = new WindowState(value);
                    portletURL.setWindowState(state);
                }
                catch (WindowStateException e) {}
                continue;
            }
            if ("javax.portlet.faces.Secure".equals(key)) {
                try {
                    portletURL.setSecure(Boolean.getBoolean(value));
                }
                catch (PortletSecurityException e) {}
                continue;
            }
            portletURL.setParameter(key, value);
        }
        return portletURL.toString();
    }

    protected String createResourceUrl(PortalActionURL portalUrl) {
        MimeResponse renderResponse = this.getResponse();
        ResourceURL resourceURL = PlatformUtil.createResourceURL(renderResponse);
        portalUrl.removeParameter("javax.portlet.faces.PortletMode");
        portalUrl.removeParameter("javax.portlet.faces.WindowState");
        String secure = portalUrl.getParameter("javax.portlet.faces.Secure");
        if (null != secure) {
            try {
                if ("true".equalsIgnoreCase(secure)) {
                    resourceURL.setSecure(true);
                } else if ("false".equalsIgnoreCase(secure)) {
                    resourceURL.setSecure(false);
                }
            }
            catch (PortletSecurityException e) {
                // empty catch block
            }
            portalUrl.removeParameter("javax.portlet.faces.Secure");
        }
        resourceURL.setResourceID(portalUrl.getPath());
        resourceURL.setParameters(portalUrl.getParameters());
        return resourceURL.toString();
    }
}

