/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.Lifecycle;
import javax.portlet.PortletRequest;
import org.jboss.portletbridge.BridgeConfig;
import org.jboss.portletbridge.BridgeRequestScope;
import org.jboss.portletbridge.StateId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletBridgeContext {
    public static final String REQUEST_PARAMETER_NAME = PortletBridgeContext.class.getName();
    private Set<String> initialRequestAttributeNames;
    private String redirectViewId;
    private Map<String, String[]> redirectRequestParameters;
    private StateId stateId;
    private final BridgeConfig bridgeConfig;
    private BridgeRequestScope requestScope;
    private Map<String, String[]> viewIdParameters;

    public PortletBridgeContext(BridgeConfig bridgeConfig) {
        this.bridgeConfig = bridgeConfig;
    }

    public static PortletBridgeContext getCurrentInstance(FacesContext context) {
        return (PortletBridgeContext)context.getExternalContext().getRequestMap().get(REQUEST_PARAMETER_NAME);
    }

    public void reset() {
        this.requestScope = null;
        this.redirectViewId = null;
        this.stateId = null;
        this.redirectRequestParameters = null;
    }

    public Set<String> getInitialRequestAttributeNames() {
        return this.initialRequestAttributeNames;
    }

    public void setInitialRequestAttributeNames(Enumeration names) {
        this.initialRequestAttributeNames = new HashSet<String>();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            this.initialRequestAttributeNames.add(name);
        }
    }

    public void resetRequestAttributes(PortletRequest request) {
        Set<String> initialAttributes = this.getInitialRequestAttributeNames();
        ArrayList<String> currentAttributes = Collections.list(request.getAttributeNames());
        currentAttributes.removeAll(initialAttributes);
        for (String newAttribute : currentAttributes) {
            request.removeAttribute(newAttribute);
        }
    }

    public String getRedirectViewId() {
        return this.redirectViewId;
    }

    public void setRedirectViewId(String redirectViewId) {
        this.redirectViewId = redirectViewId;
    }

    public Map<String, String[]> getRedirectRequestParameters() {
        return this.redirectRequestParameters;
    }

    public void setRedirectRequestParameters(Map<String, String[]> redirectRequestParameters) {
        this.redirectRequestParameters = redirectRequestParameters;
    }

    public StateId getStateId() {
        return this.stateId;
    }

    public void setStateId(StateId stateId) {
        this.stateId = stateId;
    }

    public BridgeConfig getBridgeConfig() {
        return this.bridgeConfig;
    }

    public BridgeRequestScope getRequestScope() {
        return this.requestScope;
    }

    public void setRequestScope(BridgeRequestScope windowState) {
        this.requestScope = windowState;
    }

    public Map<String, String[]> getViewIdParameters() {
        return this.viewIdParameters;
    }

    public void setViewIdParameters(Map<String, String[]> viewIdParameters) {
        this.viewIdParameters = viewIdParameters;
    }

    public void render(FacesContext context) {
        Lifecycle lifecycle = this.getBridgeConfig().getFacesLifecycle();
        lifecycle.execute(context);
        if (!context.getResponseComplete()) {
            lifecycle.render(context);
        }
    }
}

