/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.richfaces;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.portlet.MimeResponse;
import javax.portlet.ResourceURL;
import javax.portlet.faces.BridgeUtil;
import org.ajax4jsf.Messages;
import org.ajax4jsf.resource.FacesResourceContext;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.resource.ResourceNotFoundException;
import org.ajax4jsf.resource.ResourceRenderer;
import org.ajax4jsf.resource.ScriptRenderer;
import org.ajax4jsf.resource.TemplateCSSRenderer;
import org.ajax4jsf.util.base64.Codec;
import org.jboss.portletbridge.richfaces.PortletScriptRenderer;
import org.jboss.portletbridge.richfaces.PotrletTemplateCSSRenderer;
import org.jboss.portletbridge.util.BridgeLogger;
import org.jboss.portletbridge.util.PlatformUtil;

public class PortletResourceBuilder
extends InternetResourceBuilder {
    public static final String RFRES = "/org.rf.res";
    private static final int RFRES_LENGTH = "/org.rf.res".length();
    private static final String DATA_SEPARATOR = "/DA/";
    private static final String DATA_BYTES_SEPARATOR = "/DB/";
    static final Pattern RESOURCE_PATTERN = Pattern.compile("^/org.rf.res(.+)(?:/D(A|B)/(.*))$");
    private static final Logger log = BridgeLogger.AJAX.getLogger();
    private final InternetResourceBuilder parent;
    private final ResourceRenderer scriptRenderer;
    private final Codec codec = new Codec();
    private static final String[] specialResources = new String[]{"/tiny_mce/", "scripts/editor.js", "org/richfaces/renderkit/html/1$1"};

    public PortletResourceBuilder(InternetResourceBuilder parent) {
        this.parent = parent;
        this.scriptRenderer = new PortletScriptRenderer(parent.getScriptRenderer());
    }

    public String getUri(InternetResource resource, FacesContext context, Object storeData) {
        if (BridgeUtil.isPortletRequest() && !this.specialResource(resource)) {
            Object response = context.getExternalContext().getResponse();
            if (response instanceof MimeResponse) {
                MimeResponse mimeResponse = (MimeResponse)response;
                ResourceURL resourceURL = PlatformUtil.createResourceURL(mimeResponse);
                FacesResourceContext resourceContext = new FacesResourceContext(context);
                resourceContext.setResourceData(storeData);
                if (resource.isCacheable((ResourceContext)resourceContext)) {
                    // empty if block
                }
                StringBuffer uri = new StringBuffer(RFRES);
                uri.append(resource.getKey());
                if (storeData != null) {
                    try {
                        byte[] objectData;
                        if (storeData instanceof byte[]) {
                            objectData = (byte[])storeData;
                            uri.append(DATA_BYTES_SEPARATOR);
                        } else {
                            ByteArrayOutputStream dataSteram = new ByteArrayOutputStream(1024);
                            ObjectOutputStream objStream = new ObjectOutputStream(dataSteram);
                            objStream.writeObject(storeData);
                            objStream.flush();
                            objStream.close();
                            dataSteram.close();
                            objectData = dataSteram.toByteArray();
                            uri.append(DATA_SEPARATOR);
                        }
                        byte[] dataArray = this.encrypt(objectData);
                        uri.append(new String(dataArray, "ISO-8859-1"));
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, Messages.getMessage((String)"QUERY_STRING_BUILDING_ERROR"), e);
                    }
                }
                resourceURL.setResourceID(uri.toString());
                return resourceURL.toString().replaceAll("\\&amp\\;", "&");
            }
            return "/JBossPortletBridge/resourceUrl/do/nothing";
        }
        return this.parent.getUri(resource, context, storeData);
    }

    private boolean specialResource(InternetResource resource) {
        String key = resource.getKey();
        for (String special : specialResources) {
            if (!key.contains(special)) continue;
            return true;
        }
        return false;
    }

    public InternetResource getResourceForKey(String resourceId) throws ResourceNotFoundException {
        String key;
        Matcher matcher = RESOURCE_PATTERN.matcher(resourceId);
        if (matcher.matches()) {
            key = matcher.group(1);
        } else if (resourceId.startsWith(RFRES)) {
            key = resourceId.substring(RFRES_LENGTH);
        } else {
            throw new ResourceNotFoundException();
        }
        InternetResource resource = this.parent.getResourceForKey(key);
        this.checkRenderer(resource);
        return resource;
    }

    public Object getResourceDataForKey(String key) {
        Object data;
        block11: {
            data = null;
            if (null != key) {
                Matcher matcher = RESOURCE_PATTERN.matcher(key);
                if (matcher.matches()) {
                    String dataString = matcher.group(3);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(Messages.getMessage((String)"RESTORE_DATA_FROM_RESOURCE_URI_INFO", (Object)key, (Object)dataString));
                    }
                    byte[] objectArray = null;
                    try {
                        byte[] dataArray = dataString.getBytes("ISO-8859-1");
                        objectArray = this.decrypt(dataArray);
                        if ("B".equals(matcher.group(2))) {
                            data = objectArray;
                            break block11;
                        }
                        try {
                            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(objectArray));
                            data = in.readObject();
                        }
                        catch (StreamCorruptedException e) {
                            log.log(Level.SEVERE, Messages.getMessage((String)"STREAM_CORRUPTED_ERROR"), e);
                        }
                        catch (IOException e) {
                            log.log(Level.SEVERE, Messages.getMessage((String)"DESERIALIZE_DATA_INPUT_ERROR"), e);
                        }
                        catch (ClassNotFoundException e) {
                            log.log(Level.SEVERE, Messages.getMessage((String)"DATA_CLASS_NOT_FOUND_ERROR"), e);
                        }
                    }
                    catch (UnsupportedEncodingException e1) {}
                } else {
                    data = this.parent.getResourceDataForKey(key);
                }
            }
        }
        return data;
    }

    protected byte[] encrypt(byte[] src) {
        try {
            Deflater compressor = new Deflater(1);
            byte[] compressed = new byte[src.length + 100];
            compressor.setInput(src);
            compressor.finish();
            int totalOut = compressor.deflate(compressed);
            byte[] zipsrc = new byte[totalOut];
            System.arraycopy(compressed, 0, zipsrc, 0, totalOut);
            compressor.end();
            return this.codec.encode(zipsrc);
        }
        catch (Exception e) {
            throw new FacesException("Error encode resource data", (Throwable)e);
        }
    }

    protected byte[] decrypt(byte[] src) {
        try {
            byte[] zipsrc = this.codec.decode(src);
            Inflater decompressor = new Inflater();
            byte[] uncompressed = new byte[zipsrc.length * 5];
            decompressor.setInput(zipsrc);
            int totalOut = decompressor.inflate(uncompressed);
            byte[] out = new byte[totalOut];
            System.arraycopy(uncompressed, 0, out, 0, totalOut);
            decompressor.end();
            return out;
        }
        catch (Exception e) {
            throw new FacesException("Error decode resource data", (Throwable)e);
        }
    }

    public void addResource(String key, InternetResource resource) {
        this.checkRenderer(resource);
        this.parent.addResource(key, resource);
    }

    public InternetResource createResource(Object base, String path) throws FacesException {
        InternetResource resource = this.parent.createResource(base, path);
        this.checkRenderer(resource);
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRenderer(InternetResource resource) {
        if (null != resource) {
            InternetResource internetResource = resource;
            synchronized (internetResource) {
                ResourceRenderer resourceRenderer = resource.getRenderer(null);
                if (null != resourceRenderer) {
                    if (resourceRenderer instanceof ScriptRenderer) {
                        resource.setRenderer((ResourceRenderer)new PortletScriptRenderer(resourceRenderer));
                    } else if (TemplateCSSRenderer.class.equals(resourceRenderer.getClass())) {
                        resource.setRenderer((ResourceRenderer)new PotrletTemplateCSSRenderer());
                    }
                }
            }
        }
    }

    public InternetResource createUserResource(boolean cacheable, boolean session, String mime) throws FacesException {
        return this.parent.createUserResource(cacheable, session, mime);
    }

    public InternetResource getResource(String path) throws ResourceNotFoundException {
        InternetResource resource = this.parent.getResource(path);
        this.checkRenderer(resource);
        return resource;
    }

    public ResourceRenderer getScriptRenderer() {
        return this.scriptRenderer;
    }

    public long getStartTime() {
        return this.parent.getStartTime();
    }

    public ResourceRenderer getStyleRenderer() {
        return this.parent.getStyleRenderer();
    }

    public void init() throws FacesException {
        this.parent.init();
    }
}

