/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.richfaces;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.portlet.MimeResponse;
import javax.portlet.PortletContext;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.faces.BridgeException;
import javax.servlet.http.HttpServletRequest;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.context.ViewResources;
import org.ajax4jsf.request.MultipartRequest;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.resource.ResourceLifecycle;
import org.ajax4jsf.resource.ResourceNotFoundException;
import org.ajax4jsf.webapp.WebXml;
import org.ajax4jsf.xml.serializer.OutputPropertiesFactory;
import org.ajax4jsf.xml.serializer.Serializer;
import org.ajax4jsf.xml.serializer.SerializerFactory;
import org.ajax4jsf.xml.serializer.TreeWalker;
import org.jboss.portletbridge.BridgeConfig;
import org.jboss.portletbridge.BridgeStrategy;
import org.jboss.portletbridge.BufferedMimeResponseWrapper;
import org.jboss.portletbridge.StateId;
import org.jboss.portletbridge.component.UIPortletAjaxViewRoot;
import org.jboss.portletbridge.context.PortletBridgeContext;
import org.jboss.portletbridge.renderkit.portlet.PortletAjaxViewRootRenderer;
import org.jboss.portletbridge.richfaces.BufferedRenderResponseWrapper;
import org.jboss.portletbridge.richfaces.BufferedResourceResponseWrapper;
import org.jboss.portletbridge.richfaces.PortletFacesResourceContext;
import org.jboss.portletbridge.richfaces.PortletResourceBuilder;
import org.jboss.portletbridge.richfaces.PortletResourceContext;
import org.jboss.portletbridge.richfaces.PortletWebXml;
import org.jboss.portletbridge.richfaces.PortletXMLFilter;
import org.jboss.portletbridge.richfaces.ResourceRequestWrapper;
import org.jboss.portletbridge.util.BridgeLogger;
import org.richfaces.component.FileUploadConstants;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RichFacesStrategy
extends BridgeStrategy {
    private static final String XML_CONTENT = "text/xml;charset=UTF-8";
    private static final String HTML_EPILOG = "</body></html>";
    private static final byte[] HTML_EPILOG_BYTES = "</body></html>".getBytes();
    private static final String HTML_BODY = "</head><body>";
    private static final byte[] HTML_BODY_BYTES = "</head><body>".getBytes();
    private static final String HTML_PROLOG = "<html xmlns=\"http://www.w3.org/1999/xhtml\"><head>";
    private static final byte[] HTML_PROLOG_BYTES = "<html xmlns=\"http://www.w3.org/1999/xhtml\"><head>".getBytes();
    private static final Logger log = BridgeLogger.BRIDGE.getLogger();
    public static final String RICHFACES_RESOURCE = "org.jboss.portletbridge.richfaces.Resource";
    public static final String AJAX4JSF_FILTER = "org.ajax4jsf.Filter";
    public static final String SEAM_FILTER = "org.jboss.seam.servlet.SeamFilter";
    public static final String PARAM_CREATE_TEMP_FILES = "createTempFiles";
    public static final String PARAM_MAX_REQUEST_SIZE = "maxRequestSize";
    private final ResourceLifecycle lifecycle;
    private final PortletXMLFilter xmlFilter;
    private InternetResourceBuilder resourceBuilder;
    private boolean uploadToTempDir = false;
    private int uploadLimit = 0;
    public static final String MULTIPART = "multipart/";

    public RichFacesStrategy(BridgeConfig config) {
        super(config);
        AjaxContext.class.getName();
        this.lifecycle = new ResourceLifecycle();
        this.xmlFilter = new PortletXMLFilter();
        PortletContext portletContext = config.getPortletConfig().getPortletContext();
        this.xmlFilter.init(portletContext);
        this.resourceBuilder = InternetResourceBuilder.getInstance();
        if (!(this.resourceBuilder instanceof PortletResourceBuilder)) {
            this.resourceBuilder = new PortletResourceBuilder(this.resourceBuilder);
            InternetResourceBuilder.setInstance((InternetResourceBuilder)this.resourceBuilder);
        }
        WebXml webXml = (WebXml)portletContext.getAttribute(WebXml.CONTEXT_ATTRIBUTE);
        portletContext.setAttribute(WebXml.CONTEXT_ATTRIBUTE, (Object)new PortletWebXml(webXml));
        Map<String, String> filterInitParams = config.getFilterInitParams(AJAX4JSF_FILTER);
        if (filterInitParams == null) {
            filterInitParams = config.getFilterInitParams(SEAM_FILTER);
        }
        if (filterInitParams != null) {
            String uploadToTempDirStr = filterInitParams.get(PARAM_CREATE_TEMP_FILES);
            this.uploadToTempDir = uploadToTempDirStr != null && uploadToTempDirStr.toLowerCase().equals("true");
            String maxRequestSizeStr = filterInitParams.get(PARAM_MAX_REQUEST_SIZE);
            if (maxRequestSizeStr != null) {
                try {
                    this.uploadLimit = Integer.parseInt(maxRequestSizeStr);
                }
                catch (NumberFormatException nfe) {
                    log.warning("invalid Filter init parameter value in web.xml: maxRequestSize - " + maxRequestSizeStr);
                }
            }
        }
    }

    private void finishResponse(FacesContext facesContext, BufferedMimeResponseWrapper wrappedResponse) {
        try {
            AjaxContext ajaxContext;
            Map requestMap = facesContext.getExternalContext().getRequestMap();
            if (!Boolean.TRUE.equals(requestMap.get("org.ajax4jsf.framework.HEADER_PROCESSED"))) {
                ViewResources viewResources = new ViewResources();
                viewResources.initialize(facesContext);
                viewResources.processHeadResources(facesContext);
                requestMap.put("org.ajax4jsf.framework.HEAD_EVENTS_LIST", viewResources.getHeadEvents());
                requestMap.put("org.ajax4jsf.framework.HEADER_PROCESSED", Boolean.TRUE);
            }
            if ((ajaxContext = AjaxContext.getCurrentInstance((FacesContext)facesContext)).isAjaxRequest(facesContext)) {
                this.writeAjaxContent(facesContext, wrappedResponse);
            } else {
                this.writeContent(facesContext, wrappedResponse);
            }
        }
        catch (Exception e) {
            throw new BridgeException((Throwable)e);
        }
    }

    private void writeAjaxContent(FacesContext facesContext, BufferedMimeResponseWrapper wrappedResponse) throws IOException, SAXException {
        this.xmlFilter.writeContent(facesContext, wrappedResponse);
    }

    private void writeContent(FacesContext facesContext, BufferedMimeResponseWrapper wrappedResponse) throws IOException, SAXException {
        this.writeHeadEvents(facesContext, wrappedResponse);
        wrappedResponse.writeBufferedData();
    }

    private void writeHeadEvents(FacesContext facesContext, BufferedMimeResponseWrapper wrappedResponse) throws IOException, SAXException {
        Object headEvents = facesContext.getExternalContext().getRequestMap().get("org.ajax4jsf.framework.HEAD_EVENTS_LIST");
        if (headEvents != null) {
            Node[] nodes = (Node[])headEvents;
            Properties xhtmlProperties = OutputPropertiesFactory.getDefaultMethodProperties((String)"xhtml");
            Serializer serializer = SerializerFactory.getSerializer((Properties)xhtmlProperties);
            MimeResponse response = wrappedResponse.getResponse();
            if (wrappedResponse.isUseWriter()) {
                serializer.setWriter((Writer)response.getWriter());
            } else {
                serializer.setOutputStream(response.getPortletOutputStream());
            }
            ContentHandler contentHandler = serializer.asContentHandler();
            TreeWalker treeWalker = new TreeWalker(contentHandler);
            contentHandler.startDocument();
            for (Node node : nodes) {
                treeWalker.traverseFragment(node);
            }
            contentHandler.endDocument();
        }
    }

    public void init(FacesContext context, RenderKitFactory renderKitFactory) {
        PortletAjaxViewRootRenderer ajaxRenderer = new PortletAjaxViewRootRenderer();
        Iterator renderKitIds = renderKitFactory.getRenderKitIds();
        while (renderKitIds.hasNext()) {
            String renderKitId = (String)renderKitIds.next();
            RenderKit renderKit = renderKitFactory.getRenderKit(context, renderKitId);
            renderKit.addRenderer("javax.faces.ViewRoot", "javax.faces.ViewRoot", (Renderer)ajaxRenderer);
        }
        context.getApplication().addComponent("javax.faces.ViewRoot", UIPortletAjaxViewRoot.class.getName());
    }

    public void beforeRenderRequest(FacesContext facesContext) {
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)facesContext);
        StateId stateId = PortletBridgeContext.getCurrentInstance(facesContext).getStateId();
        ajaxContext.getCommonAjaxParameters().put("javax.faces.portletbridge.STATE_ID", stateId.toString());
    }

    public RenderResponse createResponseWrapper(RenderResponse response) {
        return new BufferedRenderResponseWrapper(response);
    }

    public ResourceResponse createResponseWrapper(ResourceResponse response) {
        return new BufferedResourceResponseWrapper(response);
    }

    public void afterRenderRequest(FacesContext facesContext, RenderResponse wrappedResponse) {
        this.finishResponse(facesContext, (BufferedMimeResponseWrapper)wrappedResponse);
    }

    public void afterResourceRequest(FacesContext facesContext, ResourceResponse wrappedResponse) {
        this.finishResponse(facesContext, (BufferedMimeResponseWrapper)wrappedResponse);
    }

    public boolean serveResource(ResourceRequest request, ResourceResponse response) throws BridgeException {
        String resourceKey = request.getResourceID();
        if (null != resourceKey) {
            try {
                InternetResource resource = this.resourceBuilder.getResourceForKey(resourceKey);
                ResourceContext resourceContext = this.getResourceContext(resource, request, response);
                Object resourceData = this.resourceBuilder.getResourceDataForKey(resourceKey);
                resourceContext.setResourceData(resourceData);
                try {
                    request.setAttribute(RICHFACES_RESOURCE, (Object)resource);
                    this.lifecycle.send(resourceContext, resource);
                    request.removeAttribute(RICHFACES_RESOURCE);
                }
                catch (IOException e) {
                    throw new BridgeException((Throwable)e);
                }
                finally {
                    resourceContext.release();
                }
                return true;
            }
            catch (ResourceNotFoundException e) {
                return false;
            }
        }
        if (RichFacesStrategy.isMultipartContent(request)) {
            String uid = request.getParameter("_richfaces_upload_uid");
            MultipartRequest multipartRequest = new MultipartRequest((HttpServletRequest)new ResourceRequestWrapper(request), this.uploadToTempDir, this.uploadLimit, uid);
            request.setAttribute(FileUploadConstants.FILE_UPLOAD_REQUEST_ATTRIBUTE_NAME, (Object)multipartRequest);
            return false;
        }
        return false;
    }

    public static final boolean isMultipartContent(ResourceRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(MULTIPART);
    }

    protected ResourceContext getResourceContext(InternetResource resource, ResourceRequest request, ResourceResponse response) throws FacesException {
        Object resourceContext;
        FacesContext facesContext = null;
        if (resource.requireFacesContext()) {
            facesContext = this.config.createFacesContext(request, response);
            resourceContext = new PortletFacesResourceContext(facesContext);
        } else {
            resourceContext = new PortletResourceContext(this.config.getPortletConfig().getPortletContext(), request, response);
        }
        resourceContext.setCacheEnabled(true);
        return resourceContext;
    }

    public int getPortletSessionScopeForName(String name) {
        return 2;
    }

    public void beforeActionRequest(FacesContext facesContext) {
    }

    public void afterActionRequestExecute(FacesContext facesContext) {
    }

    public void afterActionRequest(FacesContext facesContext) {
    }

    public void beforeEventRequest(FacesContext facesContext) {
    }

    public void afterEventRequest(FacesContext facesContext) {
    }

    public void beforeResourceRequest(FacesContext facesContext) {
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)facesContext);
        StateId stateId = PortletBridgeContext.getCurrentInstance(facesContext).getStateId();
        ajaxContext.getCommonAjaxParameters().put("javax.faces.portletbridge.STATE_ID", stateId.toString());
        if (ajaxContext.isAjaxRequest(facesContext)) {
            Object response = facesContext.getExternalContext().getResponse();
            Object request = facesContext.getExternalContext().getRequest();
            if (!RichFacesStrategy.isMultipartContent((ResourceRequest)request) && response instanceof MimeResponse) {
                MimeResponse mimeResponse = (MimeResponse)response;
                mimeResponse.setContentType(XML_CONTENT);
            }
        }
    }

    public void afterResourceRequestExecute(FacesContext facesContext) {
    }
}

