/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.seam;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.portlet.faces.BridgeUtil;
import javax.security.auth.login.LoginException;
import org.jboss.portletbridge.util.BridgeLogger;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.security.Credentials;
import org.jboss.seam.security.Identity;

@Name(value="org.jboss.seam.security.identity")
@Scope(value=ScopeType.SESSION)
@BypassInterceptors
@Install(precedence=10, classDependencies={"javax.portlet.Portlet"})
@Startup
public class PortalIdentity
extends Identity {
    private static final Logger log = BridgeLogger.SEAM.getLogger();
    private JBossLoginDelegate loginDelegate = new JBossLoginDelegate();

    private boolean isPortletPhase() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return null != facesContext ? BridgeUtil.isPortletRequest() : false;
    }

    @Observer(value={"org.jboss.seam.security.initCredentials"})
    public void initCredentials(Credentials credentials) {
        if (this.isPortletPhase()) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            credentials.setUsername(facesContext.getExternalContext().getRemoteUser());
        }
    }

    public String login() {
        if (this.isPortletPhase()) {
            try {
                this.authenticate();
                if (!this.isLoggedIn()) {
                    throw new LoginException();
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Login successful for: " + this.getUsername());
                }
                if (Events.exists()) {
                    Events.instance().raiseEvent("org.jboss.seam.security.loginSuccessful", new Object[0]);
                }
                return "loggedIn";
            }
            catch (LoginException ex) {
                this.getCredentials().invalidate();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Login failed for: " + this.getUsername(), ex);
                }
                if (Events.exists()) {
                    Events.instance().raiseEvent("org.jboss.seam.security.loginFailed", new Object[]{ex});
                }
                return null;
            }
        }
        return super.login();
    }

    public void authenticate() throws LoginException {
        if (this.isPortletPhase() && null == this.getJaasConfigName()) {
            if (!this.isLoggedIn()) {
                this.preAuthenticate();
                this.loginDelegate.login(this.getCredentials().getUsername(), this.getCredentials().getPassword());
                this.postAuthenticate();
            }
        } else {
            super.authenticate();
        }
    }

    public void logout() {
        this.loginDelegate.logout();
        super.logout();
    }

    public boolean hasRole(String role) {
        if (this.isPortletPhase()) {
            return FacesContext.getCurrentInstance().getExternalContext().isUserInRole(role);
        }
        return super.hasRole(role);
    }

    public Principal getPrincipal() {
        if (this.isPortletPhase()) {
            Set<Principal> principals;
            Principal bridgePrincipal = FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
            if (null != bridgePrincipal && !(principals = this.getSubject().getPrincipals()).contains(bridgePrincipal)) {
                principals.add(bridgePrincipal);
            }
            return bridgePrincipal;
        }
        return super.getPrincipal();
    }

    public void checkPermission(Object target, String action) {
        if (this.isContextActive()) {
            super.checkPermission(target, action);
        }
    }

    public void checkPermission(String name, String action, Object ... arg) {
        if (this.isContextActive()) {
            super.checkPermission(name, action, arg);
        }
    }

    public void checkRestriction(String expr) {
        if (this.isContextActive()) {
            super.checkRestriction(expr);
        }
    }

    public void checkRole(String role) {
        if (this.isContextActive()) {
            super.checkRole(role);
        }
    }

    private boolean isContextActive() {
        return Contexts.isApplicationContextActive() && null != FacesContext.getCurrentInstance();
    }

    private static class JBossLoginDelegate
    implements Serializable {
        private Class<?> authenticationClass;
        private Object jbossAuthentication;

        public JBossLoginDelegate() {
            try {
                this.authenticationClass = Class.forName("org.jboss.web.tomcat.security.login.WebAuthentication");
                try {
                    this.jbossAuthentication = this.authenticationClass.newInstance();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "JBoss Web Authentication instantiation exception, Web Authentication disabled", e);
                }
            }
            catch (ClassNotFoundException ex) {
                log.info("JBoss Web Authentication is not available...");
            }
        }

        public void login(String username, String password) {
            if (this.jbossAuthentication != null) {
                try {
                    Method m = this.authenticationClass.getMethod("login", String.class, Object.class);
                    m.invoke(this.jbossAuthentication, username, password);
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "Error logging out with JBoss Web Authentication", ex);
                }
            }
        }

        public void logout() {
            if (this.jbossAuthentication != null) {
                try {
                    Method m = this.authenticationClass.getMethod("logout", new Class[0]);
                    m.invoke(this.jbossAuthentication, new Object[0]);
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "Error logging out with JBoss Web Authentication", ex);
                }
            }
        }
    }
}

