/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.portlet.PortletContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.portletbridge.util.FacesConfigHandler;
import org.jboss.portletbridge.util.ParsingException;
import org.jboss.portletbridge.util.WebXML;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesConfig {
    private static final Logger log = Logger.getLogger(FacesConfig.class.getName());
    private static final String FACES_CONFIG_CLASS_PATH = "META-INF/faces-config.xml";
    private static final String FACES_CONFIG_WEB_PATH = "/WEB-INF/faces-config.xml";
    private final List<String> excludedAttributes;
    private final Map<String, String> parameterMapping;
    private SAXParserFactory factory = SAXParserFactory.newInstance();

    public FacesConfig() {
        this.factory.setValidating(false);
        this.factory.setNamespaceAware(true);
        this.parameterMapping = new HashMap<String, String>();
        this.excludedAttributes = new ArrayList<String>();
    }

    public void parse(PortletContext context) {
        try {
            this.parseClasspath(context);
            this.parseOptional(context);
            this.parseDefault(context);
        }
        catch (ParsingException e) {
            throw new FacesException("Error parsing faces-config", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseDefault(PortletContext context) throws ParsingException {
        InputStream inputStream = context.getResourceAsStream(FACES_CONFIG_WEB_PATH);
        if (null != inputStream) {
            try {
                this.parse(inputStream);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Can't close input stream for web resource /WEB-INF/faces-config.xml", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseOptional(PortletContext context) throws ParsingException {
        String facesConfigs = context.getInitParameter("javax.faces.CONFIG_FILES");
        if (null != facesConfigs) {
            String[] configNamesArray = facesConfigs.trim().split("(\\s)*,(\\s)*");
            for (int i = 0; i < configNamesArray.length; ++i) {
                String facesConfigPath = configNamesArray[i];
                InputStream inputStream = context.getResourceAsStream(facesConfigPath);
                if (null == inputStream) continue;
                try {
                    this.parse(inputStream);
                    continue;
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, "Can't close input stream for web resource " + facesConfigPath, e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseClasspath(PortletContext context) throws ParsingException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (null == classLoader) {
            classLoader = context.getClass().getClassLoader();
        }
        try {
            Enumeration<URL> resources = classLoader.getResources(FACES_CONFIG_CLASS_PATH);
            while (resources.hasMoreElements()) {
                URL resourceURL = resources.nextElement();
                try {
                    URLConnection connection = resourceURL.openConnection();
                    connection.setUseCaches(false);
                    InputStream inputStream = connection.getInputStream();
                    try {
                        this.parse(inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Can't parse " + resourceURL.toExternalForm(), e);
                }
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Can't get META-INF/faces-config.xml resources", e);
        }
    }

    protected void parse(InputStream facesConfig) throws ParsingException {
        try {
            SAXParser parser = this.getParser();
            XMLReader reader = parser.getXMLReader();
            FacesConfigHandler facesConfigHandler = new FacesConfigHandler(reader);
            reader.setContentHandler(facesConfigHandler);
            reader.setEntityResolver(WebXML.NULL_RESOLVER);
            reader.setErrorHandler(facesConfigHandler);
            reader.setDTDHandler(facesConfigHandler);
            reader.parse(new InputSource(facesConfig));
            this.excludedAttributes.addAll(facesConfigHandler.getExcludedAttributes());
            this.parameterMapping.putAll(facesConfigHandler.getParameterMapping());
        }
        catch (SAXException e) {
            log.log(Level.WARNING, "Exception at faces-config.xml parsing", e);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Exception at faces-config.xml parsing", e);
        }
    }

    protected SAXParser getParser() throws ParsingException {
        try {
            SAXParser parser = this.factory.newSAXParser();
            return parser;
        }
        catch (ParserConfigurationException e) {
            throw new ParsingException("SAX Parser configuration error", e);
        }
        catch (SAXException e) {
            throw new ParsingException("SAX Parser instantiation error", e);
        }
    }

    public List<String> getExcludedAttributes() {
        return this.excludedAttributes;
    }

    public Map<String, String> getParameterMapping() {
        return this.parameterMapping;
    }
}

