/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.util;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.portletbridge.util.FilterBean;
import org.jboss.portletbridge.util.ServletBean;
import org.jboss.portletbridge.util.ServletMapping;
import org.jboss.portletbridge.util.StateHandler;
import org.jboss.portletbridge.util.StringContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebappHandler
extends DefaultHandler {
    private static final String SERVLET_MAPPING_ELEMENT = "servlet-mapping";
    private static final String ERROR_PAGE_ELEMENT = "error-page";
    private static final String SERVLET_ELEMENT = "servlet";
    private static final String LOCATION_ELEMENT = "location";
    private static final String EXCEPTION_CLASS_ELEMENT = "exception-type";
    static final String FACES_SERVLET_CLASS = "javax.faces.webapp.FacesServlet";
    private List<ServletBean> servlets = new ArrayList<ServletBean>();
    private List<FilterBean> filters = new ArrayList<FilterBean>();
    private List<ServletMapping> mappings = new ArrayList<ServletMapping>();
    private Map<String, String> errorPages = new LinkedHashMap<String, String>();
    private ServletBean facesServlet;
    private XMLReader xmlReader;
    static final String URL_PATTERN_ELEMENT = "url-pattern";
    static final String SERVLET_NAME_ELEMENT = "servlet-name";
    static final String SERVLET_CLASS_ELEMENT = "servlet-class";
    static final String FILTER_ELEMENT = "filter";
    static final String FILTER_CLASS_ELEMENT = "filter-class";
    static final String FILTER_INITPARAM_ELEMENT = "init-param";
    static final String FILTER_INITPARAMNAME_ELEMENT = "param-name";
    static final String FILTER_INITPARAMVALUE_ELEMENT = "param-value";

    public WebappHandler(XMLReader reader) {
        this.xmlReader = reader;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (SERVLET_ELEMENT.equals(localName)) {
            this.xmlReader.setContentHandler(new ServletHandler());
        } else if (SERVLET_MAPPING_ELEMENT.equals(localName)) {
            this.xmlReader.setContentHandler(new MappingHandler());
        } else if (ERROR_PAGE_ELEMENT.equals(localName)) {
            this.xmlReader.setContentHandler(new ErrorPageHandler());
        } else if (FILTER_ELEMENT.equals(localName)) {
            this.xmlReader.setContentHandler(new FilterHandler());
        }
    }

    @Override
    public void endDocument() throws SAXException {
        for (ServletBean servlet : this.servlets) {
            if (!FACES_SERVLET_CLASS.equals(servlet.getClassName())) continue;
            this.facesServlet = servlet;
            for (ServletMapping mapping : this.mappings) {
                if (!servlet.getName().equals(mapping.getServletName())) continue;
                this.facesServlet.getMappings().add(mapping.getUrlPattern());
            }
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return new InputSource(new StringReader(""));
    }

    public XMLReader getXmlReader() {
        return this.xmlReader;
    }

    public Map<String, String> getErrorPages() {
        return this.errorPages;
    }

    public ServletBean getFacesServlet() {
        return this.facesServlet;
    }

    public List<FilterBean> getFilterBeans() {
        return this.filters;
    }

    final class ErrorPageHandler
    extends StateHandler {
        private StringBuilder exceptionType;
        private StringBuilder location;

        public ErrorPageHandler() {
            super(WebappHandler.this.xmlReader, WebappHandler.this);
            this.exceptionType = new StringBuilder();
            this.location = new StringBuilder();
        }

        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
            StringContentHandler nextHandler = null;
            if (WebappHandler.EXCEPTION_CLASS_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.exceptionType);
            } else if (WebappHandler.LOCATION_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.location);
            }
            return nextHandler;
        }

        protected void endLastElement() {
            WebappHandler.this.errorPages.put(this.exceptionType.toString().trim(), this.location.toString().trim());
        }
    }

    final class MappingHandler
    extends StateHandler {
        private StringBuilder servletName;
        private StringBuilder urlPattern;

        public MappingHandler() {
            super(WebappHandler.this.xmlReader, WebappHandler.this);
            this.servletName = new StringBuilder();
            this.urlPattern = new StringBuilder();
        }

        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
            StringContentHandler nextHandler = null;
            if (WebappHandler.SERVLET_NAME_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.servletName);
            } else if (WebappHandler.URL_PATTERN_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.urlPattern);
            }
            return nextHandler;
        }

        protected void endLastElement() {
            WebappHandler.this.mappings.add(new ServletMapping(this.servletName.toString().trim(), this.urlPattern.toString().trim()));
        }
    }

    final class FilterParamHandler
    extends StateHandler {
        private StringBuilder paramName;
        private StringBuilder paramValue;
        private FilterHandler filterHandler;

        public FilterParamHandler(FilterHandler parent) {
            super(WebappHandler.this.xmlReader, parent);
            this.paramName = new StringBuilder();
            this.paramValue = new StringBuilder();
            this.filterHandler = parent;
        }

        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
            StringContentHandler nextHandler = null;
            if (WebappHandler.FILTER_INITPARAMNAME_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.paramName);
            } else if (WebappHandler.FILTER_INITPARAMVALUE_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.paramValue);
            }
            return nextHandler;
        }

        protected void endLastElement() {
            this.filterHandler.initParams.put(this.paramName.toString().trim(), this.paramValue.toString().trim());
        }
    }

    final class FilterHandler
    extends StateHandler {
        private Map<String, String> initParams;
        private StringBuilder filterClass;

        public FilterHandler() {
            super(WebappHandler.this.xmlReader, WebappHandler.this);
            this.initParams = new HashMap<String, String>();
            this.filterClass = new StringBuilder();
        }

        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
            StateHandler nextHandler = null;
            if (WebappHandler.FILTER_CLASS_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.filterClass);
            } else if (WebappHandler.FILTER_INITPARAM_ELEMENT.equals(localName)) {
                nextHandler = new FilterParamHandler(this);
            }
            return nextHandler;
        }

        protected void endLastElement() {
            WebappHandler.this.filters.add(new FilterBean(this.filterClass.toString().trim(), this.initParams));
        }
    }

    final class ServletHandler
    extends StateHandler {
        private StringBuilder servletName;
        private StringBuilder servletClass;

        public ServletHandler() {
            super(WebappHandler.this.xmlReader, WebappHandler.this);
            this.servletName = new StringBuilder();
            this.servletClass = new StringBuilder();
        }

        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
            StringContentHandler nextHandler = null;
            if (WebappHandler.SERVLET_NAME_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.servletName);
            } else if (WebappHandler.SERVLET_CLASS_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.servletClass);
            }
            return nextHandler;
        }

        protected void endLastElement() {
            WebappHandler.this.servlets.add(new ServletBean(this.servletName.toString().trim(), this.servletClass.toString().trim()));
        }
    }
}

