/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.application;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;
import javax.portlet.faces.annotation.PortletNamingContainer;
import javax.portlet.faces.component.PortletNamingContainerUIViewRoot;
import org.jboss.portletbridge.bridge.context.BridgeContext;
import org.jboss.portletbridge.bridge.logger.BridgeLogger;
import org.jboss.portletbridge.bridge.logger.JULLoggerImpl;
import org.jboss.portletbridge.context.PortalActionURL;

public class PortletViewHandler
extends ViewHandlerWrapper {
    private static final BridgeLogger logger = new JULLoggerImpl(PortletViewHandler.class.getName());
    ViewHandler parent;

    public PortletViewHandler(ViewHandler parent) {
        this.parent = parent;
    }

    public Locale calculateLocale(FacesContext context) {
        Locale locale;
        if (BridgeUtil.isPortletRequest()) {
            locale = context.getExternalContext().getRequestLocale();
            if (null == locale) {
                locale = super.calculateLocale(context);
            } else {
                Locale loc;
                Iterator i = context.getApplication().getSupportedLocales();
                while (i.hasNext() && !(loc = (Locale)i.next()).equals(locale)) {
                }
                locale = super.calculateLocale(context);
            }
        } else {
            locale = super.calculateLocale(context);
        }
        return locale;
    }

    public UIViewRoot createView(FacesContext facesContext, String viewId) {
        if (!BridgeUtil.isPortletRequest()) {
            return super.createView(facesContext, viewId);
        }
        viewId = this.evaluateUrl(facesContext, viewId);
        String queryString = null;
        try {
            PortalActionURL viewIdUrl = new PortalActionURL(viewId);
            viewId = viewIdUrl.getPath();
            BridgeContext.getCurrentInstance().setNavigationQueryString(viewIdUrl.getQueryString());
            queryString = viewIdUrl.getQueryString();
        }
        catch (MalformedURLException e) {
            logger.log(BridgeLogger.Level.INFO, "Mailformed ViewId url", (Throwable)e);
        }
        UIViewRoot root = super.createView(facesContext, viewId);
        Class<?> rootClass = root.getClass();
        if (rootClass.getAnnotation(PortletNamingContainer.class) == null) {
            PortletNamingContainerUIViewRoot portletRoot = new PortletNamingContainerUIViewRoot();
            if (null != queryString && queryString.length() > 0) {
                portletRoot.setViewId(root.getViewId() + "?" + queryString);
            } else {
                portletRoot.setViewId(root.getViewId());
            }
            portletRoot.setLocale(root.getLocale());
            portletRoot.setRenderKitId(root.getRenderKitId());
            portletRoot.setId(root.getId());
            root = portletRoot;
        } else if (null != queryString && queryString.length() > 0) {
            root.setViewId(root.getViewId() + "?" + queryString);
        }
        Object response = facesContext.getExternalContext().getResponse();
        if (response instanceof PortletResponse) {
            PortletResponse portletResponse = (PortletResponse)response;
            portletResponse.setProperty("X-JAVAX-PORTLET-IS-NAMESPACED", "true");
        }
        return root;
    }

    public String getActionURL(FacesContext context, String url) {
        if (!BridgeUtil.isPortletRequest()) {
            return super.getActionURL(context, url);
        }
        url = this.evaluateUrl(context, url);
        PortalActionURL viewIdUrl = null;
        try {
            viewIdUrl = new PortalActionURL(url);
            url = viewIdUrl.getPath();
        }
        catch (MalformedURLException e) {
            logger.log(BridgeLogger.Level.INFO, "Mailformed ViewId url", (Throwable)e);
        }
        String actionURL = super.getActionURL(context, url);
        if (viewIdUrl.parametersSize() > 0) {
            int qMark = actionURL.indexOf(63);
            actionURL = qMark < 0 ? actionURL + "?" + viewIdUrl.getQueryString() : actionURL + "&" + viewIdUrl.getQueryString();
        }
        return actionURL;
    }

    protected String evaluateUrl(FacesContext context, String url) {
        if (url.startsWith("/#")) {
            url = url.substring(1);
        }
        if (url.startsWith("#") && (url = (String)context.getApplication().evaluateExpressionGet(context, url, String.class)) == null) {
            throw new FacesException("Evaluated view ID is null " + url);
        }
        return url;
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        if (!BridgeUtil.isPortletRequest()) {
            super.renderView(context, viewToRender);
            return;
        }
        ExternalContext externalContext = context.getExternalContext();
        String renderPolicyParam = externalContext.getInitParameter("javax.portlet.faces.RENDER_POLICY");
        Bridge.BridgeRenderPolicy renderPolicy = null == renderPolicyParam ? Bridge.BridgeRenderPolicy.DEFAULT : Bridge.BridgeRenderPolicy.valueOf((String)renderPolicyParam);
        if (renderPolicy == Bridge.BridgeRenderPolicy.ALWAYS_DELEGATE) {
            super.renderView(context, viewToRender);
        } else if (renderPolicy == Bridge.BridgeRenderPolicy.DEFAULT) {
            Object portletRequest = externalContext.getRequest();
            Object portletResponse = externalContext.getResponse();
            try {
                super.renderView(context, viewToRender);
            }
            catch (Throwable t) {
                logger.log(BridgeLogger.Level.DEBUG, "Error rendering view by parent ViewHandler, try to render as portletbridge JSP page", t);
                if (portletRequest != externalContext.getRequest()) {
                    externalContext.setRequest(portletRequest);
                }
                if (portletResponse != externalContext.getResponse()) {
                    externalContext.setResponse(portletResponse);
                }
                if (viewToRender.isRendered()) {
                    this.doRenderView(context, viewToRender);
                }
            }
        } else if (viewToRender.isRendered()) {
            this.doRenderView(context, viewToRender);
        }
    }

    private void doRenderView(FacesContext context, UIViewRoot viewToRender) throws IOException {
        this.getViewDeclarationLanguage(context, viewToRender.getViewId()).renderView(context, viewToRender);
    }

    public ViewHandler getWrapped() {
        return this.parent;
    }
}

