/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.bridge.logger;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.portletbridge.bridge.logger.BridgeLogger;

public class JULLoggerImpl
implements BridgeLogger {
    private Logger logger = null;
    private boolean enabled = false;

    public JULLoggerImpl() {
        this.logger = Logger.getLogger(JULLoggerImpl.class.getName(), "org.jboss.portletbridge.LogMessages");
    }

    public JULLoggerImpl(String className) {
        this.logger = Logger.getLogger(className, "org.jboss.portletbridge.LogMessages");
    }

    public void log(String msg) {
        if (this.isEnabled()) {
            this.logger.log(this.logger.getLevel(), msg);
        }
    }

    public void log(String message, Throwable throwable) {
        if (this.isEnabled()) {
            this.logger.log(this.logger.getLevel(), message, throwable);
        }
    }

    public void log(BridgeLogger.Level logLevel, String msg) {
        if (this.isEnabled()) {
            this.logger.log(this.mapToLogger(logLevel), msg);
        }
    }

    public void log(BridgeLogger.Level logLevel, String message, Throwable throwable) {
        if (this.isEnabled()) {
            this.logger.log(this.mapToLogger(logLevel), message, throwable);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enable) {
        this.enabled = null != enable ? enable : false;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public BridgeLogger.Level getLogLevel() {
        return this.mapFromLogger(this.logger.getLevel());
    }

    public void setLogLevel(BridgeLogger.Level logLevel) {
        this.logger.setLevel(this.mapToLogger(logLevel));
    }

    private BridgeLogger.Level mapFromLogger(Level julLevel) {
        BridgeLogger.Level ourLevel = null;
        ourLevel = julLevel == Level.SEVERE ? BridgeLogger.Level.ERROR : (julLevel == Level.WARNING ? BridgeLogger.Level.WARNING : (julLevel == Level.INFO ? BridgeLogger.Level.INFO : BridgeLogger.Level.DEBUG));
        return ourLevel;
    }

    private Level mapToLogger(BridgeLogger.Level ourLevel) {
        Level julLevel = null;
        julLevel = ourLevel == BridgeLogger.Level.ERROR ? Level.SEVERE : (ourLevel == BridgeLogger.Level.WARNING ? Level.WARNING : (ourLevel == BridgeLogger.Level.INFO ? Level.INFO : Level.FINE));
        return julLevel;
    }
}

