/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.lifecycle;

import java.util.Enumeration;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.portlet.PortletRequest;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;
import org.jboss.portletbridge.bridge.config.BridgeConfig;
import org.jboss.portletbridge.util.ParameterFunction;
import org.jboss.portletbridge.util.PublicParameterUtil;

public class PublicParameterPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 6815081977853452874L;
    private BridgeConfig bridgeConfig;
    private PortletRequest portletRequest;
    private boolean mappingsProcessed;

    public PublicParameterPhaseListener(BridgeConfig bridgeConfig, PortletRequest portletRequest) {
        this.bridgeConfig = bridgeConfig;
        this.portletRequest = portletRequest;
        this.mappingsProcessed = false;
    }

    public void afterPhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        if (context != FacesContext.getCurrentInstance() || !BridgeUtil.isPortletRequest()) {
            return;
        }
        if (event.getPhaseId().equals(PhaseId.RESTORE_VIEW)) {
            this.processIncomingParameters(context, this.portletRequest);
            if (BridgeUtil.getPortletRequestPhase().equals((Object)Bridge.PortletPhase.EVENT_PHASE) && !this.mappingsProcessed) {
                context.renderResponse();
            }
        }
    }

    public void beforePhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    protected void processIncomingParameters(FacesContext facesContext, PortletRequest portletRequest) {
        ParameterFunction incomingFunction;
        boolean valueChanged;
        Map publicParameterMapping = this.bridgeConfig.getPublicRenderParameterMappings();
        Enumeration parameterNames = this.bridgeConfig.getPortletConfig().getPublicRenderParameterNames();
        if (null != publicParameterMapping && publicParameterMapping.size() > 0 && parameterNames.hasMoreElements() && (valueChanged = PublicParameterUtil.processPublicParameters(facesContext, portletRequest, publicParameterMapping, parameterNames, incomingFunction = new ParameterFunction(){

            @Override
            public boolean processParameter(ELContext elContext, Map<String, String[]> publicParameters, String name, ValueExpression valueExpression) {
                boolean valueChanged = false;
                Object oldValue = valueExpression.getValue(elContext);
                if (publicParameters.containsKey(name)) {
                    String newValue;
                    String[] values = publicParameters.get(name);
                    String string = newValue = null != values && values.length > 0 ? values[0] : null;
                    if (null == oldValue || !oldValue.equals(newValue)) {
                        valueExpression.setValue(elContext, (Object)newValue);
                        valueChanged = true;
                    }
                } else if (null != oldValue) {
                    valueExpression.setValue(elContext, null);
                    valueChanged = true;
                }
                return valueChanged;
            }
        }, this.bridgeConfig.getPortletConfig().getPortletName())) && null != this.bridgeConfig.getPublicRenderParameterHandler()) {
            this.bridgeConfig.getPublicRenderParameterHandler().processUpdates(facesContext);
            this.mappingsProcessed = true;
        }
    }
}

