/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.application.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.ResourceRequest;
import javax.portlet.faces.BridgeUtil;
import org.jboss.portletbridge.application.resource.PortletResource;
import org.jboss.portletbridge.bridge.logger.BridgeLogger;
import org.jboss.portletbridge.bridge.logger.JULLoggerImpl;

public class PortletResourceHandler
extends ResourceHandlerWrapper {
    private static final BridgeLogger logger = new JULLoggerImpl(PortletResourceHandler.class.getName());
    public static final String LIBRARY_ID = "ln";
    public static final String MIME_PARAM = "type";
    private final ResourceHandler parent;

    public PortletResourceHandler(ResourceHandler parent) {
        this.parent = parent;
    }

    public ResourceHandler getWrapped() {
        return this.parent;
    }

    public boolean isResourceRequest(FacesContext facesContext) {
        String resourceIdentifier;
        ExternalContext extContext = facesContext.getExternalContext();
        Object request = extContext.getRequest();
        if (request instanceof ResourceRequest && null != (resourceIdentifier = (String)extContext.getRequestParameterMap().get("/javax.faces.resource".substring(1)))) {
            return true;
        }
        return super.isResourceRequest(facesContext);
    }

    public Resource createResource(String resourceName) {
        Object resource = this.getWrapped().createResource(resourceName);
        if (!this.isPortletResource((Resource)resource)) {
            resource = new PortletResource((Resource)resource);
        }
        return resource;
    }

    public Resource createResource(String resourceName, String libraryName) {
        Object resource = this.getWrapped().createResource(resourceName, libraryName);
        if (!this.isPortletResource((Resource)resource)) {
            resource = new PortletResource((Resource)resource);
        }
        return resource;
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        Object resource = this.getWrapped().createResource(resourceName, libraryName, contentType);
        if (!this.isPortletResource((Resource)resource)) {
            resource = new PortletResource((Resource)resource);
        }
        return resource;
    }

    public void handleResourceRequest(FacesContext context) throws IOException {
        if (BridgeUtil.isPortletRequest()) {
            ExternalContext externalContext = context.getExternalContext();
            String resourceName = (String)externalContext.getRequestParameterMap().get("/javax.faces.resource".substring(1));
            if (null != resourceName) {
                String libraryId = (String)externalContext.getRequestParameterMap().get(LIBRARY_ID);
                ResourceHandler handler = context.getApplication().getResourceHandler();
                Object resource = handler.createResource(resourceName, libraryId);
                if (null != resource) {
                    if (!this.isPortletResource((Resource)resource)) {
                        resource = new PortletResource((Resource)resource);
                    }
                    this.handleResourceRequest(context, (Resource)resource);
                } else {
                    this.send404(context, resourceName, libraryId);
                }
            } else {
                this.send404(context, resourceName, null);
            }
        } else {
            super.handleResourceRequest(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleResourceRequest(FacesContext context, Resource resource) throws IOException {
        if (resource.userAgentNeedsUpdate(context)) {
            ExternalContext extContext = context.getExternalContext();
            ReadableByteChannel resourceChannel = null;
            Channel out = null;
            InputStream in = null;
            int bufferSize = extContext.getResponseBufferSize();
            if (0 == bufferSize) {
                bufferSize = 2048;
            }
            ByteBuffer buf = ByteBuffer.allocate(bufferSize);
            extContext.setResponseBufferSize(buf.capacity());
            try {
                in = resource.getInputStream();
                if (in == null) {
                    this.send404(context, resource.getResourceName(), resource.getLibraryName());
                    return;
                }
                resourceChannel = Channels.newChannel(in);
                String contentType = resource.getContentType();
                if (contentType != null) {
                    extContext.setResponseContentType(resource.getContentType());
                }
                ByteArrayOutputStream byteArray = new ByteArrayOutputStream(bufferSize);
                out = Channels.newChannel(byteArray);
                extContext.setResponseBufferSize(buf.capacity());
                this.handleHeaders(context, resource);
                int size = 0;
                int thisRead = resourceChannel.read(buf);
                int totalWritten = 0;
                while (thisRead != -1) {
                    buf.rewind();
                    buf.limit(thisRead);
                    while ((totalWritten += out.write(buf)) < size) {
                    }
                    buf.clear();
                    size += thisRead;
                    thisRead = resourceChannel.read(buf);
                }
                extContext.setResponseContentLength(size);
                extContext.setResponseStatus(200);
                byteArray.writeTo(extContext.getResponseOutputStream());
                byteArray.flush();
                byteArray.close();
            }
            finally {
                if (null != in) {
                    in.close();
                }
                if (null != out) {
                    out.close();
                }
                if (null != resourceChannel) {
                    resourceChannel.close();
                }
            }
        } else {
            this.send304(context);
        }
    }

    protected boolean isPortletResource(Resource res) {
        return null == res || res instanceof PortletResource;
    }

    protected void send404(FacesContext ctx, String resourceName, String libraryName) {
        ctx.getExternalContext().setResponseStatus(404);
    }

    protected void send304(FacesContext ctx) {
        ctx.getExternalContext().setResponseStatus(304);
    }

    protected void handleHeaders(FacesContext ctx, Resource resource) {
        ExternalContext extContext = ctx.getExternalContext();
        for (Map.Entry cur : resource.getResponseHeaders().entrySet()) {
            extContext.setResponseHeader((String)cur.getKey(), (String)cur.getValue());
        }
    }
}

