/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.bridge.context;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import javax.portlet.faces.BridgeException;
import javax.portlet.faces.BridgeInvalidViewPathException;
import javax.portlet.faces.BridgeNotAFacesRequestException;
import org.jboss.portletbridge.bridge.config.BridgeConfig;
import org.jboss.portletbridge.bridge.context.BridgeContext;
import org.jboss.portletbridge.bridge.factory.BridgeFactoryFinder;
import org.jboss.portletbridge.bridge.factory.BridgeRequestScopeManagerFactory;
import org.jboss.portletbridge.bridge.scope.BridgeRequestScope;
import org.jboss.portletbridge.bridge.scope.BridgeRequestScopeManager;
import org.jboss.portletbridge.bridge.scope.BridgeRequestScopeManagerImpl;
import org.jboss.portletbridge.context.PortalActionURL;
import org.jboss.portletbridge.el.ELContextImpl;

public class BridgeContextImpl
extends BridgeContext
implements ELContextListener {
    public static final String REQUEST_SCOPE_MANAGER = BridgeRequestScopeManagerImpl.class.getName();
    private PortletContext portletContext;
    private PortletRequest portletRequest;
    private PortletResponse portletResponse;
    private BridgeConfig bridgeConfig;
    private Bridge.PortletPhase portletPhase;
    private Map<String, Object> attributes;
    private boolean bridgeRequestScopePreserved = true;
    private String savedViewStateParam;
    private String navigationQueryString;
    private String renderRedirectQueryString;
    private String redirectViewId;
    private boolean renderRedirect = false;
    private boolean renderRedirectOcurredAfterDispatch = false;
    private List<String> preExistingRequestAttributeNames;
    private Map<String, String[]> preservedActionParams;
    private boolean viewHistoryInitialized = false;

    public BridgeContextImpl(BridgeConfig bridgeConfig) {
        BridgeContext.setCurrentInstance((BridgeContext)this);
        this.bridgeConfig = bridgeConfig;
        this.portletContext = bridgeConfig.getPortletConfig().getPortletContext();
        ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication().addELContextListener((ELContextListener)this);
    }

    public void release() {
        this.portletContext = null;
        this.portletRequest = null;
        this.portletResponse = null;
        this.bridgeConfig = null;
        this.portletPhase = null;
        this.attributes = null;
        this.savedViewStateParam = null;
        this.navigationQueryString = null;
        this.renderRedirectQueryString = null;
        this.redirectViewId = null;
        this.preExistingRequestAttributeNames = null;
        this.preservedActionParams = null;
        BridgeContext.setCurrentInstance(null);
        ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication().removeELContextListener((ELContextListener)this);
    }

    public void setPortletContext(PortletContext context) {
        this.portletContext = context;
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public void setPortletRequest(PortletRequest request) {
        this.portletRequest = request;
        if (null != this.getBridgeConfig()) {
            this.initViewHistory();
        }
    }

    public PortletRequest getPortletRequest() {
        return this.portletRequest;
    }

    public void setPortletResponse(PortletResponse response) {
        this.portletResponse = response;
    }

    public PortletResponse getPortletResponse() {
        return this.portletResponse;
    }

    public void setPortletRequestPhase(Bridge.PortletPhase phase) {
        this.portletPhase = phase;
    }

    public Bridge.PortletPhase getPortletRequestPhase() {
        return this.portletPhase;
    }

    public void setBridgeConfig(BridgeConfig config) {
        this.bridgeConfig = config;
        if (null != this.getPortletRequest()) {
            this.initViewHistory();
        }
    }

    public BridgeConfig getBridgeConfig() {
        return this.bridgeConfig;
    }

    public Map<String, Object> getAttributes() {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, Object>(10);
        }
        return this.attributes;
    }

    public void setBridgeRequestScopePreserved(boolean preserve) {
        this.bridgeRequestScopePreserved = preserve;
    }

    public boolean isBridgeRequestScopePreserved() {
        return this.bridgeRequestScopePreserved;
    }

    public void setSavedViewStateParam(String savedViewStateParam) {
        this.savedViewStateParam = savedViewStateParam;
    }

    public String getSavedViewStateParam() {
        return this.savedViewStateParam;
    }

    public void setNavigationQueryString(String queryString) {
        this.navigationQueryString = queryString;
    }

    public String getNavigationalQueryString() {
        return this.navigationQueryString;
    }

    public void setRenderRedirectQueryString(String queryString) {
        this.renderRedirectQueryString = queryString;
        this.setRenderRedirect(true);
    }

    public String getRenderRedirectQueryString() {
        return this.renderRedirectQueryString;
    }

    public String getRedirectViewId() {
        return this.redirectViewId;
    }

    public void setRedirectViewId(String viewId) {
        this.redirectViewId = viewId;
        this.setRenderRedirect(true);
    }

    public void setRenderRedirect(boolean redirect) {
        this.renderRedirect = redirect;
    }

    public boolean hasRenderRedirect() {
        return this.renderRedirect;
    }

    public void setRenderRedirectAfterDispatch(boolean afterDispatch) {
        if (afterDispatch) {
            this.setRenderRedirect(true);
        }
        this.renderRedirectOcurredAfterDispatch = afterDispatch;
    }

    public boolean hasRenderRedirectAfterDispatch() {
        return this.renderRedirectOcurredAfterDispatch;
    }

    public void setPreFacesRequestAttrNames(List<String> names) {
        this.preExistingRequestAttributeNames = null;
        if (null != names) {
            this.preExistingRequestAttributeNames = new ArrayList<String>(names);
        }
    }

    public List<String> getPreFacesRequestAttrNames() {
        return this.preExistingRequestAttributeNames;
    }

    public void setPreservedActionParams(Map<String, String[]> actionParamMap) {
        this.preservedActionParams = null;
        if (null != actionParamMap) {
            this.preservedActionParams = new HashMap<String, String[]>(actionParamMap);
        }
    }

    public Map<String, String[]> getPreservedActionParams() {
        return this.preservedActionParams;
    }

    public void setViewHistory(String mode, String viewId, boolean preserveRenderParams) {
        PortalActionURL historyViewId = null;
        try {
            historyViewId = new PortalActionURL(viewId);
        }
        catch (MalformedURLException e) {
            BridgeContextImpl.log((String)("MalformedURL for " + viewId + " in setViewHistory()"), (Throwable)e);
        }
        if (null != historyViewId) {
            historyViewId.addParameter("javax.portlet.faces.PortletMode", mode);
            if (preserveRenderParams) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                Map renderParams = null;
                renderParams = null != facesContext ? FacesContext.getCurrentInstance().getExternalContext().getRequestParameterValuesMap() : this.getPortletRequest().getPrivateParameterMap();
                if (!renderParams.isEmpty()) {
                    Set keys = renderParams.entrySet();
                    for (Map.Entry entry : keys) {
                        if (((String)entry.getKey()).equals(this.bridgeConfig.getViewIdRenderParameterName()) || ((String)entry.getKey()).equals("javax.faces.ViewState")) continue;
                        for (String value : (String[])entry.getValue()) {
                            historyViewId.addParameter((String)entry.getKey(), value);
                        }
                    }
                }
            }
            String queryString = historyViewId.getQueryString();
            String historyViewPath = historyViewId.getPath() + (queryString != null ? "?" + queryString : "");
            this.getPortletRequest().getPortletSession(true).setAttribute("javax.portlet.faces.viewIdHistory." + mode, (Object)historyViewPath);
        }
    }

    public String getViewHistory(String mode) {
        StringBuffer key = new StringBuffer(100);
        return (String)FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get(key.append("javax.portlet.faces.viewIdHistory").append('.').append(mode).toString());
    }

    public String getFacesViewIdFromRequest(boolean excludeQueryString) throws BridgeInvalidViewPathException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (null == facesContext) {
            return this.getViewId(this.portletRequest, excludeQueryString);
        }
        return this.getViewId((PortletRequest)facesContext.getExternalContext().getRequest(), excludeQueryString);
    }

    public String getFacesViewId(boolean excludeQueryString) throws BridgeInvalidViewPathException {
        String viewId = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (null != facesContext && null != facesContext.getViewRoot()) {
            viewId = facesContext.getViewRoot().getViewId();
        } else {
            viewId = this.getFacesViewIdFromRequest(excludeQueryString);
            if (null == viewId) {
                viewId = this.getDefaultFacesViewIdForRequest(excludeQueryString);
            }
        }
        return viewId;
    }

    public BridgeRequestScope getBridgeScope() {
        return this.getBridgeRequestScopeManager().getRequestScope((BridgeContext)this);
    }

    public BridgeRequestScope getBridgeScope(String viewId, String mode) {
        return this.getBridgeRequestScopeManager().getRequestScope((BridgeContext)this, viewId, mode);
    }

    public BridgeRequestScopeManager getBridgeRequestScopeManager() {
        PortletSession session = this.getPortletRequest().getPortletSession(true);
        BridgeRequestScopeManager scopeManager = (BridgeRequestScopeManager)session.getAttribute(REQUEST_SCOPE_MANAGER);
        if (null == scopeManager) {
            scopeManager = this.createBridgeRequestScopeManager();
        }
        return scopeManager;
    }

    private synchronized BridgeRequestScopeManager createBridgeRequestScopeManager() {
        BridgeRequestScopeManager scopeManager = (BridgeRequestScopeManager)this.getPortletRequest().getPortletSession(true).getAttribute(REQUEST_SCOPE_MANAGER);
        if (null == scopeManager) {
            this.getPortletRequest().getPortletSession(true).setAttribute(REQUEST_SCOPE_MANAGER, (Object)((BridgeRequestScopeManagerFactory)BridgeFactoryFinder.getFactoryInstance(BridgeRequestScopeManagerFactory.class)).getBridgeRequestScopeManager(this.getBridgeConfig()));
            scopeManager = (BridgeRequestScopeManager)this.getPortletRequest().getPortletSession(true).getAttribute(REQUEST_SCOPE_MANAGER);
        }
        return scopeManager;
    }

    public String getFacesViewIdFromPath(String path) throws BridgeInvalidViewPathException {
        int index = path.indexOf(63);
        if (index != -1) {
            path = path.substring(0, index);
        }
        if ((index = path.lastIndexOf(";" + this.bridgeConfig.getSessionIdParameterName())) != -1) {
            path = path.substring(0, index);
        }
        path = this.getPathWithoutContext(path, this.getPortletRequest().getContextPath());
        String viewId = null;
        List facesMappings = this.getBridgeConfig().getFacesServletMappings();
        List facesSuffixes = this.getBridgeConfig().getFacesSuffixes();
        String prefix = this.getPrefix(path, facesMappings);
        viewId = this.isSuffixedMapped(path, facesMappings) ? this.viewIdFromSuffixMapping(path, facesSuffixes) : (null != prefix ? path.substring(prefix.length()) : null);
        return viewId;
    }

    private String getPathWithoutContext(String path, String contextPath) {
        int pos = path.indexOf(contextPath);
        if (pos != -1 && path.indexOf(47, pos + 1) > 0 && pos + contextPath.length() != path.length()) {
            path = path.substring(pos + contextPath.length());
        }
        return path;
    }

    public String getDefaultFacesViewIdForRequest(boolean excludeQueryString) throws BridgeDefaultViewNotSpecifiedException {
        PortletRequest request = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (null != facesContext) {
            request = (PortletRequest)facesContext.getExternalContext().getRequest();
        }
        if (null == request && null == (request = this.getPortletRequest())) {
            throw new BridgeNotAFacesRequestException("No PortletRequest present in Faces.getExternalContext() or BridgeContext.getPortletRequest()");
        }
        String viewId = (String)this.getBridgeConfig().getDefaultViewMappings().get(this.getPortletRequest().getPortletMode().toString());
        if (null == viewId) {
            throw new BridgeDefaultViewNotSpecifiedException("No Default View specified for portlet: " + this.getBridgeConfig().getPortletConfig().getPortletName());
        }
        if (excludeQueryString) {
            viewId = this.excludeQuery(viewId);
        }
        return viewId;
    }

    public String appendClientWindowId(String url) {
        return url;
    }

    protected String excludeQuery(String viewId) {
        int queryStart = viewId.indexOf(63);
        if (queryStart != -1) {
            return viewId.substring(0, queryStart);
        }
        return viewId;
    }

    public void contextCreated(ELContextEvent ece) {
        ELContext elContext = ece.getELContext();
        FacesContext fCtx = (FacesContext)elContext.getContext(FacesContext.class);
        if (null == fCtx) {
            return;
        }
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        if (this == bridgeContext) {
            ELContextImpl portletELContext;
            if (elContext instanceof ELContextImpl) {
                portletELContext = (ELContextImpl)elContext;
                portletELContext.setFacesResolved(true);
                portletELContext.setPortletConfig(this.getBridgeConfig().getPortletConfig());
            } else {
                portletELContext = new ELContextImpl(elContext.getELResolver());
                portletELContext.setFacesResolved(false);
            }
            elContext.putContext(ELContextImpl.class, (Object)portletELContext);
        }
    }

    protected void initViewHistory() {
        if (!this.viewHistoryInitialized) {
            Map viewIdDefaultMap = this.bridgeConfig.getDefaultViewMappings();
            for (String mode : viewIdDefaultMap.keySet()) {
                String modeView = (String)viewIdDefaultMap.get(mode);
                if (null == modeView || modeView.length() <= 0) continue;
                this.setViewHistory(mode, modeView, false);
            }
            this.viewHistoryInitialized = true;
        }
    }

    protected boolean isSuffixedMapped(String url, List<String> mappings) {
        String ext = this.extensionMappingFromViewId(url);
        return null != ext && mappings.contains(ext);
    }

    protected String extensionMappingFromViewId(String viewId) {
        int extLoc;
        int index = viewId.indexOf(63);
        if (index != -1) {
            viewId = viewId.substring(0, index);
        }
        if ((extLoc = viewId.lastIndexOf(46)) != -1 && extLoc > viewId.lastIndexOf(47)) {
            StringBuilder sb = new StringBuilder("*");
            sb.append(viewId.substring(extLoc));
            return sb.toString();
        }
        return null;
    }

    protected String viewIdFromSuffixMapping(String url, List<String> suffixes) {
        int index = url.lastIndexOf(46);
        if (index != -1) {
            for (String suffix : suffixes) {
                url = suffix.startsWith(".") ? url.substring(0, index) + suffix : url.substring(0, index) + "." + suffix;
                String testPath = url.startsWith("/") ? url : "/" + url;
                try {
                    if (this.portletContext.getResource(testPath) == null) continue;
                    break;
                }
                catch (MalformedURLException m) {
                    throw new BridgeException("View Id " + testPath + " does not exist.", (Throwable)m);
                }
            }
        }
        return url;
    }

    protected String getPrefix(String url, List<String> mappings) {
        for (String mapping : mappings) {
            int index;
            String prefix = null;
            if (mapping.startsWith("/") && (index = mapping.lastIndexOf("/*")) != -1) {
                prefix = mapping.substring(0, index);
            }
            if (null == prefix || !url.startsWith(prefix)) continue;
            return prefix;
        }
        return null;
    }

    protected String getViewId(PortletRequest request, boolean excludeQueryString) throws BridgeDefaultViewNotSpecifiedException, BridgeInvalidViewPathException {
        int i;
        String requestedMode = request.getPortletMode().toString();
        String viewId = (String)request.getAttribute("javax.portlet.faces.viewId");
        String viewPath = null;
        if (null == viewId && null != (viewPath = (String)request.getAttribute("javax.portlet.faces.viewPath")) && null == (viewId = this.getFacesViewIdFromPath(viewPath))) {
            throw new BridgeInvalidViewPathException("Unable to resolve Faces ViewId for path: " + viewPath);
        }
        if (null == viewId && (viewId = (Bridge.PortletPhase)this.portletRequest.getAttribute("javax.portlet.faces.phase") != Bridge.PortletPhase.RESOURCE_PHASE ? this.portletRequest.getParameter(this.bridgeConfig.getViewIdRenderParameterName()) : this.portletRequest.getParameter(this.bridgeConfig.getViewIdResourceParameterName())) != null && (i = viewId.indexOf(58)) >= 0) {
            String mode = viewId.substring(0, i);
            viewId = viewId.substring(i + 1);
            if (!mode.equalsIgnoreCase(requestedMode)) {
                viewId = null;
            }
        }
        if (null != viewId && excludeQueryString) {
            viewId = this.excludeQuery(viewId);
        }
        return viewId;
    }
}

