package org.jboss.resteasy.resteasy_jaxrs.i18n;

import java.util.Locale;
import jakarta.validation.ElementKind;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.resteasy.annotations.Stream.MODE;
import java.io.UncheckedIOException;
import java.lang.String;
import java.net.URI;
import java.net.URL;
import java.lang.RuntimeException;
import jakarta.ws.rs.core.MediaType;
import java.lang.reflect.AccessibleObject;
import java.util.function.Supplier;
import java.lang.IllegalArgumentException;
import org.jboss.resteasy.spi.config.Threshold;
import jakarta.ws.rs.core.Response.Status;
import javax.annotation.processing.Generated;
import java.lang.CharSequence;
import java.lang.reflect.Method;
import java.io.IOException;
import org.jboss.resteasy.api.validation.ConstraintType.Type;
import java.util.concurrent.CompletionException;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.Class;
import java.util.Arrays;
import java.util.NoSuchElementException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2025-09-27T10:22:25-0700")
public class Messages_$bundle implements Messages, Serializable {
    private static final long serialVersionUID = 1L;
    protected Messages_$bundle() {}
    public static final Messages_$bundle INSTANCE = new Messages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String exceptionHasInvalidFormat$str() {
        return "RESTEASY008500: ResteasyViolationException has invalid format: %s";
    }
    @Override
    public final String exceptionHasInvalidFormat(final String line) {
        return String.format(getLoggingLocale(), exceptionHasInvalidFormat$str(), line);
    }
    protected String unableToParseException$str() {
        return "RESTEASY008525: Unable to parse ResteasyViolationException";
    }
    @Override
    public final String unableToParseException() {
        return String.format(getLoggingLocale(), unableToParseException$str());
    }
    protected String unexpectedPathNode$str() {
        return "RESTEASY008530: unexpected path node type: %s";
    }
    @Override
    public final String unexpectedPathNode(final ElementKind kind) {
        return String.format(getLoggingLocale(), unexpectedPathNode$str(), kind);
    }
    protected String unexpectedPathNodeViolation$str() {
        return "RESTEASY008535: unexpected path node type in method violation: %s";
    }
    @Override
    public final String unexpectedPathNodeViolation(final ElementKind kind) {
        return String.format(getLoggingLocale(), unexpectedPathNodeViolation$str(), kind);
    }
    protected String unexpectedViolationType$str() {
        return "RESTEASY008540: unexpected violation type: %s";
    }
    @Override
    public final String unexpectedViolationType(final Type type) {
        return String.format(getLoggingLocale(), unexpectedViolationType$str(), type);
    }
    protected String unknownObjectPassedAsConstraintViolation$str() {
        return "RESTEASY008545: unknown object passed as constraint violation: %s";
    }
    @Override
    public final String unknownObjectPassedAsConstraintViolation(final Object o) {
        return String.format(getLoggingLocale(), unknownObjectPassedAsConstraintViolation$str(), o);
    }
    protected String alreadyCanceled$str() {
        return "RESTEASY009500: -- already canceled";
    }
    @Override
    public final String alreadyCanceled() {
        return String.format(getLoggingLocale(), alreadyCanceled$str());
    }
    protected String alreadyDone$str() {
        return "RESTEASY009505: -- already done";
    }
    @Override
    public final String alreadyDone() {
        return String.format(getLoggingLocale(), alreadyDone$str());
    }
    protected String alreadySuspended$str() {
        return "RESTEASY009510: Already suspended";
    }
    @Override
    public final String alreadySuspended() {
        return String.format(getLoggingLocale(), alreadySuspended$str());
    }
    protected String cancel$str() {
        return "RESTEASY009515: cancel()";
    }
    @Override
    public final String cancel() {
        return String.format(getLoggingLocale(), cancel$str());
    }
    protected String cancellingWith503$str() {
        return "RESTEASY009520: -- cancelling with 503";
    }
    @Override
    public final String cancellingWith503() {
        return String.format(getLoggingLocale(), cancellingWith503$str());
    }
    protected String onComplete$str() {
        return "RESTEASY009525: onComplete";
    }
    @Override
    public final String onComplete() {
        return String.format(getLoggingLocale(), onComplete$str());
    }
    protected String onTimeout$str() {
        return "RESTEASY009530: onTimeout";
    }
    @Override
    public final String onTimeout() {
        return String.format(getLoggingLocale(), onTimeout$str());
    }
    protected String requestNotSuspended$str() {
        return "RESTEASY009535: Request not suspended";
    }
    @Override
    public final String requestNotSuspended() {
        return String.format(getLoggingLocale(), requestNotSuspended$str());
    }
    protected String scheduledTimeout$str() {
        return "RESTEASY009540: scheduled timeout";
    }
    @Override
    public final String scheduledTimeout() {
        return String.format(getLoggingLocale(), scheduledTimeout$str());
    }
    protected String schedulingTimeout$str() {
        return "RESTEASY009545: scheduling timeout";
    }
    @Override
    public final String schedulingTimeout() {
        return String.format(getLoggingLocale(), schedulingTimeout$str());
    }
    protected String alwaysMarkedAtIndex0$str() {
        return "RESTEASY003000: SelfExpandingBufferredInputStream is always marked at index 0.";
    }
    @Override
    public final String alwaysMarkedAtIndex0() {
        return String.format(getLoggingLocale(), alwaysMarkedAtIndex0$str());
    }
    protected String ambiguousInheritedAnnotations$str() {
        return "RESTEASY003005: Ambiguous inherited qualifying annotations applied to method: %s";
    }
    @Override
    public final String ambiguousInheritedAnnotations(final Method method) {
        return String.format(getLoggingLocale(), ambiguousInheritedAnnotations$str(), method);
    }
    protected String annotationsParamNull$str() {
        return "RESTEASY003010: annotations param was null";
    }
    @Override
    public final String annotationsParamNull() {
        return String.format(getLoggingLocale(), annotationsParamNull$str());
    }
    protected String applicationParamNull$str() {
        return "RESTEASY003015: application param was null";
    }
    @Override
    public final String applicationParamNull() {
        return String.format(getLoggingLocale(), applicationParamNull$str());
    }
    protected String attemptingToCast$str() {
        return "RESTEASY003017: ClassCastException: attempting to cast {0} to {1}";
    }
    @Override
    public final String attemptingToCast(final URL from, final URL to) {
        return _formatMessage(attemptingToCast$str(), from, to);
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    protected String badArguments$str() {
        return "RESTEASY003020: Bad arguments passed to %s";
    }
    @Override
    public final String badArguments(final String methodName) {
        return String.format(getLoggingLocale(), badArguments$str(), methodName);
    }
    protected String badBase64Character$str() {
        return "RESTEASY003025: Bad Base64 input character decimal {0} in array position {1}";
    }
    @Override
    public final String badBase64Character(final int c, final int pos) {
        return _formatMessage(badBase64Character$str(), c, pos);
    }
    protected String base64InputNotProperlyPadded$str() {
        return "RESTEASY003030: Base64 input not properly padded.";
    }
    @Override
    public final String base64InputNotProperlyPadded() {
        return String.format(getLoggingLocale(), base64InputNotProperlyPadded$str());
    }
    protected String base64StringMustHaveFourCharacters$str() {
        return "RESTEASY003035: Base64-encoded string must have at least four characters, but length specified was %s";
    }
    @Override
    public final String base64StringMustHaveFourCharacters(final int len) {
        return String.format(getLoggingLocale(), base64StringMustHaveFourCharacters$str(), len);
    }
    protected String baseURINotSetForClientProxy$str() {
        return "RESTEASY003040: You have not set a base URI for the client proxy";
    }
    @Override
    public final String baseURINotSetForClientProxy() {
        return String.format(getLoggingLocale(), baseURINotSetForClientProxy$str());
    }
    protected String cacheControlMaxAgeHeader$str() {
        return "RESTEASY003045: CacheControl max-age header does not have a value: %s.";
    }
    @Override
    public final String cacheControlMaxAgeHeader(final String value) {
        return String.format(getLoggingLocale(), cacheControlMaxAgeHeader$str(), value);
    }
    protected String cacheControlSMaxAgeHeader$str() {
        return "RESTEASY003050: CacheControl s-maxage header does not have a value: %s.";
    }
    @Override
    public final String cacheControlSMaxAgeHeader(final String value) {
        return String.format(getLoggingLocale(), cacheControlSMaxAgeHeader$str(), value);
    }
    protected String cacheControlValueNull$str() {
        return "RESTEASY003055: Cache-Control value is null";
    }
    @Override
    public final String cacheControlValueNull() {
        return String.format(getLoggingLocale(), cacheControlValueNull$str());
    }
    protected String callbackWasNull$str() {
        return "RESTEASY003060: Callback was null";
    }
    @Override
    public final String callbackWasNull() {
        return String.format(getLoggingLocale(), callbackWasNull$str());
    }
    protected String cannotConsumeContentType$str() {
        return "RESTEASY003065: Cannot consume content type";
    }
    @Override
    public final String cannotConsumeContentType() {
        return String.format(getLoggingLocale(), cannotConsumeContentType$str());
    }
    protected String cannotDecodeNullSourceArray$str() {
        return "RESTEASY003070: Cannot decode null source array.";
    }
    @Override
    public final String cannotDecodeNullSourceArray() {
        return String.format(getLoggingLocale(), cannotDecodeNullSourceArray$str());
    }
    protected String cannotHaveLengthOffset$str() {
        return "RESTEASY003075: Cannot have length offset: %s";
    }
    @Override
    public final String cannotHaveLengthOffset(final int len) {
        return String.format(getLoggingLocale(), cannotHaveLengthOffset$str(), len);
    }
    protected String cannotHaveNegativeOffset$str() {
        return "RESTEASY003080: Cannot have negative offset: %s";
    }
    @Override
    public final String cannotHaveNegativeOffset(final int off) {
        return String.format(getLoggingLocale(), cannotHaveNegativeOffset$str(), off);
    }
    protected String cannotHaveOffset$str() {
        return "RESTEASY003085: Cannot have offset of {0} and length of {1} with array of length {2}";
    }
    @Override
    public final String cannotHaveOffset(final int off, final int len, final int srcLen) {
        return _formatMessage(cannotHaveOffset$str(), off, len, srcLen);
    }
    protected String cannotInjectAsynchronousResponse$str() {
        return "RESTEASY003090: You cannot inject AsynchronousResponse outside the scope of an HTTP request";
    }
    @Override
    public final String cannotInjectAsynchronousResponse() {
        return String.format(getLoggingLocale(), cannotInjectAsynchronousResponse$str());
    }
    protected String cannotInjectIntoForm$str() {
        return "RESTEASY003095: You cannot inject into a form outside the scope of an HTTP request";
    }
    @Override
    public final String cannotInjectIntoForm() {
        return String.format(getLoggingLocale(), cannotInjectIntoForm$str());
    }
    protected String cannotSendFormParametersAndEntity$str() {
        return "RESTEASY003100: You cannot send both form parameters and an entity body";
    }
    @Override
    public final String cannotSendFormParametersAndEntity() {
        return String.format(getLoggingLocale(), cannotSendFormParametersAndEntity$str());
    }
    protected String cannotSerializeNullArray$str() {
        return "RESTEASY003105: Cannot serialize a null array.";
    }
    @Override
    public final String cannotSerializeNullArray() {
        return String.format(getLoggingLocale(), cannotSerializeNullArray$str());
    }
    protected String cannotSerializeNullObject$str() {
        return "RESTEASY003110: Cannot serialize a null object.";
    }
    @Override
    public final String cannotSerializeNullObject() {
        return String.format(getLoggingLocale(), cannotSerializeNullObject$str());
    }
    protected String canOnlySetLinkHeaderRelOrTitle$str() {
        return "RESTEASY003115: You can only set one of LinkHeaderParam.rel() and LinkHeaderParam.title() for on {0}.{1}";
    }
    @Override
    public final String canOnlySetLinkHeaderRelOrTitle(final String className, final String methodName) {
        return _formatMessage(canOnlySetLinkHeaderRelOrTitle$str(), className, methodName);
    }
    protected String cantSetMethod$str() {
        return "RESTEASY003120: Can't set method after match";
    }
    @Override
    public final String cantSetMethod() {
        return String.format(getLoggingLocale(), cantSetMethod$str());
    }
    protected String cantSetURI$str() {
        return "RESTEASY003125: Can't set URI after match";
    }
    @Override
    public final String cantSetURI() {
        return String.format(getLoggingLocale(), cantSetURI$str());
    }
    protected String classIsNotRootResource$str() {
        return "RESTEASY003130: Class is not a root resource.  It, or one of its interfaces must be annotated with @Path: %s implements: ";
    }
    @Override
    public final String classIsNotRootResource(final String className) {
        return String.format(getLoggingLocale(), classIsNotRootResource$str(), className);
    }
    protected String classMustBeAnnotatedWithPath$str() {
        return "RESTEASY003135: Class must be annotated with @Path to invoke path(Class)";
    }
    @Override
    public final String classMustBeAnnotatedWithPath() {
        return String.format(getLoggingLocale(), classMustBeAnnotatedWithPath$str());
    }
    protected String clientRequestDoesntSupportClonable$str() {
        return "RESTEASY003140: ClientRequest doesn't implement Clonable.  Notify the RESTEasy staff right away.";
    }
    @Override
    public final String clientRequestDoesntSupportClonable() {
        return String.format(getLoggingLocale(), clientRequestDoesntSupportClonable$str());
    }
    protected String clientResponseFailureMediaType$str() {
        return "RESTEASY003145: Unable to find a MessageBodyReader of content-type {0} and type {1}";
    }
    @Override
    public final String clientResponseFailureMediaType(final MediaType mediaType, final java.lang.reflect.Type type) {
        return _formatMessage(clientResponseFailureMediaType$str(), mediaType, type);
    }
    protected String clientResponseFailureStatus$str() {
        return "RESTEASY003150: Error status {0} {1} returned";
    }
    @Override
    public final String clientResponseFailureStatus(final int status, final Status responseStatus) {
        return _formatMessage(clientResponseFailureStatus$str(), status, responseStatus);
    }
    protected String constructorMappingInvalid$str() {
        return "RESTEASY003155: Constructor arg paramMapping is invalid";
    }
    @Override
    public final String constructorMappingInvalid() {
        return String.format(getLoggingLocale(), constructorMappingInvalid$str());
    }
    protected String controlCharacterInCookieValue$str() {
        return "RESTEASY003160: Control character in cookie value, consider BASE64 encoding your value";
    }
    @Override
    public final String controlCharacterInCookieValue() {
        return String.format(getLoggingLocale(), controlCharacterInCookieValue$str());
    }
    protected String cookieHeaderValueNull$str() {
        return "RESTEASY003165: Cookie header value was null";
    }
    @Override
    public final String cookieHeaderValueNull() {
        return String.format(getLoggingLocale(), cookieHeaderValueNull$str());
    }
    protected String couldNotCreateEntityFactory$str() {
        return "RESTEASY003170: Could not create a default entity type factory of type {0}";
    }
    @Override
    public final String couldNotCreateEntityFactory(final String className) {
        return _formatMessage(couldNotCreateEntityFactory$str(), className);
    }
    protected String couldNotCreateEntityFactoryMessage$str() {
        return "RESTEASY003175: Could not create a default entity type factory of type {0}. {1}";
    }
    @Override
    public final String couldNotCreateEntityFactoryMessage(final String className, final String message) {
        return _formatMessage(couldNotCreateEntityFactoryMessage$str(), className, message);
    }
    protected String couldNotCreateURI$str() {
        return "RESTEASY003180: Could not create a URI for {0} in {1}.{2}";
    }
    @Override
    public final String couldNotCreateURI(final String uri, final String className, final String methodName) {
        return _formatMessage(couldNotCreateURI$str(), uri, className, methodName);
    }
    protected String couldNotFindClassJndi$str() {
        return "RESTEASY003185: Could not find class %s provided to JNDI Component Resource";
    }
    @Override
    public final String couldNotFindClassJndi(final String className) {
        return String.format(getLoggingLocale(), couldNotFindClassJndi$str(), className);
    }
    protected String couldNotFindConstructor$str() {
        return "RESTEASY003190: Could not find constructor for class: %s";
    }
    @Override
    public final String couldNotFindConstructor(final String className) {
        return String.format(getLoggingLocale(), couldNotFindConstructor$str(), className);
    }
    protected String couldNotFindGetterForParam$str() {
        return "RESTEASY003195: URITemplateAnnotationResolver could not find a getter for param %s";
    }
    @Override
    public final String couldNotFindGetterForParam(final String param) {
        return String.format(getLoggingLocale(), couldNotFindGetterForParam$str(), param);
    }
    protected String couldNotFindMessageBodyReader$str() {
        return "RESTEASY003200: Could not find message body reader for type: {0} of content type: {1}";
    }
    @Override
    public final String couldNotFindMessageBodyReader(final java.lang.reflect.Type type, final MediaType mediaType) {
        return _formatMessage(couldNotFindMessageBodyReader$str(), type, mediaType);
    }
    protected String couldNotFindMethod$str() {
        return "RESTEASY003205: Could not find a method for: %s";
    }
    @Override
    public final String couldNotFindMethod(final Method method) {
        return String.format(getLoggingLocale(), couldNotFindMethod$str(), method);
    }
    protected String couldNotFindResourceForFullPath$str() {
        return "RESTEASY003210: Could not find resource for full path: %s";
    }
    @Override
    public final String couldNotFindResourceForFullPath(final URI uri) {
        return String.format(getLoggingLocale(), couldNotFindResourceForFullPath$str(), uri);
    }
    protected String couldNotFindWriterForContentType$str() {
        return "RESTEASY003215: could not find writer for content-type {0} type: {1}";
    }
    @Override
    public final String couldNotFindWriterForContentType(final MediaType mediaType, final String className) {
        return _formatMessage(couldNotFindWriterForContentType$str(), mediaType, className);
    }
    protected String couldNotGetAValue$str() {
        return "RESTEASY003220: URITemplateAnnotationResolver could not get a value for %s";
    }
    @Override
    public final String couldNotGetAValue(final String param) {
        return String.format(getLoggingLocale(), couldNotGetAValue$str(), param);
    }
    protected String couldNotIntrospectClass$str() {
        return "RESTEASY003225: URITemplateAnnotationResolver could not introspect class %s";
    }
    @Override
    public final String couldNotIntrospectClass(final String className) {
        return String.format(getLoggingLocale(), couldNotIntrospectClass$str(), className);
    }
    protected String couldNotMatchUpLoggerTypeImplementation$str() {
        return "RESTEASY003230: Could not match up an implementation for LoggerType: %s";
    }
    @Override
    public final String couldNotMatchUpLoggerTypeImplementation(final Class<?> loggerType) {
        return String.format(getLoggingLocale(), couldNotMatchUpLoggerTypeImplementation$str(), loggerType);
    }
    protected String couldNotProcessMethod$str() {
        return "RESTEASY003235: Could not process method %s";
    }
    @Override
    public final String couldNotProcessMethod(final Method method) {
        return String.format(getLoggingLocale(), couldNotProcessMethod$str(), method);
    }
    protected String couldNotReadType$str() {
        return "RESTEASY003240: Could not read type {0} for media type {1}";
    }
    @Override
    public final String couldNotReadType(final java.lang.reflect.Type type, final MediaType mediaType) {
        return _formatMessage(couldNotReadType$str(), type, mediaType);
    }
    protected String dateInstancesNotSupported$str() {
        return "RESTEASY003245: Date instances are not supported by this class.";
    }
    @Override
    public final String dateInstancesNotSupported() {
        return String.format(getLoggingLocale(), dateInstancesNotSupported$str());
    }
    protected String dateNull$str() {
        return "RESTEASY003250: date is null";
    }
    @Override
    public final String dateNull() {
        return String.format(getLoggingLocale(), dateNull$str());
    }
    protected String dataToEncodeNull$str() {
        return "RESTEASY003255: Data to encode was null.";
    }
    @Override
    public final String dataToEncodeNull() {
        return String.format(getLoggingLocale(), dataToEncodeNull$str());
    }
    protected String dateValueNull$str() {
        return "RESTEASY003260: dateValue is null";
    }
    @Override
    public final String dateValueNull() {
        return String.format(getLoggingLocale(), dateValueNull$str());
    }
    protected String destinationArrayCannotStoreThreeBytes$str() {
        return "RESTEASY003265: Destination array with length {0} cannot have offset of {1} and still store three bytes.";
    }
    @Override
    public final String destinationArrayCannotStoreThreeBytes(final int len, final int off) {
        return _formatMessage(destinationArrayCannotStoreThreeBytes$str(), len, off);
    }
    protected String destinationArrayNull$str() {
        return "RESTEASY003270: Destination array was null.";
    }
    @Override
    public final String destinationArrayNull() {
        return String.format(getLoggingLocale(), destinationArrayNull$str());
    }
    protected String emptyFieldInHeader$str() {
        return "RESTEASY003275: Empty field in: %s.";
    }
    @Override
    public final String emptyFieldInHeader(final String header) {
        return String.format(getLoggingLocale(), emptyFieldInHeader$str(), header);
    }
    protected String emptyHostName$str() {
        return "RESTEASY003280: empty host name";
    }
    @Override
    public final String emptyHostName() {
        return String.format(getLoggingLocale(), emptyHostName$str());
    }
    protected String entityAlreadyRead$str() {
        return "RESTEASY003285: The entity was already read, and it was of type %s";
    }
    @Override
    public final String entityAlreadyRead(final Class<?> clazz) {
        return String.format(getLoggingLocale(), entityAlreadyRead$str(), clazz);
    }
    protected String entityNotBackedByInputStream$str() {
        return "RESTEASY003290: Entity is not backed by an input stream";
    }
    @Override
    public final String entityNotBackedByInputStream() {
        return String.format(getLoggingLocale(), entityNotBackedByInputStream$str());
    }
    protected String inputStreamWasEmpty$str() {
        return "RESTEASY003291: Input stream was empty, there is no entity";
    }
    @Override
    public final String inputStreamWasEmpty() {
        return String.format(getLoggingLocale(), inputStreamWasEmpty$str());
    }
    protected String streamIsClosed$str() {
        return "RESTEASY003292: Stream is closed";
    }
    @Override
    public final String streamIsClosed() {
        return String.format(getLoggingLocale(), streamIsClosed$str());
    }
    protected String entityNotOfUnderstoodType$str() {
        return "RESTEASY003295: The object you supplied to registerInterceptor is not of an understood type";
    }
    @Override
    public final String entityNotOfUnderstoodType() {
        return String.format(getLoggingLocale(), entityNotOfUnderstoodType$str());
    }
    protected String entityTagValueNull$str() {
        return "RESTEASY003300: value of EntityTag is null";
    }
    @Override
    public final String entityTagValueNull() {
        return String.format(getLoggingLocale(), entityTagValueNull$str());
    }
    protected String errorInBase64Stream$str() {
        return "RESTEASY003305: Error in Base64 code reading stream.";
    }
    @Override
    public final String errorInBase64Stream() {
        return String.format(getLoggingLocale(), errorInBase64Stream$str());
    }
    protected String eTagParamNull$str() {
        return "RESTEASY003310: eTag param null";
    }
    @Override
    public final String eTagParamNull() {
        return String.format(getLoggingLocale(), eTagParamNull$str());
    }
    protected String excededMaximumForwards$str() {
        return "RESTEASY003315: You have exceeded your maximum forwards ResteasyProviderFactory allows.  Last good uri: %s";
    }
    @Override
    public final String excededMaximumForwards(final String uri) {
        return String.format(getLoggingLocale(), excededMaximumForwards$str(), uri);
    }
    protected String expectedExcapedCharacter$str() {
        return "RESTEASY003316: Expected '', '\n', or '\r', got %s";
    }
    @Override
    public final String expectedExcapedCharacter(final int n) {
        return String.format(getLoggingLocale(), expectedExcapedCharacter$str(), n);
    }
    protected String expectedStreamModeGeneralOrRaw$str() {
        return "RESTEASY003317: Expected Stream.MODE.GENERAL or Stream.MODE.RAW, got %s";
    }
    @Override
    public final String expectedStreamModeGeneralOrRaw(final MODE mode) {
        return String.format(getLoggingLocale(), expectedStreamModeGeneralOrRaw$str(), mode);
    }
    protected String expectedStreamOrSseMediaType$str() {
        return "RESTEASY003318: Expected @Stream or @Produces(\"text/event-stream\")";
    }
    @Override
    public final String expectedStreamOrSseMediaType() {
        return String.format(getLoggingLocale(), expectedStreamOrSseMediaType$str());
    }
    protected String expectedStringOrMediaType$str() {
        return "RESTEASY003319: Expected String or MediaType, got %s";
    }
    @Override
    public final String expectedStringOrMediaType(final Object o) {
        return String.format(getLoggingLocale(), expectedStringOrMediaType$str(), o);
    }
    protected String failedProcessingArguments$str() {
        return "RESTEASY003320: Failed processing arguments of %s";
    }
    @Override
    public final String failedProcessingArguments(final String constructor) {
        return String.format(getLoggingLocale(), failedProcessingArguments$str(), constructor);
    }
    protected String failedToConstruct$str() {
        return "RESTEASY003325: Failed to construct %s";
    }
    @Override
    public final String failedToConstruct(final String constructor) {
        return String.format(getLoggingLocale(), failedToConstruct$str(), constructor);
    }
    protected String failedToCreateUri$str() {
        return "RESTEASY003330: Failed to create URI: %s";
    }
    @Override
    public final String failedToCreateUri(final String buf) {
        return String.format(getLoggingLocale(), failedToCreateUri$str(), buf);
    }
    protected String failedToParseCookie$str() {
        return "RESTEASY003335: Failed to parse cookie string '%s'";
    }
    @Override
    public final String failedToParseCookie(final String value) {
        return String.format(getLoggingLocale(), failedToParseCookie$str(), value);
    }
    protected String failureParsingMediaType$str() {
        return "RESTEASY003340: Failure parsing MediaType string: %s";
    }
    @Override
    public final String failureParsingMediaType(final String type) {
        return String.format(getLoggingLocale(), failureParsingMediaType$str(), type);
    }
    protected String fileTooBig$str() {
        return "RESTEASY003345: File is too big for this convenience method (%s bytes).";
    }
    @Override
    public final String fileTooBig(final long len) {
        return String.format(getLoggingLocale(), fileTooBig$str(), len);
    }
    protected String garbageAfterQuotedString$str() {
        return "RESTEASY003350: Garbage after quoted string: %s";
    }
    @Override
    public final String garbageAfterQuotedString(final String header) {
        return String.format(getLoggingLocale(), garbageAfterQuotedString$str(), header);
    }
    protected String getRequestCannotHaveBody$str() {
        return "RESTEASY003355: A GET request cannot have a body.";
    }
    @Override
    public final String getRequestCannotHaveBody() {
        return String.format(getLoggingLocale(), getRequestCannotHaveBody$str());
    }
    protected String gzipExceedsMaxSize$str() {
        return "RESTEASY003357: GZIP input exceeds max size: %s";
    }
    @Override
    public final String gzipExceedsMaxSize(final int size) {
        return String.format(getLoggingLocale(), gzipExceedsMaxSize$str(), size);
    }
    protected String hasNoStringConstructor$str() {
        return "RESTEASY003360: %s has no String constructor";
    }
    @Override
    public final String hasNoStringConstructor(final String className) {
        return String.format(getLoggingLocale(), hasNoStringConstructor$str(), className);
    }
    protected String illegalHexadecimalCharacter$str() {
        return "RESTEASY003365: Illegal hexadecimal character {0} at index {1}";
    }
    @Override
    public final String illegalHexadecimalCharacter(final char ch, final int index) {
        return _formatMessage(illegalHexadecimalCharacter$str(), ch, index);
    }
    protected String illegalResponseMediaType$str() {
        return "RESTEASY003370: Illegal response media type: %s";
    }
    @Override
    public final String illegalResponseMediaType(final String mediaType) {
        return String.format(getLoggingLocale(), illegalResponseMediaType$str(), mediaType);
    }
    protected String illegalToInjectCookieParam$str() {
        return "RESTEASY003375: It is illegal to inject a @CookieParam into a singleton";
    }
    @Override
    public final String illegalToInjectCookieParam() {
        return String.format(getLoggingLocale(), illegalToInjectCookieParam$str());
    }
    protected String illegalToInjectFormParam$str() {
        return "RESTEASY003380: It is illegal to inject a @FormParam into a singleton";
    }
    @Override
    public final String illegalToInjectFormParam() {
        return String.format(getLoggingLocale(), illegalToInjectFormParam$str());
    }
    protected String illegalToInjectHeaderParam$str() {
        return "RESTEASY003385: It is illegal to inject a @HeaderParam into a singleton";
    }
    @Override
    public final String illegalToInjectHeaderParam() {
        return String.format(getLoggingLocale(), illegalToInjectHeaderParam$str());
    }
    protected String illegalToInjectMatrixParam$str() {
        return "RESTEASY003390: It is illegal to inject a @MatrixParam into a singleton";
    }
    @Override
    public final String illegalToInjectMatrixParam() {
        return String.format(getLoggingLocale(), illegalToInjectMatrixParam$str());
    }
    protected String illegalToInjectMessageBody$str() {
        return "RESTEASY003395: Illegal to inject a message body into a singleton into %s";
    }
    @Override
    public final String illegalToInjectMessageBody(final AccessibleObject target) {
        return String.format(getLoggingLocale(), illegalToInjectMessageBody$str(), target);
    }
    protected String illegalToInjectNonInterfaceType$str() {
        return "RESTEASY003400: Illegal to inject a non-interface type into a singleton";
    }
    @Override
    public final String illegalToInjectNonInterfaceType() {
        return String.format(getLoggingLocale(), illegalToInjectNonInterfaceType$str());
    }
    protected String illegalToInjectPathParam$str() {
        return "RESTEASY003405: It is illegal to inject a @PathParam into a singleton";
    }
    @Override
    public final String illegalToInjectPathParam() {
        return String.format(getLoggingLocale(), illegalToInjectPathParam$str());
    }
    protected String illegalToInjectQueryParam$str() {
        return "RESTEASY003410: It is illegal to inject a @QueryParam into a singleton";
    }
    @Override
    public final String illegalToInjectQueryParam() {
        return String.format(getLoggingLocale(), illegalToInjectQueryParam$str());
    }
    protected String illegalUriTemplate$str() {
        return "RESTEASY003415: Illegal uri template: %s";
    }
    @Override
    public final String illegalUriTemplate(final CharSequence template) {
        return String.format(getLoggingLocale(), illegalUriTemplate$str(), template);
    }
    protected String improperlyPaddedBase64Input$str() {
        return "RESTEASY003420: Improperly padded Base64 input.";
    }
    @Override
    public final String improperlyPaddedBase64Input() {
        return String.format(getLoggingLocale(), improperlyPaddedBase64Input$str());
    }
    protected String incorrectTypeParameterClientExceptionMapper$str() {
        return "RESTEASY003425: Incorrect type parameter. ClientExceptionMapper requires a subclass of java.lang.Throwable as its type parameter.";
    }
    @Override
    public final String incorrectTypeParameterClientExceptionMapper() {
        return String.format(getLoggingLocale(), incorrectTypeParameterClientExceptionMapper$str());
    }
    protected String incorrectTypeParameterExceptionMapper$str() {
        return "RESTEASY003430: Incorrect type parameter. ExceptionMapper requires a subclass of java.lang.Throwable as its type parameter.";
    }
    @Override
    public final String incorrectTypeParameterExceptionMapper() {
        return String.format(getLoggingLocale(), incorrectTypeParameterExceptionMapper$str());
    }
    protected String inputStreamEmpty$str() {
        return "RESTEASY003435: Input stream was empty, there is no entity";
    }
    @Override
    public final String inputStreamEmpty() {
        return String.format(getLoggingLocale(), inputStreamEmpty$str());
    }
    protected String inputStringNull$str() {
        return "RESTEASY003440: Input string was null.";
    }
    @Override
    public final String inputStringNull() {
        return String.format(getLoggingLocale(), inputStringNull$str());
    }
    protected String interceptorClassMustBeAnnotated$str() {
        return "RESTEASY003445: Interceptor class must be annotated with @ServerInterceptor and/or @ClientInterceptor";
    }
    @Override
    public final String interceptorClassMustBeAnnotated() {
        return String.format(getLoggingLocale(), interceptorClassMustBeAnnotated$str());
    }
    protected String interceptorClassMustBeAnnotatedWithClass$str() {
        return "RESTEASY003450: Interceptor class %s must be annotated with @ServerInterceptor and/or @ClientInterceptor";
    }
    @Override
    public final String interceptorClassMustBeAnnotatedWithClass(final Class<?> clazz) {
        return String.format(getLoggingLocale(), interceptorClassMustBeAnnotatedWithClass$str(), clazz);
    }
    protected String interceptorNullFromClass$str() {
        return "RESTEASY003455: interceptor null from class: %s";
    }
    @Override
    public final String interceptorNullFromClass(final String className) {
        return String.format(getLoggingLocale(), interceptorNullFromClass$str(), className);
    }
    protected String invalidCharacterInBase64Data$str() {
        return "RESTEASY003460: Invalid character in Base64 data.";
    }
    @Override
    public final String invalidCharacterInBase64Data() {
        return String.format(getLoggingLocale(), invalidCharacterInBase64Data$str());
    }
    protected String invalidEscapeCharacterInCookieValue$str() {
        return "RESTEASY003465: Invalid escape character in cookie value.";
    }
    @Override
    public final String invalidEscapeCharacterInCookieValue() {
        return String.format(getLoggingLocale(), invalidEscapeCharacterInCookieValue$str());
    }
    protected String invalidHost$str() {
        return "RESTEASY003470: invalid host";
    }
    @Override
    public final String invalidHost() {
        return String.format(getLoggingLocale(), invalidHost$str());
    }
    protected String invalidPort$str() {
        return "RESTEASY003475: Invalid port value";
    }
    @Override
    public final String invalidPort() {
        return String.format(getLoggingLocale(), invalidPort$str());
    }
    protected String isNotInitialRequest$str() {
        return "RESTEASY003480: %s is not initial request.  Its suspended and retried.  Aborting.";
    }
    @Override
    public final String isNotInitialRequest(final String path) {
        return String.format(getLoggingLocale(), isNotInitialRequest$str(), path);
    }
    protected String jndiComponentResourceNotSetCorrectly$str() {
        return "RESTEASY003485: JNDI Component Resource variable is not set correctly: jndi;class;true|false comma delimited";
    }
    @Override
    public final String jndiComponentResourceNotSetCorrectly() {
        return String.format(getLoggingLocale(), jndiComponentResourceNotSetCorrectly$str());
    }
    protected String keyCouldNotBeParsed$str() {
        return "RESTEASY003490: The %s config in web.xml could not be parsed, accepted values are true,false or 1,0";
    }
    @Override
    public final String keyCouldNotBeParsed(final String key) {
        return String.format(getLoggingLocale(), keyCouldNotBeParsed$str(), key);
    }
    protected String lastModifiedParamNull$str() {
        return "RESTEASY003495: lastModified param null";
    }
    @Override
    public final String lastModifiedParamNull() {
        return String.format(getLoggingLocale(), lastModifiedParamNull$str());
    }
    protected String localeValueNull$str() {
        return "RESTEASY003500: Locale value is null";
    }
    @Override
    public final String localeValueNull() {
        return String.format(getLoggingLocale(), localeValueNull$str());
    }
    protected String malformedMediaType$str() {
        return "RESTEASY003505: Malformed media type: %s";
    }
    @Override
    public final String malformedMediaType(final String header) {
        return String.format(getLoggingLocale(), malformedMediaType$str(), header);
    }
    protected String malformedParameter$str() {
        return "RESTEASY003510: Malformed parameter: %s";
    }
    @Override
    public final String malformedParameter(final String parameter) {
        return String.format(getLoggingLocale(), malformedParameter$str(), parameter);
    }
    protected String malformedParameters$str() {
        return "RESTEASY003515: Malformed parameters: %s.";
    }
    @Override
    public final String malformedParameters(final String header) {
        return String.format(getLoggingLocale(), malformedParameters$str(), header);
    }
    protected String malformedQualityValue$str() {
        return "RESTEASY003520: Malformed quality value.";
    }
    @Override
    public final String malformedQualityValue() {
        return String.format(getLoggingLocale(), malformedQualityValue$str());
    }
    protected String mapKeyNull$str() {
        return "RESTEASY003525: map key is null";
    }
    @Override
    public final String mapKeyNull() {
        return String.format(getLoggingLocale(), mapKeyNull$str());
    }
    protected String mapValueNull$str() {
        return "RESTEASY003530: map value is null";
    }
    @Override
    public final String mapValueNull() {
        return String.format(getLoggingLocale(), mapValueNull$str());
    }
    protected String marshalledEntityMustHaveTypeInfo$str() {
        return "RESTEASY003535: MarshalledEntity must have type information.";
    }
    @Override
    public final String marshalledEntityMustHaveTypeInfo() {
        return String.format(getLoggingLocale(), marshalledEntityMustHaveTypeInfo$str());
    }
    protected String mediaTypeQGreaterThan1$str() {
        return "RESTEASY003540: MediaType q value cannot be greater than 1.0: %s";
    }
    @Override
    public final String mediaTypeQGreaterThan1(final String mediaType) {
        return String.format(getLoggingLocale(), mediaTypeQGreaterThan1$str(), mediaType);
    }
    protected String mediaTypeQMustBeFloat$str() {
        return "RESTEASY003545: MediaType q parameter must be a float: %s";
    }
    @Override
    public final String mediaTypeQMustBeFloat(final MediaType mediaType) {
        return String.format(getLoggingLocale(), mediaTypeQMustBeFloat$str(), mediaType);
    }
    protected String mediaTypeQWeightedLanguageMustBeFloat$str() {
        return "RESTEASY003550: MediaType q parameter must be a float: %s";
    }
    @Override
    public final String mediaTypeQWeightedLanguageMustBeFloat(final String lang) {
        return String.format(getLoggingLocale(), mediaTypeQWeightedLanguageMustBeFloat$str(), lang);
    }
    protected String mediaTypeValueNull$str() {
        return "RESTEASY003555: MediaType value is null";
    }
    @Override
    public final String mediaTypeValueNull() {
        return String.format(getLoggingLocale(), mediaTypeValueNull$str());
    }
    protected String methodNotAnnotatedWithPath$str() {
        return "RESTEASY003560: method is not annotated with @Path";
    }
    @Override
    public final String methodNotAnnotatedWithPath() {
        return String.format(getLoggingLocale(), methodNotAnnotatedWithPath$str());
    }
    protected String methodNull$str() {
        return "RESTEASY003565: method was null";
    }
    @Override
    public final String methodNull() {
        return String.format(getLoggingLocale(), methodNull$str());
    }
    protected String missingTypeParameter$str() {
        return "RESTEASY003570: Missing type parameter.";
    }
    @Override
    public final String missingTypeParameter() {
        return String.format(getLoggingLocale(), missingTypeParameter$str());
    }
    protected String mustDefineConsumes$str() {
        return "RESTEASY003575: You must define a @Consumes type on your client method or interface, or supply a default";
    }
    @Override
    public final String mustDefineConsumes() {
        return String.format(getLoggingLocale(), mustDefineConsumes$str());
    }
    protected String mustSetLinkHeaderRelOrTitle$str() {
        return "RESTEASY003580: You must set either LinkHeaderParam.rel() or LinkHeaderParam.title() for on {0}.{1}";
    }
    @Override
    public final String mustSetLinkHeaderRelOrTitle(final String className, final String methodName) {
        return _formatMessage(mustSetLinkHeaderRelOrTitle$str(), className, methodName);
    }
    protected String mustSetEitherPortOrSSLPort$str() {
        return "RESTEASY003585: You must set either the port or ssl port, not both";
    }
    @Override
    public final String mustSetEitherPortOrSSLPort() {
        return String.format(getLoggingLocale(), mustSetEitherPortOrSSLPort$str());
    }
    protected String mustSetPort$str() {
        return "RESTEASY003590: You must set the port or ssl port";
    }
    @Override
    public final String mustSetPort() {
        return String.format(getLoggingLocale(), mustSetPort$str());
    }
    protected String mustUseOneHttpMethod$str() {
        return "RESTEASY003595: You must use at least one, but no more than one http method annotation on: %s";
    }
    @Override
    public final String mustUseOneHttpMethod(final String methodName) {
        return String.format(getLoggingLocale(), mustUseOneHttpMethod$str(), methodName);
    }
    protected String nameParameterNull$str() {
        return "RESTEASY003600: name parameter is null";
    }
    @Override
    public final String nameParameterNull() {
        return String.format(getLoggingLocale(), nameParameterNull$str());
    }
    protected String nameParamIsNull$str() {
        return "RESTEASY003605: name param is null";
    }
    @Override
    public final String nameParamIsNull() {
        return String.format(getLoggingLocale(), nameParamIsNull$str());
    }
    protected String nameParamWasNull$str() {
        return "RESTEASY003610: name param was null";
    }
    @Override
    public final String nameParamWasNull() {
        return String.format(getLoggingLocale(), nameParamWasNull$str());
    }
    protected String newCookieValueNull$str() {
        return "RESTEASY003615: NewCookie value is null";
    }
    @Override
    public final String newCookieValueNull() {
        return String.format(getLoggingLocale(), newCookieValueNull$str());
    }
    protected String noContent$str() {
        return "RESTEASY003620: No content";
    }
    @Override
    public final String noContent() {
        return String.format(getLoggingLocale(), noContent$str());
    }
    protected String noContentContentLength0$str() {
        return "RESTEASY003625: No content.  Content-Length is 0";
    }
    @Override
    public final String noContentContentLength0() {
        return String.format(getLoggingLocale(), noContentContentLength0$str());
    }
    protected String noLongerASupportedContextParam$str() {
        return "RESTEASY003630: %s is no longer a supported context param.  See documentation for more details";
    }
    @Override
    public final String noLongerASupportedContextParam(final String paramName) {
        return String.format(getLoggingLocale(), noLongerASupportedContextParam$str(), paramName);
    }
    protected String noMatchForAcceptHeader$str() {
        return "RESTEASY003635: No match for accept header";
    }
    @Override
    public final String noMatchForAcceptHeader() {
        return String.format(getLoggingLocale(), noMatchForAcceptHeader$str());
    }
    protected String noOutputStreamAllowed$str() {
        return "RESTEASY003640: No output stream allowed";
    }
    @Override
    public final String noOutputStreamAllowed() {
        return String.format(getLoggingLocale(), noOutputStreamAllowed$str());
    }
    protected String noPublicPathAnnotatedMethod$str() {
        return "RESTEASY003645: No public @Path annotated method for {0}.{1}";
    }
    @Override
    public final String noPublicPathAnnotatedMethod(final String resource, final String method) {
        return _formatMessage(noPublicPathAnnotatedMethod$str(), resource, method);
    }
    protected String noResourceMethodFoundForHttpMethod$str() {
        return "RESTEASY003650: No resource method found for %s, return 405 with Allow header";
    }
    @Override
    public final String noResourceMethodFoundForHttpMethod(final String httpMethod) {
        return String.format(getLoggingLocale(), noResourceMethodFoundForHttpMethod$str(), httpMethod);
    }
    protected String noResourceMethodFoundForOptions$str() {
        return "RESTEASY003655: No resource method found for options, return OK with Allow header";
    }
    @Override
    public final String noResourceMethodFoundForOptions() {
        return String.format(getLoggingLocale(), noResourceMethodFoundForOptions$str());
    }
    protected String noTypeInformationForEntity$str() {
        return "RESTEASY003660: No type information to extract entity with, use other getEntity() methods";
    }
    @Override
    public final String noTypeInformationForEntity() {
        return String.format(getLoggingLocale(), noTypeInformationForEntity$str());
    }
    protected String notAllowedToReflectOnMethod$str() {
        return "RESTEASY003665: Not allowed to reflect on method: %s";
    }
    @Override
    public final String notAllowedToReflectOnMethod(final String methodName) {
        return String.format(getLoggingLocale(), notAllowedToReflectOnMethod$str(), methodName);
    }
    protected String notEnoughPathParameters$str() {
        return "RESTEASY003670: You did not supply enough values to fill path parameters";
    }
    @Override
    public final String notEnoughPathParameters() {
        return String.format(getLoggingLocale(), notEnoughPathParameters$str());
    }
    protected String notValidInjectableType$str() {
        return "RESTEASY003675: %s is not a valid injectable type for @Suspend";
    }
    @Override
    public final String notValidInjectableType(final String typeName) {
        return String.format(getLoggingLocale(), notValidInjectableType$str(), typeName);
    }
    protected String nullSubresource$str() {
        return "RESTEASY003680: Null subresource for path: %s.";
    }
    @Override
    public final String nullSubresource(final URI uri) {
        return String.format(getLoggingLocale(), nullSubresource$str(), uri);
    }
    protected String nullValue$str() {
        return "RESTEASY003685: null value";
    }
    @Override
    public final String nullValue() {
        return String.format(getLoggingLocale(), nullValue$str());
    }
    protected String numberOfMatchedSegments$str() {
        return "RESTEASY003690: Number of matched segments greater than actual";
    }
    @Override
    public final String numberOfMatchedSegments() {
        return String.format(getLoggingLocale(), numberOfMatchedSegments$str());
    }
    protected String oddNumberOfCharacters$str() {
        return "RESTEASY003695: Odd number of characters.";
    }
    @Override
    public final String oddNumberOfCharacters() {
        return String.format(getLoggingLocale(), oddNumberOfCharacters$str());
    }
    protected String originNotAllowed$str() {
        return "RESTEASY003700: Origin not allowed: %s";
    }
    @Override
    public final String originNotAllowed(final String origin) {
        return String.format(getLoggingLocale(), originNotAllowed$str(), origin);
    }
    protected String paramNull$str() {
        return "RESTEASY003705: param was null";
    }
    @Override
    public final String paramNull() {
        return String.format(getLoggingLocale(), paramNull$str());
    }
    protected String passedInValueNull$str() {
        return "RESTEASY003710: A passed in value was null";
    }
    @Override
    public final String passedInValueNull() {
        return String.format(getLoggingLocale(), passedInValueNull$str());
    }
    protected String pathNull$str() {
        return "RESTEASY003715: path was null";
    }
    @Override
    public final String pathNull() {
        return String.format(getLoggingLocale(), pathNull$str());
    }
    protected String pathParameterNotProvided$str() {
        return "RESTEASY003720: path param %s has not been provided by the parameter map";
    }
    @Override
    public final String pathParameterNotProvided(final String param) {
        return String.format(getLoggingLocale(), pathParameterNotProvided$str(), param);
    }
    protected String regexPathParameterResultEmpty$str() {
        return "RESTEASY003723: path param %s regex expression %s yields an empty string";
    }
    @Override
    public final String regexPathParameterResultEmpty(final String param, final String regexText) {
        return String.format(getLoggingLocale(), regexPathParameterResultEmpty$str(), param, regexText);
    }
    protected String patternNull$str() {
        return "RESTEASY003725: pattern is null";
    }
    @Override
    public final String patternNull() {
        return String.format(getLoggingLocale(), patternNull$str());
    }
    protected String qValueCannotBeGreaterThan1$str() {
        return "RESTEASY003730: Accept-Language q value cannot be greater than 1.0 %s";
    }
    @Override
    public final String qValueCannotBeGreaterThan1(final String lang) {
        return String.format(getLoggingLocale(), qValueCannotBeGreaterThan1$str(), lang);
    }
    protected String quotedStringIsNotClosed$str() {
        return "RESTEASY003735: Quoted string is not closed: %s";
    }
    @Override
    public final String quotedStringIsNotClosed(final String header) {
        return String.format(getLoggingLocale(), quotedStringIsNotClosed$str(), header);
    }
    protected String relParamNull$str() {
        return "RESTEASY003740: rel param was null";
    }
    @Override
    public final String relParamNull() {
        return String.format(getLoggingLocale(), relParamNull$str());
    }
    protected String removingHeaderIllegal$str() {
        return "RESTEASY003745: Removing a header is illegal for an HttpServletResponse";
    }
    @Override
    public final String removingHeaderIllegal() {
        return String.format(getLoggingLocale(), removingHeaderIllegal$str());
    }
    protected String requestMediaTypeNotUrlencoded$str() {
        return "RESTEASY003750: Request media type is not application/x-www-form-urlencoded";
    }
    @Override
    public final String requestMediaTypeNotUrlencoded() {
        return String.format(getLoggingLocale(), requestMediaTypeNotUrlencoded$str());
    }
    protected String requestWasAlreadyExecuted$str() {
        return "RESTEASY003755: Request was already executed";
    }
    @Override
    public final String requestWasAlreadyExecuted() {
        return String.format(getLoggingLocale(), requestWasAlreadyExecuted$str());
    }
    protected String resourceNull$str() {
        return "RESTEASY003760: resource was null";
    }
    @Override
    public final String resourceNull() {
        return String.format(getLoggingLocale(), resourceNull$str());
    }
    protected String responseIsClosed$str() {
        return "RESTEASY003765: Response is closed.";
    }
    @Override
    public final String responseIsClosed() {
        return String.format(getLoggingLocale(), responseIsClosed$str());
    }
    protected String responseIsCommitted$str() {
        return "RESTEASY003770: Response is committed, can't handle exception";
    }
    @Override
    public final String responseIsCommitted() {
        return String.format(getLoggingLocale(), responseIsCommitted$str());
    }
    protected String schemeSpecificPartNull$str() {
        return "RESTEASY003775: schemeSpecificPart was null";
    }
    @Override
    public final String schemeSpecificPartNull() {
        return String.format(getLoggingLocale(), schemeSpecificPartNull$str());
    }
    protected String segmentNull$str() {
        return "RESTEASY003780: A segment is null";
    }
    @Override
    public final String segmentNull() {
        return String.format(getLoggingLocale(), segmentNull$str());
    }
    protected String segmentsParameterNull$str() {
        return "RESTEASY003785: segments parameter was null";
    }
    @Override
    public final String segmentsParameterNull() {
        return String.format(getLoggingLocale(), segmentsParameterNull$str());
    }
    protected String shouldBeUnreachable$str() {
        return "RESTEASY003790: Should be unreachable";
    }
    @Override
    public final String shouldBeUnreachable() {
        return String.format(getLoggingLocale(), shouldBeUnreachable$str());
    }
    protected String sourceArrayCannotProcessBytes$str() {
        return "RESTEASY003795: Source array with length {0} cannot have offset of {1} and process {2} bytes.";
    }
    @Override
    public final String sourceArrayCannotProcessBytes(final int srcLen, final int off, final int len) {
        return _formatMessage(sourceArrayCannotProcessBytes$str(), srcLen, off, len);
    }
    protected String sourceArrayCannotProcessFourBytes$str() {
        return "RESTEASY003800: Source array with length {0} cannot have offset of {1} and still process four bytes.";
    }
    @Override
    public final String sourceArrayCannotProcessFourBytes(final int srcLen, final int off) {
        return _formatMessage(sourceArrayCannotProcessFourBytes$str(), srcLen, off);
    }
    protected String sourceArrayNull$str() {
        return "RESTEASY003805: Source array was null.";
    }
    @Override
    public final String sourceArrayNull() {
        return String.format(getLoggingLocale(), sourceArrayNull$str());
    }
    protected String streamWrappedBySignature$str() {
        return "RESTEASY003810: Stream wrapped by Signature, cannot reset the stream without destroying signature";
    }
    @Override
    public final String streamWrappedBySignature() {
        return String.format(getLoggingLocale(), streamWrappedBySignature$str());
    }
    protected String subresourceHasNoJaxRsAnnotations$str() {
        return "RESTEASY003815: Subresource for target class has no qualifying annotations.: %s";
    }
    @Override
    public final String subresourceHasNoJaxRsAnnotations(final String className) {
        return String.format(getLoggingLocale(), subresourceHasNoJaxRsAnnotations$str(), className);
    }
    protected String tClassParameterNull$str() {
        return "RESTEASY003820: tClass parameter is null";
    }
    @Override
    public final String tClassParameterNull() {
        return String.format(getLoggingLocale(), tClassParameterNull$str());
    }
    protected String tailingGarbage$str() {
        return "RESTEASY003825: Tailing garbage: %s";
    }
    @Override
    public final String tailingGarbage(final String header) {
        return String.format(getLoggingLocale(), tailingGarbage$str(), header);
    }
    protected String templateParameterNull$str() {
        return "RESTEASY003830: NULL value for template parameter: %s";
    }
    @Override
    public final String templateParameterNull(final String param) {
        return String.format(getLoggingLocale(), templateParameterNull$str(), param);
    }
    protected String templateValuesParamNull$str() {
        return "RESTEASY003835: templateValues param null";
    }
    @Override
    public final String templateValuesParamNull() {
        return String.format(getLoggingLocale(), templateValuesParamNull$str());
    }
    protected String titleParamNull$str() {
        return "RESTEASY003840: title param was null";
    }
    @Override
    public final String titleParamNull() {
        return String.format(getLoggingLocale(), titleParamNull$str());
    }
    protected String twoMethodsSameName$str() {
        return "RESTEASY003845: there are two method named %s";
    }
    @Override
    public final String twoMethodsSameName(final String method) {
        return String.format(getLoggingLocale(), twoMethodsSameName$str(), method);
    }
    protected String typeParamNull$str() {
        return "RESTEASY003850: type param was null";
    }
    @Override
    public final String typeParamNull() {
        return String.format(getLoggingLocale(), typeParamNull$str());
    }
    protected String unableToCreateURI$str() {
        return "RESTEASY003855: Unable to create URI: %s";
    }
    @Override
    public final String unableToCreateURI(final String buf) {
        return String.format(getLoggingLocale(), unableToCreateURI$str(), buf);
    }
    protected String unableToDecodeQueryString$str() {
        return "RESTEASY003860: Unable to decode query string";
    }
    @Override
    public final String unableToDecodeQueryString() {
        return String.format(getLoggingLocale(), unableToDecodeQueryString$str());
    }
    protected String unableToDetermineBaseClass$str() {
        return "RESTEASY003865: Unable to determine base class from Type";
    }
    @Override
    public final String unableToDetermineBaseClass() {
        return String.format(getLoggingLocale(), unableToDetermineBaseClass$str());
    }
    protected String unableToExtractParameter$str() {
        return "RESTEASY003870: Unable to extract parameter from http request: %s value is '%s'";
    }
    @Override
    public final String unableToExtractParameter(final String paramSignature, final String strVal) {
        return String.format(getLoggingLocale(), unableToExtractParameter$str(), paramSignature, strVal);
    }
    protected String unableToFindConstructor$str() {
        return "RESTEASY003875: Unable to find a constructor that takes a String param or a valueOf() or fromString() method for {0} on {1} for basetype: {2}";
    }
    @Override
    public final String unableToFindConstructor(final String paramSignature, final AccessibleObject target, final String className) {
        return _formatMessage(unableToFindConstructor$str(), paramSignature, target, className);
    }
    protected String unableToFindContextualData$str() {
        return "RESTEASY003880: Unable to find contextual data of type: %s";
    }
    @Override
    public final String unableToFindContextualData(final String className) {
        return String.format(getLoggingLocale(), unableToFindContextualData$str(), className);
    }
    protected String unableToFindInjectorFactory$str() {
        return "RESTEASY003885: Unable to find InjectorFactory implementation.";
    }
    @Override
    public final String unableToFindInjectorFactory() {
        return String.format(getLoggingLocale(), unableToFindInjectorFactory$str());
    }
    protected String unableToFindJaxRsResource$str() {
        return "RESTEASY003890: Unable to find resource associated with path: %s.";
    }
    @Override
    public final String unableToFindJaxRsResource(final String path) {
        return String.format(getLoggingLocale(), unableToFindJaxRsResource$str(), path);
    }
    protected String unableToFindPublicConstructorForClass$str() {
        return "RESTEASY003895: Unable to find a public constructor for class %s";
    }
    @Override
    public final String unableToFindPublicConstructorForClass(final String className) {
        return String.format(getLoggingLocale(), unableToFindPublicConstructorForClass$str(), className);
    }
    protected String unableToFindPublicConstructorForProvider$str() {
        return "RESTEASY003900: Unable to find a public constructor for provider class %s";
    }
    @Override
    public final String unableToFindPublicConstructorForProvider(final String className) {
        return String.format(getLoggingLocale(), unableToFindPublicConstructorForProvider$str(), className);
    }
    protected String unableToFindTypeArguments$str() {
        return "RESTEASY003905: Unable to find type arguments of %s";
    }
    @Override
    public final String unableToFindTypeArguments(final Class<?> clazz) {
        return String.format(getLoggingLocale(), unableToFindTypeArguments$str(), clazz);
    }
    protected String unableToInstantiateClientExceptionMapper$str() {
        return "RESTEASY003910: Unable to instantiate ClientExceptionMapper";
    }
    @Override
    public final String unableToInstantiateClientExceptionMapper() {
        return String.format(getLoggingLocale(), unableToInstantiateClientExceptionMapper$str());
    }
    protected String unableToInstantiateContextObject$str() {
        return "RESTEASY003915: Unable to instantiate context object %s";
    }
    @Override
    public final String unableToInstantiateContextObject(final String key) {
        return String.format(getLoggingLocale(), unableToInstantiateContextObject$str(), key);
    }
    protected String unableToInstantiateContextResolver$str() {
        return "RESTEASY003920: Unable to instantiate ContextResolver";
    }
    @Override
    public final String unableToInstantiateContextResolver() {
        return String.format(getLoggingLocale(), unableToInstantiateContextResolver$str());
    }
    protected String unableToInstantiateExceptionMapper$str() {
        return "RESTEASY003925: Unable to instantiate ExceptionMapper";
    }
    @Override
    public final String unableToInstantiateExceptionMapper() {
        return String.format(getLoggingLocale(), unableToInstantiateExceptionMapper$str());
    }
    protected String unableToInstantiateForm$str() {
        return "RESTEASY003930: Unable to instantiate @Form class. No no-arg constructor.";
    }
    @Override
    public final String unableToInstantiateForm() {
        return String.format(getLoggingLocale(), unableToInstantiateForm$str());
    }
    protected String unableToInstantiateInjectorFactory$str() {
        return "RESTEASY003935: Unable to instantiate InjectorFactory implementation.";
    }
    @Override
    public final String unableToInstantiateInjectorFactory() {
        return String.format(getLoggingLocale(), unableToInstantiateInjectorFactory$str());
    }
    protected String unableToInstantiateMessageBodyReader$str() {
        return "RESTEASY003940: Unable to instantiate MessageBodyReader";
    }
    @Override
    public final String unableToInstantiateMessageBodyReader() {
        return String.format(getLoggingLocale(), unableToInstantiateMessageBodyReader$str());
    }
    protected String unableToInstantiateMessageBodyWriter$str() {
        return "RESTEASY003945: Unable to instantiate MessageBodyWriter";
    }
    @Override
    public final String unableToInstantiateMessageBodyWriter() {
        return String.format(getLoggingLocale(), unableToInstantiateMessageBodyWriter$str());
    }
    protected String unableToParseDate$str() {
        return "RESTEASY003950: Unable to parse the date %s";
    }
    @Override
    public final String unableToParseDate(final String dateValue) {
        return String.format(getLoggingLocale(), unableToParseDate$str(), dateValue);
    }
    protected String unableToParseLinkHeaderNoEndToLink$str() {
        return "RESTEASY003955: Unable to parse Link header.  No end to link: %s";
    }
    @Override
    public final String unableToParseLinkHeaderNoEndToLink(final String value) {
        return String.format(getLoggingLocale(), unableToParseLinkHeaderNoEndToLink$str(), value);
    }
    protected String unableToParseLinkHeaderNoEndToParameter$str() {
        return "RESTEASY003960: Unable to parse Link header.  No end to parameter: %s";
    }
    @Override
    public final String unableToParseLinkHeaderNoEndToParameter(final String value) {
        return String.format(getLoggingLocale(), unableToParseLinkHeaderNoEndToParameter$str(), value);
    }
    protected String unableToParseLinkHeaderTooManyLinks$str() {
        return "RESTEASY003965: Unable to parse Link header. Too many links in declaration: %s";
    }
    @Override
    public final String unableToParseLinkHeaderTooManyLinks(final String value) {
        return String.format(getLoggingLocale(), unableToParseLinkHeaderTooManyLinks$str(), value);
    }
    protected String unableToResolveTypeVariable$str() {
        return "RESTEASY003970: Unable to resolve type variable";
    }
    @Override
    public final String unableToResolveTypeVariable() {
        return String.format(getLoggingLocale(), unableToResolveTypeVariable$str());
    }
    protected String unableToUnmarshalResponse$str() {
        return "RESTEASY003975: Unable to unmarshall response for %s";
    }
    @Override
    public final String unableToUnmarshalResponse(final String attributeExceptionsTo) {
        return String.format(getLoggingLocale(), unableToUnmarshalResponse$str(), attributeExceptionsTo);
    }
    protected String unexpectedNumberSubclass$str() {
        return "RESTEASY003977: Unexpected Number subclass: %s";
    }
    @Override
    public final String unexpectedNumberSubclass(final String classname) {
        return String.format(getLoggingLocale(), unexpectedNumberSubclass$str(), classname);
    }
    protected String unknownInterceptorPrecedence$str() {
        return "RESTEASY003980: Unknown interceptor precedence: %s";
    }
    @Override
    public final String unknownInterceptorPrecedence(final String precedence) {
        return String.format(getLoggingLocale(), unknownInterceptorPrecedence$str(), precedence);
    }
    protected String unknownMediaTypeResponseEntity$str() {
        return "RESTEASY003985: Unknown media type for response entity";
    }
    @Override
    public final String unknownMediaTypeResponseEntity() {
        return String.format(getLoggingLocale(), unknownMediaTypeResponseEntity$str());
    }
    protected String unknownPathParam$str() {
        return "RESTEASY003990: Unknown @PathParam: {0} for path: {1}";
    }
    @Override
    public final String unknownPathParam(final String paramName, final String path) {
        return _formatMessage(unknownPathParam$str(), paramName, path);
    }
    protected String unknownStateListener$str() {
        return "RESTEASY003995: Unknown state.  You have a Listener messing up what resteasy expects";
    }
    @Override
    public final String unknownStateListener() {
        return String.format(getLoggingLocale(), unknownStateListener$str());
    }
    protected String unsupportedCollectionType$str() {
        return "RESTEASY004000: Unsupported collectionType: %s";
    }
    @Override
    public final String unsupportedCollectionType(final Class<?> clazz) {
        return String.format(getLoggingLocale(), unsupportedCollectionType$str(), clazz);
    }
    protected String unsupportedParameter$str() {
        return "RESTEASY004005: Unsupported parameter: %s";
    }
    @Override
    public final String unsupportedParameter(final String parameter) {
        return String.format(getLoggingLocale(), unsupportedParameter$str(), parameter);
    }
    protected String uriNull$str() {
        return "RESTEASY004010: URI was null";
    }
    @Override
    public final String uriNull() {
        return String.format(getLoggingLocale(), uriNull$str());
    }
    protected String uriParamNull$str() {
        return "RESTEASY004015: uri param was null";
    }
    @Override
    public final String uriParamNull() {
        return String.format(getLoggingLocale(), uriParamNull$str());
    }
    protected String uriTemplateParameterNull$str() {
        return "RESTEASY004020: uriTemplate parameter is null";
    }
    @Override
    public final String uriTemplateParameterNull() {
        return String.format(getLoggingLocale(), uriTemplateParameterNull$str());
    }
    protected String uriValueNull$str() {
        return "RESTEASY004025: URI value is null";
    }
    @Override
    public final String uriValueNull() {
        return String.format(getLoggingLocale(), uriValueNull$str());
    }
    protected String userIsNotRegistered$str() {
        return "RESTEASY004030: User is not registered: %s";
    }
    @Override
    public final String userIsNotRegistered(final String user) {
        return String.format(getLoggingLocale(), userIsNotRegistered$str(), user);
    }
    protected String valueNull$str() {
        return "RESTEASY004035: A value was null";
    }
    @Override
    public final String valueNull() {
        return String.format(getLoggingLocale(), valueNull$str());
    }
    protected String valueParamIsNull$str() {
        return "RESTEASY004040: value param is null";
    }
    @Override
    public final String valueParamIsNull() {
        return String.format(getLoggingLocale(), valueParamIsNull$str());
    }
    protected String valueParamWasNull$str() {
        return "RESTEASY004045: value param was null";
    }
    @Override
    public final String valueParamWasNull() {
        return String.format(getLoggingLocale(), valueParamWasNull$str());
    }
    protected String valuesParamIsNull$str() {
        return "RESTEASY004050: values param is null";
    }
    @Override
    public final String valuesParamIsNull() {
        return String.format(getLoggingLocale(), valuesParamIsNull$str());
    }
    protected String valuesParamWasNull$str() {
        return "RESTEASY004055: values param was null";
    }
    @Override
    public final String valuesParamWasNull() {
        return String.format(getLoggingLocale(), valuesParamWasNull$str());
    }
    protected String valuesParameterNull$str() {
        return "RESTEASY004060: values parameter is null";
    }
    @Override
    public final String valuesParameterNull() {
        return String.format(getLoggingLocale(), valuesParameterNull$str());
    }
    protected String variantListMustNotBeZero$str() {
        return "RESTEASY004065: Variant list must not be zero";
    }
    @Override
    public final String variantListMustNotBeZero() {
        return String.format(getLoggingLocale(), variantListMustNotBeZero$str());
    }
    protected String wrongPassword$str() {
        return "RESTEASY004070: Wrong password for: %s";
    }
    @Override
    public final String wrongPassword(final String user) {
        return String.format(getLoggingLocale(), wrongPassword$str(), user);
    }
    protected String webTargetIsNotSetForEventSource$str() {
        return "RESTEASY004080: WebTarget is not set for creating SseEventSource";
    }
    @Override
    public final String webTargetIsNotSetForEventSource() {
        return String.format(getLoggingLocale(), webTargetIsNotSetForEventSource$str());
    }
    protected String eventSourceIsNotReadyForOpen$str() {
        return "RESTEASY004081: EventSource is not ready to open";
    }
    @Override
    public final String eventSourceIsNotReadyForOpen() {
        return String.format(getLoggingLocale(), eventSourceIsNotReadyForOpen$str());
    }
    protected String notFoundMBW$str() {
        return "RESTEASY004082: No suitable message body writer for class : %s";
    }
    @Override
    public final String notFoundMBW(final String className) {
        return String.format(getLoggingLocale(), notFoundMBW$str(), className);
    }
    protected String asyncServletIsRequired$str() {
        return "RESTEASY004083: Sever sent event feature requries HttpServlet30Dispatcher";
    }
    @Override
    public final String asyncServletIsRequired() {
        return String.format(getLoggingLocale(), asyncServletIsRequired$str());
    }
    protected String readEventException$str() {
        return "RESTEASY004084: Failed to read SseEvent";
    }
    @Override
    public final String readEventException() {
        return String.format(getLoggingLocale(), readEventException$str());
    }
    protected String nullValueSetToCreateOutboundSseEvent$str() {
        return "RESTEASY004085: %s is not set for OutboundSseEvent builder";
    }
    @Override
    public final String nullValueSetToCreateOutboundSseEvent(final String field) {
        return String.format(getLoggingLocale(), nullValueSetToCreateOutboundSseEvent$str(), field);
    }
    protected String failedToWriteDataToInboudEvent$str() {
        return "RESTEASY004086: Failed to write data to InBoundSseEvent";
    }
    @Override
    public final String failedToWriteDataToInboudEvent() {
        return String.format(getLoggingLocale(), failedToWriteDataToInboudEvent$str());
    }
    protected String notFoundMBR$str() {
        return "RESTEASY004087: No suitable message body reader for class : %s";
    }
    @Override
    public final String notFoundMBR(final String className) {
        return String.format(getLoggingLocale(), notFoundMBR$str(), className);
    }
    protected String failedToReadData$str() {
        return "RESTEASY004088: Failed to read data from InboundSseEvent";
    }
    @Override
    public final String failedToReadData() {
        return String.format(getLoggingLocale(), failedToReadData$str());
    }
    protected String failedToCreateSseEventOutput$str() {
        return "RESTEASY004089: Failed to create SseEventOutput";
    }
    @Override
    public final String failedToCreateSseEventOutput() {
        return String.format(getLoggingLocale(), failedToCreateSseEventOutput$str());
    }
    protected String unableToInstantiateAsyncResponseProvider$str() {
        return "RESTEASY004090: Unable to instantiate AsyncResponseProvider";
    }
    @Override
    public final String unableToInstantiateAsyncResponseProvider() {
        return String.format(getLoggingLocale(), unableToInstantiateAsyncResponseProvider$str());
    }
    protected String unableToInstantiateAsyncStreamProvider$str() {
        return "RESTEASY004091: Unable to instantiate AsyncStreamProvider";
    }
    @Override
    public final String unableToInstantiateAsyncStreamProvider() {
        return String.format(getLoggingLocale(), unableToInstantiateAsyncStreamProvider$str());
    }
    protected String sseEventSinkIsClosed$str() {
        return "RESTEASY004092: SseEventSink is closed";
    }
    @Override
    public final String sseEventSinkIsClosed() {
        return String.format(getLoggingLocale(), sseEventSinkIsClosed$str());
    }
    protected String unableToInstantiateAsyncClientResponseProvider$str() {
        return "RESTEASY004095: Unable to instantiate AsyncClientResponseProvider";
    }
    @Override
    public final String unableToInstantiateAsyncClientResponseProvider() {
        return String.format(getLoggingLocale(), unableToInstantiateAsyncClientResponseProvider$str());
    }
    protected String unableToInstantiateAsyncClientStreamProvider$str() {
        return "RESTEASY004096: Unable to instantiate AsyncClientStreamProvider";
    }
    @Override
    public final String unableToInstantiateAsyncClientStreamProvider() {
        return String.format(getLoggingLocale(), unableToInstantiateAsyncClientStreamProvider$str());
    }
    protected String sseBroadcasterIsClosed$str() {
        return "RESTEASY004093: SseBroadcaster is closed";
    }
    @Override
    public final String sseBroadcasterIsClosed() {
        return String.format(getLoggingLocale(), sseBroadcasterIsClosed$str());
    }
    protected String unableToInstantiateContextInjector$str() {
        return "RESTEASY004094: Unable to instantiate ContextInjector";
    }
    @Override
    public final String unableToInstantiateContextInjector() {
        return String.format(getLoggingLocale(), unableToInstantiateContextInjector$str());
    }
    protected String registeringContextResolverAsLambda$str() {
        return "RESTEASY004097: Registering a context resolver doesn't support lambdas";
    }
    @Override
    public final String registeringContextResolverAsLambda() {
        return String.format(getLoggingLocale(), registeringContextResolverAsLambda$str());
    }
    protected String expectedArray$str() {
        return "RESTEASY004098: MultiValuedArrayParamConverter expected array, not: %s";
    }
    @Override
    public final String expectedArray(final String className) {
        return String.format(getLoggingLocale(), expectedArray$str(), className);
    }
    protected String unableToParse$str() {
        return "RESTEASY004099: MultiValuedCollectionParamConverter unable to parse: %s";
    }
    @Override
    public final String unableToParse(final String s) {
        return String.format(getLoggingLocale(), unableToParse$str(), s);
    }
    protected String multipleMethodsMatchFailFast$str() {
        return "RESTEASY005042: Multiple resource methods match request %s. Matching methods: %s";
    }
    @Override
    public final String multipleMethodsMatchFailFast(final String request, final String[] methods) {
        return String.format(getLoggingLocale(), multipleMethodsMatchFailFast$str(), request, Arrays.toString(methods));
    }
    protected String errorCreatingArray$str() {
        return "RESTEASY003013: Error creating array from %s";
    }
    @Override
    public final String errorCreatingArray(final String s) {
        return String.format(getLoggingLocale(), errorCreatingArray$str(), s);
    }
    protected String cannotConvertParameter$str() {
        return "RESTEASY005043: Value %s cannot be converted to type %s with property name %s";
    }
    @Override
    public final IllegalArgumentException cannotConvertParameter(final Object value, final Class<?> type, final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotConvertParameter$str(), value, type, name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String propertyNotFound$str() {
        return "RESTEASY005044: Property %s not found";
    }
    @Override
    public final NoSuchElementException propertyNotFound(final String name) {
        final NoSuchElementException result = new NoSuchElementException(String.format(getLoggingLocale(), propertyNotFound$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String executorShutdown$str() {
        return "RESTEASY005050: The executor has been shutdown and is no longer available.";
    }
    @Override
    public final IllegalStateException executorShutdown() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), executorShutdown$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requiredContextParameterNotFound$str() {
        return "RESTEASY005051: Required context value not found.";
    }
    @Override
    public final IllegalArgumentException requiredContextParameterNotFound() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), requiredContextParameterNotFound$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToLoadService$str() {
        return "RESTEASY005060: Failed to load services for type %s";
    }
    @Override
    public final UncheckedIOException failedToLoadService(final IOException e, final Class<?> type) {
        final UncheckedIOException result = new UncheckedIOException(String.format(getLoggingLocale(), failedToLoadService$str(), type), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToConstructClass$str() {
        return "RESTEASY005061: Failed to construct type %s";
    }
    @Override
    public final RuntimeException failedToConstructClass(final Throwable cause, final Class<?> type) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToConstructClass$str(), type), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidProtocol$str() {
        return "RESTEASY005070: Invalid protocol %s. Only protocols %s are allowed.";
    }
    @Override
    public final IllegalArgumentException invalidProtocol(final String protocol, final String... values) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidProtocol$str(), protocol, Arrays.toString(values)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidArgumentType$str() {
        return "RESTEASY005071: Invalid argument %s for property %s. Require type is %s.";
    }
    @Override
    public final IllegalArgumentException invalidArgumentType(final String propertyName, final Object value, final Class<?> expected) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidArgumentType$str(), propertyName, value, expected));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullParameter$str() {
        return "RESTEASY005072: Parameter %s is a required parameter and cannot be set to null.";
    }
    @Override
    public final String nullParameter(final String name) {
        return String.format(getLoggingLocale(), nullParameter$str(), name);
    }
    protected String failedToScanResources$str() {
        return "RESTEASY005073: Failed to scan for resources.";
    }
    @Override
    public final UncheckedIOException failedToScanResources(final IOException cause) {
        final UncheckedIOException result = new UncheckedIOException(String.format(getLoggingLocale(), failedToScanResources$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noImplementationFound$str() {
        return "RESTEASY005074: No implementation of %s was found.";
    }
    @Override
    public final CompletionException noImplementationFound(final String name) {
        final CompletionException result = new CompletionException(String.format(getLoggingLocale(), noImplementationFound$str(), name), null);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotLoadSslContext$str() {
        return "RESTEASY005075: Could no load default SSL context";
    }
    @Override
    public final IllegalStateException couldNotLoadSslContext(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotLoadSslContext$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String deploymentRequired$str() {
        return "RESTEASY005076: A ResteasyDeployment object required";
    }
    @Override
    public final IllegalArgumentException deploymentRequired() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), deploymentRequired$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String alreadyExported$str() {
        return "RESTEASY005080: The stream has already been exported.";
    }
    @Override
    public final Supplier<IllegalStateException> alreadyExported() {
        return () -> {
            final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), alreadyExported$str()));
            _copyStackTraceMinusOne(result);
            return result;
        };
    }
    protected String fileLimitReached$str() {
        return "RESTEASY005081: File limit of %s has been reached. The entity cannot be processed. Increase the size with the configuration property %s.";
    }
    @Override
    public final IllegalStateException fileLimitReached(final Threshold limit, final String propertyName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), fileLimitReached$str(), limit, propertyName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotDetermineGenericType$str() {
        return "RESTEASY005082: The generic type for %s could not be determined based on %s.";
    }
    @Override
    public final IllegalArgumentException couldNotDetermineGenericType(final String typeName, final String implName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), couldNotDetermineGenericType$str(), typeName, implName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToResolveSSLContext$str() {
        return "RESTEASY005085: Failed to resolve the SSLContext for the client.";
    }
    @Override
    public final RuntimeException failedToResolveSSLContext(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToResolveSSLContext$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
