/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.core.FormInjector;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.PrefixedFormFieldsHttpRequest;

public class PrefixedFormInjector
extends FormInjector {
    private final String prefix;

    public PrefixedFormInjector(Class type, String prefix, ResteasyProviderFactory factory) {
        super(type, factory);
        this.prefix = prefix;
    }

    @Override
    public CompletionStage<Object> inject(HttpRequest request, HttpResponse response, boolean unwrapAsync) {
        if (!this.containsPrefixedFormFieldsWithValue((MultivaluedMap<String, String>)request.getDecodedFormParameters())) {
            return CompletableFuture.completedFuture(null);
        }
        return this.doInject(this.prefix, request, response, unwrapAsync);
    }

    protected CompletionStage<Object> doInject(String prefix, HttpRequest request, HttpResponse response, boolean unwrapAsync) {
        return super.inject(new PrefixedFormFieldsHttpRequest(prefix, request), response, unwrapAsync);
    }

    private boolean containsPrefixedFormFieldsWithValue(MultivaluedMap<String, String> decodedFormParameters) {
        for (String parameterName : decodedFormParameters.keySet()) {
            if (!parameterName.startsWith(this.prefix) || !this.hasValue((List)decodedFormParameters.get((Object)parameterName))) continue;
            return true;
        }
        return false;
    }

    protected boolean hasValue(List<String> list) {
        return !list.isEmpty() && list.get(0).length() > 0;
    }
}

