/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.providerfactory;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Set;
import javax.annotation.Priority;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.LinkBuilderImpl;
import org.jboss.resteasy.specimpl.ResponseBuilderImpl;
import org.jboss.resteasy.specimpl.ResteasyUriBuilderImpl;
import org.jboss.resteasy.specimpl.VariantListBuilderImpl;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.util.PickConstructor;

public final class Utils {
    private Utils() {
    }

    static boolean isA(Class target, Class type, Map<Class<?>, Integer> contracts) {
        if (!type.isAssignableFrom(target)) {
            return false;
        }
        if (contracts == null || contracts.size() == 0) {
            return true;
        }
        for (Class<?> contract : contracts.keySet()) {
            if (!contract.equals(type)) continue;
            return true;
        }
        return false;
    }

    static boolean isA(Object target, Class type, Map<Class<?>, Integer> contracts) {
        return Utils.isA(target.getClass(), type, contracts);
    }

    static int getPriority(Integer override, Map<Class<?>, Integer> contracts, Class type, Class<?> component) {
        Integer p;
        if (override != null) {
            return override;
        }
        if (contracts != null && (p = contracts.get(type)) != null) {
            return p;
        }
        Priority priority = (component = component.isSynthetic() ? component.getSuperclass() : component).getAnnotation(Priority.class);
        if (priority == null) {
            return 5000;
        }
        return priority.value();
    }

    static void injectProperties(ResteasyProviderFactory rpf, Class declaring, Object obj) {
        rpf.getInjectorFactory().createPropertyInjector(declaring, rpf).inject(obj, false).toCompletableFuture().getNow(null);
    }

    static void injectProperties(ResteasyProviderFactory rpf, Object obj) {
        rpf.getInjectorFactory().createPropertyInjector(obj.getClass(), rpf).inject(obj, false).toCompletableFuture().getNow(null);
    }

    static void injectProperties(ResteasyProviderFactory rpf, Object obj, HttpRequest request, HttpResponse response) {
        rpf.getInjectorFactory().createPropertyInjector(obj.getClass(), rpf).inject(request, response, obj, false).toCompletableFuture().getNow(null);
    }

    static <T> T createProviderInstance(ResteasyProviderFactory rpf, Class<? extends T> clazz) {
        ConstructorInjector constructorInjector = Utils.createConstructorInjector(rpf, clazz);
        T provider = constructorInjector.construct(false).toCompletableFuture().getNow(null);
        return provider;
    }

    private static <T> ConstructorInjector createConstructorInjector(ResteasyProviderFactory rpf, Class<? extends T> clazz) {
        Constructor constructor = PickConstructor.pickSingletonConstructor(clazz);
        if (constructor == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.unableToFindPublicConstructorForProvider(clazz.getName()));
        }
        return rpf.getInjectorFactory().createConstructor(constructor, rpf);
    }

    static UriBuilder createUriBuilder() {
        return new ResteasyUriBuilderImpl();
    }

    static Response.ResponseBuilder createResponseBuilder() {
        return new ResponseBuilderImpl();
    }

    static Variant.VariantListBuilder createVariantListBuilder() {
        return new VariantListBuilderImpl();
    }

    static Link.Builder createLinkBuilder() {
        return new LinkBuilderImpl();
    }

    static <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegate(Map<Class<?>, RuntimeDelegate.HeaderDelegate> headerDelegates, Set<Class<?>> nullDelegates, Class<T> tClass) {
        if (nullDelegates.contains(tClass)) {
            return null;
        }
        for (Class<T> clazz = tClass; clazz != null; clazz = clazz.getSuperclass()) {
            RuntimeDelegate.HeaderDelegate<T> delegate = headerDelegates.get(clazz);
            if (delegate != null) {
                return delegate;
            }
            delegate = Utils.createHeaderDelegateFromInterfaces(headerDelegates, clazz.getInterfaces());
            if (delegate == null) continue;
            return delegate;
        }
        RuntimeDelegate.HeaderDelegate<T> result = Utils.createHeaderDelegateFromInterfaces(headerDelegates, tClass.getInterfaces());
        if (result == null) {
            nullDelegates.add(tClass);
        }
        return result;
    }

    private static <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegateFromInterfaces(Map<Class<?>, RuntimeDelegate.HeaderDelegate> headerDelegates, Class<?>[] interfaces) {
        RuntimeDelegate.HeaderDelegate<T> delegate = null;
        for (int i = 0; i < interfaces.length; ++i) {
            delegate = headerDelegates.get(interfaces[i]);
            if (delegate != null) {
                return delegate;
            }
            delegate = Utils.createHeaderDelegateFromInterfaces(headerDelegates, interfaces[i].getInterfaces());
            if (delegate == null) continue;
            return delegate;
        }
        return null;
    }
}

