/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import org.jboss.resteasy.microprofile.config.ResteasyConfigProvider;

public class PortProvider {
    private static final int DEFAULT_PORT = 8081;
    private static final String ENV_VAR_NAME = "RESTEASY_PORT";
    private static final String PROPERTY_NAME = "org.jboss.resteasy.port";
    private static final String DEFAULT_HOST = "localhost";
    private static final String ENV_VAR_HOSTNAME = "RESTEASY_HOST";
    private static final String PROPERTY_HOSTNAME = "org.jboss.resteasy.host";

    public static int getPort() {
        int port = -1;
        String property = ResteasyConfigProvider.getConfig().getOptionalValue(ENV_VAR_NAME, String.class).orElse(null);
        if (property != null) {
            try {
                port = Integer.parseInt(property);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (port == -1 && (property = (String)ResteasyConfigProvider.getConfig().getOptionalValue(PROPERTY_NAME, String.class).orElse(null)) != null) {
            try {
                port = Integer.parseInt(property);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (port == -1) {
            port = 8081;
        }
        return port;
    }

    public static String getHost() {
        String host = null;
        String property = ResteasyConfigProvider.getConfig().getOptionalValue(ENV_VAR_HOSTNAME, String.class).orElse(null);
        if (property != null) {
            host = property;
        }
        if (host == null && (property = (String)ResteasyConfigProvider.getConfig().getOptionalValue(PROPERTY_HOSTNAME, String.class).orElse(null)) != null) {
            host = property;
        }
        if (host == null) {
            host = DEFAULT_HOST;
        }
        return host;
    }
}

