/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;
import java.util.Objects;
import java.util.Optional;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.config.Configuration;
import org.jboss.resteasy.spi.config.ConfigurationFactory;

public class ApplicationDescription {
    private final Class<? extends Application> type;
    private final Application instance;
    private final String path;

    private ApplicationDescription(Class<? extends Application> type, Application instance, String path) {
        this.type = type;
        this.instance = instance;
        this.path = path;
    }

    public Class<? extends Application> type() {
        return this.type;
    }

    public Application instance() {
        return this.instance;
    }

    public String path() {
        return this.path;
    }

    public static class Builder {
        private final Application application;
        private Class<? extends Application> type;
        private String path;

        private Builder(Application application) {
            this.application = application;
        }

        public static Builder of(Application application) {
            return new Builder(Objects.requireNonNull(application, () -> Messages.MESSAGES.nullParameter("application")));
        }

        public Builder type(Class<? extends Application> type) {
            this.type = type;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public ApplicationDescription build() {
            if (this.type == null) {
                this.type = this.application.getClass();
            }
            if (this.path == null) {
                ApplicationPath applicationPath = this.type.getAnnotation(ApplicationPath.class);
                if (applicationPath != null) {
                    this.path = applicationPath.value();
                    if (this.path.isBlank()) {
                        this.path = "/";
                    }
                } else {
                    Configuration configuration = ConfigurationFactory.getInstance().getConfiguration();
                    Optional mapping = configuration.getOptionalValue("resteasy.servlet.mapping.prefix", String.class);
                    this.path = mapping.filter(v -> !v.isBlank()).orElse("/");
                }
            }
            return new ApplicationDescription(this.type, this.application, this.path);
        }
    }
}

