/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.smime;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.ext.Providers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.jboss.resteasy.security.doseta.i18n.Messages;
import org.jboss.resteasy.security.smime.EnvelopedInputImpl;
import org.jboss.resteasy.security.smime.SignedInput;

public class MultipartSignedInputImpl
implements SignedInput {
    private PublicKey publicKey;
    private X509Certificate certificate;
    private Class type;
    private Type genericType;
    private MimeMultipart body;
    private Annotation[] annotations;
    private Providers providers;
    private Object entity;

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public void setType(GenericType type) {
        this.type = type.getRawType();
        this.genericType = type.getType();
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public void setGenericType(Type genericType) {
        this.genericType = genericType;
    }

    public MimeMultipart getBody() {
        return this.body;
    }

    public void setBody(MimeMultipart body) {
        this.body = body;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    public Providers getProviders() {
        return this.providers;
    }

    public void setProviders(Providers providers) {
        this.providers = providers;
    }

    public Object getEntity() {
        return this.getEntity(this.type, this.genericType, this.annotations);
    }

    public Object getEntity(Class type) {
        return this.getEntity(type, null, this.annotations);
    }

    @Override
    public Object getEntity(GenericType gt) {
        return this.getEntity(gt.getRawType(), gt.getType(), this.annotations);
    }

    public Object getEntity(GenericType gt, Annotation[] ann) {
        return this.getEntity(gt.getRawType(), gt.getType(), ann);
    }

    public Object getEntity(Class t, Type gt, Annotation[] ann) {
        if (this.entity != null) {
            return this.entity;
        }
        MimeBodyPart mbp = null;
        try {
            mbp = (MimeBodyPart)this.body.getBodyPart(0);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        this.entity = EnvelopedInputImpl.extractEntity(t, gt, ann, mbp, this.providers);
        return this.entity;
    }

    @Override
    public boolean verify() throws Exception {
        if (this.certificate != null) {
            return this.verify(this.certificate);
        }
        if (this.publicKey != null) {
            return this.verify(this.publicKey);
        }
        throw new NullPointerException(Messages.MESSAGES.certificateNorPublicKeySet());
    }

    @Override
    public boolean verify(X509Certificate certificate) throws Exception {
        return this.verify(certificate.getPublicKey());
    }

    @Override
    public boolean verify(PublicKey publicKey) throws Exception {
        SMIMESigned signed = new SMIMESigned(this.body);
        SignerInformationStore signers = signed.getSignerInfos();
        SignerInformation signer = (SignerInformation)signers.getSigners().iterator().next();
        return signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(publicKey));
    }
}

