/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.annotations.interception.Precedence;

public class LegacyPrecedence {
    private static final int DEFAULTS_ORDER = 100000;
    protected Map<String, Integer> precedenceOrder = new HashMap<String, Integer>();
    protected List<String> precedenceList = new ArrayList<String>();

    public LegacyPrecedence clone() {
        LegacyPrecedence precedence = new LegacyPrecedence();
        precedence.precedenceList.addAll(this.precedenceList);
        precedence.precedenceOrder.putAll(this.precedenceOrder);
        return precedence;
    }

    public int calculateOrder(Class<?> clazz) {
        Precedence precedence = clazz.getAnnotation(Precedence.class);
        if (precedence != null) {
            String value = precedence.value();
            Integer o = this.precedenceOrder.get(value);
            if (o == null) {
                throw new RuntimeException("Unknown interceptor precedence: " + value);
            }
            return o;
        }
        for (Annotation annotation : clazz.getAnnotations()) {
            precedence = annotation.annotationType().getAnnotation(Precedence.class);
            if (precedence == null) continue;
            String value = precedence.value();
            Integer o = this.precedenceOrder.get(value);
            if (o == null) {
                throw new RuntimeException("Unknown interceptor precedence: " + value);
            }
            return o;
        }
        return 5000;
    }

    public void addPrecedence(String precedent, int order) {
        this.precedenceList.add(precedent);
        this.precedenceOrder.put(precedent, order);
    }

    public void appendPrecedence(String precedence) {
        this.precedenceList.add(precedence);
        int greatest = 0;
        for (Integer i : this.precedenceOrder.values()) {
            if (i <= greatest || i == 100000) continue;
            greatest = i;
        }
        this.addPrecedence(precedence, greatest + 100);
    }

    public void insertPrecedenceAfter(String after, String newPrecedence) {
        int order = this.precedenceOrder.get(after);
        this.addPrecedence(newPrecedence, ++order);
    }

    public void insertPrecedenceBefore(String after, String newPrecedence) {
        int order = this.precedenceOrder.get(after);
        this.addPrecedence(newPrecedence, --order);
    }

    public LegacyPrecedence() {
        this.precedenceOrder.put("DEFAULT", 100000);
    }
}

