/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.ExceptionHandler;
import org.jboss.resteasy.core.MessageBodyParameterInjector;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.core.ServerResponseWriter;
import org.jboss.resteasy.core.interception.PreMatchContainerRequestContext;
import org.jboss.resteasy.plugins.server.servlet.Cleanable;
import org.jboss.resteasy.plugins.server.servlet.Cleanables;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.specimpl.RequestImpl;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpRequestPreprocessor;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InternalDispatcher;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.UnhandledException;

public class SynchronousDispatcher
implements Dispatcher {
    protected ResteasyProviderFactory providerFactory;
    protected Registry registry;
    protected List<HttpRequestPreprocessor> requestPreprocessors = new ArrayList<HttpRequestPreprocessor>();
    protected Map<Class, Object> defaultContextObjects = new HashMap<Class, Object>();
    protected Set<String> unwrappedExceptions = new HashSet<String>();
    protected boolean bufferExceptionEntityRead = false;
    protected boolean bufferExceptionEntity = true;

    public SynchronousDispatcher(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
        this.registry = new ResourceMethodRegistry(providerFactory);
        this.defaultContextObjects.put(Providers.class, providerFactory);
        this.defaultContextObjects.put(Registry.class, this.registry);
        this.defaultContextObjects.put(Dispatcher.class, this);
        this.defaultContextObjects.put(InternalDispatcher.class, InternalDispatcher.getInstance());
    }

    public SynchronousDispatcher(ResteasyProviderFactory providerFactory, ResourceMethodRegistry registry) {
        this(providerFactory);
        this.registry = registry;
        this.defaultContextObjects.put(Registry.class, registry);
    }

    @Override
    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public Map<Class, Object> getDefaultContextObjects() {
        return this.defaultContextObjects;
    }

    public Set<String> getUnwrappedExceptions() {
        return this.unwrappedExceptions;
    }

    public Response preprocess(HttpRequest request) {
        Response aborted = null;
        try {
            for (HttpRequestPreprocessor preprocessor : this.requestPreprocessors) {
                preprocessor.preProcess(request);
            }
            ContainerRequestFilter[] requestFilters = (ContainerRequestFilter[])this.providerFactory.getContainerRequestFilterRegistry().preMatch();
            PreMatchContainerRequestContext requestContext = new PreMatchContainerRequestContext(request);
            for (ContainerRequestFilter filter : requestFilters) {
                filter.filter((ContainerRequestContext)requestContext);
                aborted = requestContext.getResponseAbortedWith();
                if (aborted == null) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            aborted = new ExceptionHandler(this.providerFactory, this.unwrappedExceptions).handleException(request, e);
        }
        return aborted;
    }

    protected boolean preprocess(HttpRequest request, HttpResponse response) {
        Response aborted = null;
        try {
            for (HttpRequestPreprocessor preprocessor : this.requestPreprocessors) {
                preprocessor.preProcess(request);
            }
            ContainerRequestFilter[] requestFilters = (ContainerRequestFilter[])this.providerFactory.getContainerRequestFilterRegistry().preMatch();
            PreMatchContainerRequestContext requestContext = new PreMatchContainerRequestContext(request);
            for (ContainerRequestFilter filter : requestFilters) {
                filter.filter((ContainerRequestContext)requestContext);
                aborted = requestContext.getResponseAbortedWith();
                if (aborted == null) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.writeException(request, response, e);
            return false;
        }
        if (aborted != null) {
            this.writeResponse(request, response, aborted);
            return false;
        }
        return true;
    }

    public void writeException(HttpRequest request, HttpResponse response, Throwable e) {
        if (!this.bufferExceptionEntityRead) {
            String s;
            this.bufferExceptionEntityRead = true;
            ResteasyConfiguration context = ResteasyProviderFactory.getContextData(ResteasyConfiguration.class);
            if (context != null && (s = context.getParameter("resteasy.buffer.exception.entity")) != null) {
                this.bufferExceptionEntity = Boolean.parseBoolean(s);
            }
        }
        if (response.isCommitted()) {
            throw new UnhandledException(Messages.MESSAGES.responseIsCommitted(), e);
        }
        Response handledResponse = new ExceptionHandler(this.providerFactory, this.unwrappedExceptions).handleException(request, e);
        if (handledResponse == null) {
            throw new UnhandledException(e);
        }
        if (!this.bufferExceptionEntity) {
            response.getOutputHeaders().add((Object)"resteasy.buffer.exception.entity", (Object)"false");
        }
        try {
            ServerResponseWriter.writeNomapResponse((BuiltResponse)handledResponse, request, response, this.providerFactory);
        }
        catch (Exception e1) {
            throw new UnhandledException(e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(HttpRequest request, HttpResponse response) {
        try {
            this.pushContextObjects(request, response);
            if (!this.preprocess(request, response)) {
                return;
            }
            ResourceInvoker invoker = null;
            try {
                invoker = this.getInvoker(request);
            }
            catch (Exception exception) {
                this.writeException(request, response, exception);
                this.clearContextData();
                return;
            }
            this.invoke(request, response, invoker);
        }
        finally {
            this.clearContextData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokePropagateNotFound(HttpRequest request, HttpResponse response) throws NotFoundException {
        try {
            this.pushContextObjects(request, response);
            if (!this.preprocess(request, response)) {
                return;
            }
            ResourceInvoker invoker = null;
            try {
                invoker = this.getInvoker(request);
            }
            catch (Exception failure) {
                if (failure instanceof NotFoundException) {
                    throw (NotFoundException)((Object)failure);
                }
                this.writeException(request, response, failure);
                this.clearContextData();
                return;
            }
            this.invoke(request, response, invoker);
        }
        finally {
            this.clearContextData();
        }
    }

    public ResourceInvoker getInvoker(HttpRequest request) throws Failure {
        LogMessages.LOGGER.pathInfo(request.getUri().getPath());
        if (!request.isInitial()) {
            throw new InternalServerErrorException(Messages.MESSAGES.isNotInitialRequest(request.getUri().getPath()));
        }
        ResourceInvoker invoker = this.registry.getResourceInvoker(request);
        if (invoker == null) {
            throw new NotFoundException(Messages.MESSAGES.unableToFindJaxRsResource(request.getUri().getPath()));
        }
        return invoker;
    }

    public void pushContextObjects(final HttpRequest request, final HttpResponse response) {
        Map<Class<?>, Object> contextDataMap = ResteasyProviderFactory.getContextDataMap();
        contextDataMap.put(HttpRequest.class, request);
        contextDataMap.put(HttpResponse.class, response);
        contextDataMap.put(HttpHeaders.class, request.getHttpHeaders());
        contextDataMap.put(UriInfo.class, request.getUri());
        contextDataMap.put(Request.class, new RequestImpl(request, response));
        contextDataMap.put(ResteasyAsynchronousContext.class, request.getAsyncContext());
        ResourceContext resourceContext = new ResourceContext(){

            public <T> T getResource(Class<T> resourceClass) {
                return SynchronousDispatcher.this.providerFactory.injectedInstance(resourceClass, request, response);
            }

            public <T> T initResource(T resource) {
                SynchronousDispatcher.this.providerFactory.injectProperties(resource, request, response);
                return resource;
            }
        };
        contextDataMap.put(ResourceContext.class, resourceContext);
        contextDataMap.putAll(this.defaultContextObjects);
        contextDataMap.put(Cleanables.class, new Cleanables());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response internalInvocation(HttpRequest request, HttpResponse response, Object entity) {
        ResteasyProviderFactory.addContextDataLevel();
        boolean pushedBody = false;
        try {
            MessageBodyParameterInjector.pushBody(entity);
            pushedBody = true;
            ResourceInvoker invoker = this.getInvoker(request);
            if (invoker != null) {
                this.pushContextObjects(request, response);
                Response response2 = this.execute(request, response, invoker);
                return response2;
            }
            Response response3 = null;
            return response3;
        }
        finally {
            ResteasyProviderFactory.removeContextDataLevel();
            if (pushedBody) {
                MessageBodyParameterInjector.popBody();
            }
        }
    }

    public void clearContextData() {
        Cleanables cleanables = ResteasyProviderFactory.getContextData(Cleanables.class);
        if (cleanables != null) {
            Iterator<Cleanable> it = cleanables.getCleanables().iterator();
            while (it.hasNext()) {
                try {
                    it.next().clean();
                }
                catch (Exception exception) {}
            }
        }
        ResteasyProviderFactory.clearContextData();
        MessageBodyParameterInjector.clearBodies();
    }

    public Response execute(HttpRequest request, HttpResponse response, ResourceInvoker invoker) {
        BuiltResponse jaxrsResponse;
        block3: {
            jaxrsResponse = null;
            try {
                jaxrsResponse = invoker.invoke(request, response);
                if (request.getAsyncContext().isSuspended()) {
                    request.getAsyncContext().getAsyncResponse().initialRequestThreadFinished();
                    jaxrsResponse = null;
                }
            }
            catch (Exception e) {
                jaxrsResponse = new ExceptionHandler(this.providerFactory, this.unwrappedExceptions).handleException(request, e);
                if (jaxrsResponse != null) break block3;
                throw new UnhandledException(e);
            }
        }
        return jaxrsResponse;
    }

    public void invoke(HttpRequest request, HttpResponse response, ResourceInvoker invoker) {
        BuiltResponse jaxrsResponse = null;
        try {
            jaxrsResponse = invoker.invoke(request, response);
            if (request.getAsyncContext().isSuspended()) {
                request.getAsyncContext().getAsyncResponse().initialRequestThreadFinished();
                jaxrsResponse = null;
            }
        }
        catch (Exception e) {
            this.writeException(request, response, e);
            return;
        }
        if (jaxrsResponse != null) {
            this.writeResponse(request, response, jaxrsResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asynchronousDelivery(HttpRequest request, HttpResponse response, Response jaxrsResponse) throws IOException {
        if (jaxrsResponse == null) {
            return;
        }
        try {
            this.pushContextObjects(request, response);
            ServerResponseWriter.writeNomapResponse((BuiltResponse)jaxrsResponse, request, response, this.providerFactory);
        }
        finally {
            this.clearContextData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asynchronousExceptionDelivery(HttpRequest request, HttpResponse response, Throwable exception) {
        try {
            this.pushContextObjects(request, response);
            this.writeException(request, response, exception);
        }
        catch (Throwable ex) {
            LogMessages.LOGGER.unhandledAsynchronousException(ex);
            if (!response.isCommitted()) {
                try {
                    response.reset();
                    response.sendError(500);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.clearContextData();
        }
    }

    protected void writeResponse(HttpRequest request, HttpResponse response, Response jaxrsResponse) {
        try {
            ServerResponseWriter.writeNomapResponse((BuiltResponse)jaxrsResponse, request, response, this.providerFactory);
        }
        catch (Exception e) {
            this.writeException(request, response, e);
        }
    }

    @Override
    public void addHttpPreprocessor(HttpRequestPreprocessor httpPreprocessor) {
        this.requestPreprocessors.add(httpPreprocessor);
    }
}

