/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.debug.jsf2;

import com.sun.facelets.StateWriterControl;
import java.io.IOException;
import java.io.Writer;
import javax.faces.application.StateManager;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.navigation.Pages;

public class SeamDebugPhaseListener
implements PhaseListener {
    private static final String STATE_KEY = "~facelets.VIEW_STATE~";

    public void beforePhase(PhaseEvent event) {
        FacesLifecycle.setPhaseId((PhaseId)event.getPhaseId());
        if (Pages.isDebugPage()) {
            // empty if block
        }
    }

    public void afterPhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeState(FacesContext facesContext, Writer writer) throws IOException {
        try {
            if (StateWriterControl.isStateWritten()) {
                String content = StateWriterControl.getAndResetBuffer();
                int end = content.indexOf(STATE_KEY);
                if (end >= 0) {
                    String stateStr;
                    StateManager stateMgr = facesContext.getApplication().getStateManager();
                    Object stateObj = stateMgr.saveView(facesContext);
                    if (stateObj == null) {
                        stateStr = null;
                    } else {
                        stateMgr.writeState(facesContext, stateObj);
                        stateStr = StateWriterControl.getAndResetBuffer();
                    }
                    int start = 0;
                    while (end != -1) {
                        writer.write(content, start, end - start);
                        if (stateStr != null) {
                            writer.write(stateStr);
                        }
                        start = end + STATE_KEY.length();
                        end = content.indexOf(STATE_KEY, start);
                    }
                    writer.write(content, start, content.length() - start);
                } else {
                    writer.write(content);
                }
            }
        }
        finally {
            StateWriterControl.release();
        }
    }
}

