/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf.ui;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.PdfStamper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.jboss.seam.pdf.ui.FormComponent;

public class UIField
extends FormComponent {
    public static final String COMPONENT_FAMILY = "org.jboss.seam.pdf.UIField";
    private static Log log = Logging.getLog(FormComponent.class);
    private String name;
    private Object value;
    private Boolean readOnly = Boolean.TRUE;

    public void encodeBegin(FacesContext facesContext) throws IOException {
        AcroFields fields = (AcroFields)Contexts.getEventContext().get("acrofields");
        String theName = this.getName();
        Object theValue = this.getValue();
        if (theValue == null) {
            return;
        }
        Boolean readOnly = this.getReadOnly();
        try {
            log.debug((Object)"Setting field '#0' to value '#1'", new Object[]{theName, theValue});
            boolean success = false;
            if (theValue instanceof String) {
                success = fields.setField(theName, (String)theValue);
            } else if (theValue instanceof String[]) {
                String[] stringValue = (String[])theValue;
                success = stringValue.length > 0 ? fields.setListSelection(theName, stringValue) : true;
            } else {
                String message = Interpolator.instance().interpolate("Field #0 expected String or String[] but got #0", new Object[]{this.getName(), theValue.getClass().getName()});
                throw new IllegalArgumentException(message);
            }
            if (!success) {
                this.warnNotFound(fields, theName, theValue);
            } else if (readOnly.booleanValue()) {
                PdfStamper stamper = (PdfStamper)Contexts.getEventContext().get("acrostamper");
                stamper.partialFormFlattening(theName);
            }
        }
        catch (DocumentException e) {
            String message = Interpolator.instance().interpolate("Could not set field '#0' to '#1'", new Object[]{theName, theValue});
            throw new FacesException(message, (Throwable)e);
        }
    }

    private void warnNotFound(AcroFields fields, String theName, Object theValue) {
        log.warn((Object)"Could not set field '#0' to '#1'", new Object[]{theName, theValue});
        HashMap fieldMap = fields.getFields();
        if (!fieldMap.containsKey(theName)) {
            log.warn((Object)"Could not find field '#0'. Found fields are", new Object[]{theName});
            Iterator i = fieldMap.keySet().iterator();
            while (i.hasNext()) {
                log.warn(i.next(), new Object[0]);
            }
            return;
        }
        String[] options = fields.getListOptionExport(theName);
        String[] values = fields.getListOptionDisplay(theName);
        log.warn((Object)"Valid values for #0 are", new Object[]{theName});
        for (int i = 0; i < options.length; ++i) {
            log.warn((Object)"'#0' : '#1'", new Object[]{options[i], values[i]});
        }
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getName() {
        return (String)this.valueOf("name", this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.valueOf("value", this.value);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Boolean getReadOnly() {
        return (Boolean)this.valueOf("readOnly", this.readOnly);
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }
}

