/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.seam.ui.component.html;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.jboss.seam.ui.component.UIConversationPropagation;

/**
 * Customize the conversation propagation for a command link or button (or similar JSF control).
 **/
@Generated({"RichFaces CDK", "4.3.1.Final"})
public class HtmlConversationPropagation extends UIConversationPropagation
        {

    public static final String COMPONENT_TYPE="org.jboss.seam.ui.ConversationPropagation";

    public static final String COMPONENT_FAMILY="org.jboss.seam.ui.ConversationPropagation";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public HtmlConversationPropagation() {
        super();
        setRendererType("org.jboss.seam.ui.ConversationPropagationRenderer");
    }




    protected enum Properties {
        pageflow,
        type
        
    }

 
    public String getPageflow() {
        String value = (String) getStateHelper().eval(Properties.pageflow);
        return value;
    }
    
    public void setPageflow(String pageflow) {
        getStateHelper().put(Properties.pageflow, pageflow);
    }

 
    public String getType() {
        String value = (String) getStateHelper().eval(Properties.type, "none");
        return value;
    }
    
    public void setType(String type) {
        getStateHelper().put(Properties.type, type);
    }

    

}