/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.seam.ui.component.html;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.jboss.seam.ui.component.UIEnumItem;
import javax.el.MethodExpression;
import javax.faces.el.MethodBinding;

/**
 * Creates a SelectItem from an enum value.
 **/
@Generated({"RichFaces CDK", "4.3.1.Final"})
public class HtmlEnumItem extends UIEnumItem
        {

    public static final String COMPONENT_TYPE="org.jboss.seam.ui.EnumItem";

    public static final String COMPONENT_FAMILY="org.jboss.seam.ui.EnumItem";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }






    protected enum Properties {
        action,
        actionExpression,
        actionListener,
        enumValue,
        immediate,
        label
        
    }

 
    public MethodBinding getAction() {
        MethodBinding value = (MethodBinding) getStateHelper().get(Properties.action);
        return value;
    }
    
    public void setAction(MethodBinding action) {
        getStateHelper().put(Properties.action, action);
    }

 
    public MethodExpression getActionExpression() {
        MethodExpression value = (MethodExpression) getStateHelper().get(Properties.actionExpression);
        return value;
    }
    
    public void setActionExpression(MethodExpression actionExpression) {
        getStateHelper().put(Properties.actionExpression, actionExpression);
    }

 
    public MethodBinding getActionListener() {
        MethodBinding value = (MethodBinding) getStateHelper().get(Properties.actionListener);
        return value;
    }
    
    public void setActionListener(MethodBinding actionListener) {
        getStateHelper().put(Properties.actionListener, actionListener);
    }

 
    public String getEnumValue() {
        String value = (String) getStateHelper().eval(Properties.enumValue);
        return value;
    }
    
    public void setEnumValue(String enumValue) {
        getStateHelper().put(Properties.enumValue, enumValue);
    }

 
    public boolean isImmediate() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.immediate, Boolean.FALSE);
        return value;
    }
    
    public void setImmediate(boolean immediate) {
        getStateHelper().put(Properties.immediate, immediate);
    }

 
    public String getLabel() {
        String value = (String) getStateHelper().eval(Properties.label);
        return value;
    }
    
    public void setLabel(String label) {
        getStateHelper().put(Properties.label, label);
    }

    

}