/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.seam.ui.component.html;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.jboss.seam.ui.graphicImage.UIGraphicImage;
import javax.faces.convert.Converter;

/**
 * Output an image to the view. You can specify the file as a path, a java.io.File, java.io.InputStream, java.net.URL or byte[]
 **/
@Generated({"RichFaces CDK", "4.3.1.Final"})
public class HtmlGraphicImage extends UIGraphicImage
        {

    public static final String COMPONENT_TYPE="org.jboss.seam.ui.graphicImage.GraphicImage";

    public static final String COMPONENT_FAMILY="org.jboss.seam.ui.graphicImage.GraphicImage";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public HtmlGraphicImage() {
        super();
        setRendererType("org.jboss.seam.ui.graphicImage.GraphicImageRenderer");
    }




    protected enum Properties {
        cache,
        cacheKey,
        converter,
        fileName,
        invalidate,
        localValue,
        style,
        value
        
    }

 
    public boolean isCache() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.cache, false);
        return value;
    }
    
    public void setCache(boolean cache) {
        getStateHelper().put(Properties.cache, cache);
    }

 
    public String getCacheKey() {
        String value = (String) getStateHelper().eval(Properties.cacheKey);
        return value;
    }
    
    public void setCacheKey(String cacheKey) {
        getStateHelper().put(Properties.cacheKey, cacheKey);
    }

 
    public Converter getConverter() {
        Converter value = (Converter) getStateHelper().eval(Properties.converter);
        return value;
    }
    
    public void setConverter(Converter converter) {
        getStateHelper().put(Properties.converter, converter);
    }

 
    public String getFileName() {
        String value = (String) getStateHelper().eval(Properties.fileName);
        return value;
    }
    
    public void setFileName(String fileName) {
        getStateHelper().put(Properties.fileName, fileName);
    }

 
    public boolean isInvalidate() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.invalidate, false);
        return value;
    }
    
    public void setInvalidate(boolean invalidate) {
        getStateHelper().put(Properties.invalidate, invalidate);
    }

 
    public Object getLocalValue() {
        Object value = (Object) getStateHelper().get(Properties.value);
        return value;
    }
    

 
    public String getStyle() {
        String value = (String) getStateHelper().eval(Properties.style);
        return value;
    }
    
    public void setStyle(String style) {
        getStateHelper().put(Properties.style, style);
        handleAttribute("style",style);
    }

 
    public Object getValue() {
        Object value = (Object) getStateHelper().eval(Properties.value);
        return value;
    }
    
    public void setValue(Object value) {
        getStateHelper().put(Properties.value, value);
    }
    private static final String ATTRIBUTES_THAT_ARE_SET_KEY = "javax.faces.component.UIComponentBase.attributesThatAreSet";
    
    private void handleAttribute(String name, Object value) {
        List<String> setAttributes = (List<String>) this.getAttributes().get(ATTRIBUTES_THAT_ARE_SET_KEY);
        if (setAttributes == null) {
                setAttributes = new ArrayList<String>(1);
                this.getAttributes().put(ATTRIBUTES_THAT_ARE_SET_KEY, setAttributes);
        }
        if (value == null) {
                ValueExpression ve = getValueExpression(name);
                if (ve == null) {
                    setAttributes.remove(name);
                }
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
        }
    }    

    

}