/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.seam.ui.component.html;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.jboss.seam.ui.component.UIResource;

/**
 * Given a data in form of an inputstream, java.util.File or byte[] and a content-type, this tag sends the data to the browser
 **/
@Generated({"RichFaces CDK", "4.3.1.Final"})
public class HtmlResource extends UIResource
        {

    public static final String COMPONENT_TYPE="org.jboss.seam.ui.Resource";

    public static final String COMPONENT_FAMILY="org.jboss.seam.ui.Resource";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public HtmlResource() {
        super();
        setRendererType("org.jboss.seam.ui.ResourceRenderer");
    }




    protected enum Properties {
        contentType,
        data,
        disposition,
        fileName
        
    }

 
    public String getContentType() {
        String value = (String) getStateHelper().eval(Properties.contentType);
        return value;
    }
    
    public void setContentType(String contentType) {
        getStateHelper().put(Properties.contentType, contentType);
    }

 
    public Object getData() {
        Object value = (Object) getStateHelper().eval(Properties.data);
        return value;
    }
    
    public void setData(Object data) {
        getStateHelper().put(Properties.data, data);
    }

 
    public String getDisposition() {
        String value = (String) getStateHelper().eval(Properties.disposition);
        return value;
    }
    
    public void setDisposition(String disposition) {
        getStateHelper().put(Properties.disposition, disposition);
    }

 
    public String getFileName() {
        String value = (String) getStateHelper().eval(Properties.fileName);
        return value;
    }
    
    public void setFileName(String fileName) {
        getStateHelper().put(Properties.fileName, fileName);
    }

    

}