/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.jboss.seam.deployment.DeploymentHandler;
import org.jboss.seam.deployment.Scanner;
import org.jboss.seam.deployment.SeamDeploymentProperties;
import org.jboss.seam.deployment.URLScanner;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

public abstract class DeploymentStrategy {
    private static final LogProvider log = Logging.getLogProvider(DeploymentStrategy.class);
    private Scanner scanner;
    private List<File> files = new ArrayList<File>();
    private Map<String, DeploymentHandler> deploymentHandlers;
    public static final String SCANNERS_KEY = "org.jboss.seam.deployment.scanners";

    public abstract void scan();

    protected Scanner getScanner() {
        if (this.scanner == null) {
            this.initScanner();
        }
        return this.scanner;
    }

    public abstract ClassLoader getClassLoader();

    public abstract ServletContext getServletContext();

    public Map<String, DeploymentHandler> getDeploymentHandlers() {
        if (this.deploymentHandlers == null) {
            this.initDeploymentHandlers();
        }
        return this.deploymentHandlers;
    }

    private void initDeploymentHandlers() {
        this.deploymentHandlers = new HashMap<String, DeploymentHandler>();
        List<String> deploymentHandlersClassNames = new SeamDeploymentProperties(this.getClassLoader()).getPropertyValues(this.getDeploymentHandlersKey());
        this.addHandlers(deploymentHandlersClassNames);
    }

    protected abstract String getDeploymentHandlersKey();

    protected void initScanner() {
        List<String> scanners = new SeamDeploymentProperties(this.getClassLoader()).getPropertyValues(SCANNERS_KEY);
        for (String className : scanners) {
            Scanner scanner = this.instantiateScanner(className);
            if (scanner == null) continue;
            log.trace("Using " + scanner.toString());
            this.scanner = scanner;
            return;
        }
        log.trace("Using default URLScanner");
        this.scanner = new URLScanner(this);
    }

    private Scanner instantiateScanner(String className) {
        try {
            Class<?> scannerClass = this.getClassLoader().loadClass(className);
            Constructor<?> constructor = scannerClass.getConstructor(DeploymentStrategy.class);
            return (Scanner)constructor.newInstance(this);
        }
        catch (ClassNotFoundException e) {
            log.trace("Unable to use " + className + " as scanner (class not found)", e);
        }
        catch (LinkageError e) {
            log.trace("Unable to use " + className + " as scanner (dependency not found)", e);
        }
        catch (ClassCastException e) {
            log.trace("Unable to use " + className + " as scanner (class does not implement org.jboss.seam.deployment.Scanner)");
        }
        catch (InstantiationException e) {
            log.trace("Unable to instantiate scanner " + className, e);
        }
        catch (IllegalAccessException e) {
            log.trace("Unable to instantiate scanner " + className, e);
        }
        catch (SecurityException e) {
            log.trace(className + " must declare public " + className + "( ClassLoader classLoader, String ... resourceNames )", e);
        }
        catch (NoSuchMethodException e) {
            log.trace(className + " must declare public " + className + "( ClassLoader classLoader, String ... resourceNames )", e);
        }
        catch (IllegalArgumentException e) {
            log.trace(className + " must declare public " + className + "( ClassLoader classLoader, String ... resourceNames )", e);
        }
        catch (InvocationTargetException e) {
            log.trace(className + " must declare public " + className + "( ClassLoader classLoader, String ... resourceNames )", e);
        }
        return null;
    }

    private void addHandlers(List<String> handlers) {
        for (String handler : handlers) {
            this.addHandler(handler);
        }
    }

    private void addHandler(String className) {
        DeploymentHandler deploymentHandler = this.instantiateDeploymentHandler(className);
        if (deploymentHandler != null) {
            log.trace("Adding " + deploymentHandler + " as a deployment handler");
            this.deploymentHandlers.put(deploymentHandler.getName(), deploymentHandler);
        }
    }

    private DeploymentHandler instantiateDeploymentHandler(String className) {
        try {
            Class<?> clazz = this.getClassLoader().loadClass(className);
            return (DeploymentHandler)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.trace("Unable to use " + className + " as a deployment handler (class not found)", e);
        }
        catch (LinkageError e) {
            log.trace("Unable to use " + className + " as a deployment handler (dependency not found)", e);
        }
        catch (InstantiationException e) {
            log.trace("Unable to instantiate deployment handler " + className, e);
        }
        catch (IllegalAccessException e) {
            log.trace("Unable to instantiate deployment handler " + className, e);
        }
        return null;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public long getTimestamp() {
        return this.getScanner().getTimestamp();
    }

    protected void postScan() {
        for (Map.Entry<String, DeploymentHandler> entry : this.getDeploymentHandlers().entrySet()) {
            entry.getValue().postProcess(this.getClassLoader());
        }
    }
}

