/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jcr.ocm;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.jboss.seam.jcr.annotations.JcrConfiguration;
import org.jboss.seam.jcr.annotations.ocm.JcrDao;
import org.jboss.seam.jcr.annotations.ocm.JcrFind;
import org.jboss.seam.jcr.annotations.ocm.JcrParam;
import org.jboss.seam.jcr.annotations.ocm.JcrQuery;
import org.jboss.seam.jcr.annotations.ocm.JcrSave;
import org.jboss.seam.jcr.ocm.ConvertToNode;
import org.jboss.seam.jcr.ocm.ConvertToObject;
import org.jboss.seam.jcr.repository.RepositoryResolver;
import org.jboss.solder.logging.Logger;

public class OCMHandler {
    @Inject
    public Event<ConvertToObject> ctoEvent;
    @Inject
    public Event<ConvertToNode> ctnEvent;
    @Inject
    public RepositoryResolver resolver;
    @Inject
    @Named(value="jcrRepositoryConfigMap")
    public Instance<Map<String, String>> configParameters;
    private Logger logger = Logger.getLogger(OCMHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object handle(InvocationContext ctx) {
        Session session = null;
        try {
            Class<?> declaringClass = ctx.getMethod().getDeclaringClass();
            Method method = ctx.getMethod();
            Object[] params = ctx.getParameters();
            JcrConfiguration sessionConfig = declaringClass.getAnnotation(JcrDao.class).value();
            Map defaults = null;
            if (!this.configParameters.isUnsatisfied()) {
                defaults = (Map)this.configParameters.get();
            }
            session = this.resolver.createSessionFromParameters(sessionConfig, null, defaults);
            Class<?> returnType = method.getReturnType();
            if (method.isAnnotationPresent(JcrFind.class)) {
                String uuid = params[0].toString();
                Node foundNode = session.getNodeByIdentifier(uuid);
                Object result = returnType.newInstance();
                ConvertToObject event = new ConvertToObject(foundNode, result);
                this.ctoEvent.fire((Object)event);
                this.logger.debug((Object)("Returning the result " + event));
                Object obj = result;
                return obj;
            }
            if (method.isAnnotationPresent(JcrQuery.class)) {
                JcrQuery jcrQuery = method.getAnnotation(JcrQuery.class);
                String query = jcrQuery.query();
                String language = jcrQuery.language();
                Class<?> target = jcrQuery.resultClass();
                ArrayList results = new ArrayList();
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                Query resultQuery = queryManager.createQuery(query, language);
                Annotation[][] annotations = method.getParameterAnnotations();
                for (int i = 0; i < params.length; ++i) {
                    Value value = (Value)params[i];
                    JcrParam param = (JcrParam)annotations[i][0];
                    resultQuery.bindValue(param.value(), value);
                }
                QueryResult result = resultQuery.execute();
                NodeIterator nodeIter = result.getNodes();
                while (nodeIter.hasNext()) {
                    Node node = nodeIter.nextNode();
                    Object nodeobj = target.newInstance();
                    ConvertToObject event = new ConvertToObject(node, nodeobj);
                    this.ctoEvent.fire((Object)event);
                    results.add(nodeobj);
                }
                ArrayList arrayList = results;
                return arrayList;
            }
            if (method.isAnnotationPresent(JcrSave.class)) {
                String path = params[0].toString();
                Object entityToSave = params[1];
                if (session.nodeExists(path)) {
                    Node targetNode = session.getNode(path);
                    ConvertToNode ctn = new ConvertToNode(entityToSave, targetNode);
                    this.ctnEvent.fire((Object)ctn);
                    String results = targetNode.getIdentifier();
                    return results;
                }
                Node parent = session.getRootNode();
                String[] pathLocation = path.replaceFirst("/", "").split("/");
                for (int i = 0; i < pathLocation.length; ++i) {
                    if (parent.hasNode(pathLocation[i])) {
                        parent = parent.getNode(pathLocation[i]);
                        continue;
                    }
                    if (i == pathLocation.length) continue;
                    parent = parent.addNode(pathLocation[i]);
                }
                ConvertToNode ctn = new ConvertToNode(entityToSave, parent);
                this.ctnEvent.fire((Object)ctn);
                String string = parent.getIdentifier();
                return string;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to handle conversion request", (Throwable)e);
        }
        finally {
            if (session != null) {
                try {
                    session.save();
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                }
                session.logout();
            }
        }
        this.logger.debug((Object)"Returning null from OCMHandler.");
        return null;
    }
}

