/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction.scope;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.PassivationCapable;

public class ContextualIdentifierStore {
    private final Map<Contextual<?>, String> identifiers = new ConcurrentHashMap();
    private final Map<String, Contextual<?>> contextualForIdentifier = new ConcurrentHashMap();
    private int count = 0;
    private final String PREFIX = "CID-";

    public Contextual<?> getContextual(String id) {
        return this.contextualForIdentifier.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId(Contextual<?> contextual) {
        if (this.identifiers.containsKey(contextual)) {
            return this.identifiers.get(contextual);
        }
        if (contextual instanceof PassivationCapable) {
            PassivationCapable p = (PassivationCapable)contextual;
            String id = p.getId();
            this.contextualForIdentifier.put(id, contextual);
            return id;
        }
        ContextualIdentifierStore contextualIdentifierStore = this;
        synchronized (contextualIdentifierStore) {
            if (this.identifiers.containsKey(contextual)) {
                return this.identifiers.get(contextual);
            }
            String id = "CID-" + this.getClass().getName() + "-" + this.count++;
            this.identifiers.put(contextual, id);
            this.contextualForIdentifier.put(id, contextual);
            return id;
        }
    }
}

