/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.saml;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.ServletRequest;
import org.jboss.seam.security.external.saml.SamlMessage;
import org.jboss.seam.security.external.saml.SamlRequestOrResponse;

public class SamlRedirectMessage
extends SamlMessage {
    public static final String QSP_SIGNATURE = "Signature";
    public static final String QSP_SIG_ALG = "SigAlg";
    private String signature;
    private String signatureAlgorithm;
    private boolean urlEncoded;

    public SamlRedirectMessage() {
    }

    public SamlRedirectMessage(SamlRequestOrResponse samlRequestOrResponse, ServletRequest request) {
        this.samlRequestOrResponse = samlRequestOrResponse;
        this.samlMessage = samlRequestOrResponse.isRequest() ? request.getParameter("SAMLRequest") : request.getParameter("SAMLResponse");
        this.relayState = request.getParameter("RelayState");
        this.signatureAlgorithm = request.getParameter(QSP_SIG_ALG);
        this.signature = request.getParameter(QSP_SIGNATURE);
        this.urlEncoded = true;
    }

    public String createQueryString() {
        if (!this.urlEncoded) {
            this.encode();
        }
        StringBuilder queryString = new StringBuilder();
        if (this.samlRequestOrResponse.isRequest()) {
            this.addParamToQueryString(queryString, "SAMLRequest", this.samlMessage);
        } else {
            this.addParamToQueryString(queryString, "SAMLResponse", this.samlMessage);
        }
        this.addParamToQueryString(queryString, "RelayState", this.relayState);
        this.addParamToQueryString(queryString, QSP_SIG_ALG, this.signatureAlgorithm);
        this.addParamToQueryString(queryString, QSP_SIGNATURE, this.signature);
        return queryString.toString();
    }

    private void addParamToQueryString(StringBuilder queryString, String parameterName, String parameterValue) {
        if (parameterValue != null && parameterValue.length() != 0) {
            if (queryString.length() != 0) {
                queryString.append('&');
            }
            queryString.append(parameterName);
            queryString.append('=');
            queryString.append(parameterValue);
        }
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public boolean isUrlEncoded() {
        return this.urlEncoded;
    }

    public void setUrlEncoded(boolean urlEncoded) {
        this.urlEncoded = urlEncoded;
    }

    public void encode() {
        if (!this.urlEncoded) {
            this.samlMessage = this.urlEncode(this.samlMessage);
            this.signature = this.urlEncode(this.signature);
            this.signatureAlgorithm = this.urlEncode(this.signatureAlgorithm);
            this.relayState = this.urlEncode(this.relayState);
            this.urlEncoded = true;
        }
    }

    public void decode() {
        if (this.urlEncoded) {
            this.samlMessage = this.urlDecode(this.samlMessage);
            this.signature = this.urlDecode(this.signature);
            this.signatureAlgorithm = this.urlDecode(this.signatureAlgorithm);
            this.relayState = this.urlDecode(this.relayState);
            this.urlEncoded = false;
        }
    }

    private String urlEncode(String value) {
        if (value == null) {
            return null;
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String urlDecode(String value) {
        if (value == null) {
            return null;
        }
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

