/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.saml;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.seam.security.external.InvalidRequestException;
import org.jboss.seam.security.external.ResponseHandler;
import org.jboss.seam.security.external.saml.SamlEntityBean;
import org.jboss.seam.security.external.saml.SamlIdpOrSp;
import org.jboss.seam.security.external.saml.SamlMessageReceiver;
import org.jboss.seam.security.external.saml.SamlServiceType;

public class SamlServlet
extends HttpServlet {
    private static final long serialVersionUID = -6125510783395424719L;
    private Logger log = Logger.getLogger(SamlServlet.class);
    @Inject
    private SamlMessageReceiver samlMessageReceiver;
    @Inject
    private ResponseHandler responseHandler;
    @Inject
    private Instance<SamlEntityBean> samlEntityBean;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetOrPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetOrPost(request, response);
    }

    private void doGetOrPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.handleMessage(request, response);
        }
        catch (InvalidRequestException e) {
            response.sendError(400, e.getDescription());
            this.log.infof("Bad request received from %s: %s", (Object)request.getRemoteHost(), (Object)e.getDescription());
        }
    }

    private void handleMessage(HttpServletRequest httpRequest, HttpServletResponse response) throws InvalidRequestException {
        Matcher matcher = Pattern.compile("/(IDP|SP)/(.*?)$").matcher(httpRequest.getRequestURI());
        boolean found = matcher.find();
        if (!found) {
            this.responseHandler.sendError(404, "No service endpoint exists for this URL.", response);
        }
        SamlIdpOrSp idpOrSp = SamlIdpOrSp.valueOf(matcher.group(1));
        SamlServiceType service = SamlServiceType.getByName(matcher.group(2));
        switch (service) {
            case SAML_SINGLE_LOGOUT_SERVICE: 
            case SAML_SINGLE_SIGN_ON_SERVICE: 
            case SAML_ASSERTION_CONSUMER_SERVICE: {
                this.samlMessageReceiver.handleIncomingSamlMessage(service, httpRequest, response, idpOrSp);
                break;
            }
            case SAML_META_DATA_SERVICE: {
                ((SamlEntityBean)this.samlEntityBean.get()).writeMetaData(this.responseHandler.getWriter("application/xml", response));
                break;
            }
            default: {
                throw new RuntimeException("Unsupported service " + (Object)((Object)service));
            }
        }
    }
}

