/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.saml.idp;

import java.util.HashMap;
import java.util.Map;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.SPSSODescriptorType;
import org.jboss.seam.security.external.saml.SamlExternalEntity;
import org.jboss.seam.security.external.saml.SamlProfile;
import org.jboss.seam.security.external.saml.SamlService;

public class SamlExternalServiceProvider
extends SamlExternalEntity {
    private Map<SamlProfile, SamlService> services = new HashMap<SamlProfile, SamlService>();
    private boolean wantAssertionsSigned = true;
    private boolean authnRequestsSigned;

    public SamlExternalServiceProvider(String entityId, SPSSODescriptorType SPSSODescriptor) {
        super(entityId, SPSSODescriptor.getKeyDescriptor());
        this.wantAssertionsSigned = SPSSODescriptor.isWantAssertionsSigned();
        this.authnRequestsSigned = SPSSODescriptor.isAuthnRequestsSigned();
        this.services.put(SamlProfile.SINGLE_SIGN_ON, new SamlService(SamlProfile.SINGLE_SIGN_ON, SPSSODescriptor.getAssertionConsumerService()));
        this.services.put(SamlProfile.SINGLE_LOGOUT, new SamlService(SamlProfile.SINGLE_LOGOUT, SPSSODescriptor.getSingleLogoutService()));
    }

    @Override
    public SamlService getService(SamlProfile service) {
        return this.services.get((Object)service);
    }

    public boolean isWantAssertionsSigned() {
        return this.wantAssertionsSigned;
    }

    public void setWantAssertionsSigned(boolean wantAssertionsSigned) {
        this.wantAssertionsSigned = wantAssertionsSigned;
    }

    public boolean isAuthnRequestsSigned() {
        return this.authnRequestsSigned;
    }

    public void setAuthnRequestsSigned(boolean authnRequestsSigned) {
        this.authnRequestsSigned = authnRequestsSigned;
    }
}

