/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.io.Serializable;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.jboss.seam.security.TokenStore;
import org.jboss.seam.solder.properties.Property;

@ApplicationScoped
public class JpaTokenStore
implements TokenStore,
Serializable {
    private static final long serialVersionUID = -1984227349549914828L;
    private Class<?> tokenEntityClass;
    private Property<String> tokenUsernameProperty;
    private Property<String> tokenValueProperty;
    @Inject
    BeanManager manager;
    @Inject
    Instance<EntityManager> entityManagerInstance;

    @Inject
    public void create() {
    }

    @Override
    public void createToken(String username, String value) {
        if (this.tokenEntityClass == null) {
            throw new IllegalStateException("Could not create token, tokenEntityClass not set");
        }
        try {
            Object token = this.tokenEntityClass.newInstance();
            this.tokenUsernameProperty.setValue(token, (Object)username);
            this.tokenValueProperty.setValue(token, (Object)value);
            this.lookupEntityManager().persist(token);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not create token", ex);
        }
    }

    @Override
    public boolean validateToken(String username, String value) {
        return this.lookupToken(username, value) != null;
    }

    @Override
    public void invalidateToken(String username, String value) {
        Object token = this.lookupToken(username, value);
        if (token != null) {
            this.lookupEntityManager().remove(token);
        }
    }

    @Override
    public void invalidateAll(String username) {
        Query query = this.lookupEntityManager().createQuery("select t from " + this.tokenEntityClass.getName() + " t where " + this.tokenUsernameProperty.getName() + " = :username").setParameter("username", (Object)username);
        for (Object token : query.getResultList()) {
            this.lookupEntityManager().remove(token);
        }
    }

    public Object lookupToken(String username, String value) {
        try {
            Object token = this.lookupEntityManager().createQuery("select t from " + this.tokenEntityClass.getName() + " t where " + this.tokenUsernameProperty.getName() + " = :username and " + this.tokenValueProperty.getName() + " = :value").setParameter("username", (Object)username).setParameter("value", (Object)value).getSingleResult();
            return token;
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public Class<?> getTokenEntityClass() {
        return this.tokenEntityClass;
    }

    public void setTokenEntityClass(Class<?> tokenEntityClass) {
        this.tokenEntityClass = tokenEntityClass;
    }

    private EntityManager lookupEntityManager() {
        return (EntityManager)this.entityManagerInstance.get();
    }
}

