/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.management;

import java.util.Collection;
import javax.enterprise.inject.Model;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.jboss.seam.security.Authenticator;
import org.jboss.seam.security.BaseAuthenticator;
import org.jboss.seam.security.Credentials;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.UserImpl;
import org.picketlink.idm.api.Credential;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.User;
import org.picketlink.idm.common.exception.FeatureNotSupportedException;
import org.picketlink.idm.common.exception.IdentityException;

@Model
public class IdmAuthenticator
extends BaseAuthenticator
implements Authenticator {
    private static final Logger log = Logger.getLogger(IdmAuthenticator.class);
    @Inject
    IdentitySession identitySession;
    @Inject
    Credentials credentials;
    @Inject
    Identity identity;

    @Override
    public void authenticate() {
        if (this.identitySession != null) {
            UserImpl u = new UserImpl(this.credentials.getUsername());
            try {
                boolean success = this.identitySession.getAttributesManager().validateCredentials((User)u, new Credential[]{this.credentials.getCredential()});
                if (success) {
                    Collection roleTypes = this.identitySession.getRoleManager().findUserRoleTypes((User)u);
                    for (RoleType roleType : roleTypes) {
                        for (Role role : this.identitySession.getRoleManager().findRoles((IdentityType)u, roleType)) {
                            this.identity.addRole(role.getRoleType().getName(), role.getGroup().getName(), role.getGroup().getGroupType());
                        }
                    }
                    this.setUser(u);
                    this.setStatus(Authenticator.AuthenticationStatus.SUCCESS);
                    return;
                }
            }
            catch (IdentityException ex) {
                log.error((Object)"Authentication error", (Throwable)ex);
            }
            catch (FeatureNotSupportedException ex) {
                log.error((Object)"Authentication error", (Throwable)ex);
            }
        }
        this.setStatus(Authenticator.AuthenticationStatus.FAILURE);
    }
}

