/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.management.action;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.seam.security.GroupImpl;
import org.jboss.seam.transaction.Transactional;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.common.exception.IdentityException;

@Named
@ConversationScoped
public class GroupAction
implements Serializable {
    private static final long serialVersionUID = -1553124158319503903L;
    @Inject
    Conversation conversation;
    @Inject
    IdentitySession identitySession;
    private String groupName;
    private String groupType = "GROUP";

    public void createGroup() {
        this.conversation.begin();
    }

    @Transactional
    public void deleteGroup(String name, String groupType) throws IdentityException {
        GroupImpl group = new GroupImpl(name, groupType);
        this.identitySession.getPersistenceManager().removeGroup((Group)group, true);
    }

    @Transactional
    public String save() throws IdentityException {
        this.identitySession.getPersistenceManager().createGroup(this.groupName, this.groupType);
        this.conversation.end();
        return "success";
    }

    public void cancel() {
        this.conversation.end();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupType() {
        return this.groupType;
    }

    public void setGroupType(String groupType) {
        this.groupType = groupType;
    }

    public List<String> getSupportedGroupTypes() {
        return null;
    }
}

