/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.seam.security.annotations.permission.Identifier;
import org.jboss.seam.security.permission.ClassIdentifierStrategy;
import org.jboss.seam.security.permission.EntityIdentifierStrategy;
import org.jboss.seam.security.permission.IdentifierStrategy;

@ApplicationScoped
public class IdentifierPolicy {
    private Map<Class<?>, IdentifierStrategy> strategies = new ConcurrentHashMap();
    private Set<IdentifierStrategy> registeredStrategies = new HashSet<IdentifierStrategy>();

    @Inject
    public void create() {
        if (this.registeredStrategies.isEmpty()) {
            this.registeredStrategies.add(new EntityIdentifierStrategy());
            this.registeredStrategies.add(new ClassIdentifierStrategy());
        }
    }

    public String getIdentifier(Object target) {
        if (target instanceof String) {
            return (String)target;
        }
        IdentifierStrategy strategy = this.strategies.get(target.getClass());
        if (strategy == null) {
            Class<? extends IdentifierStrategy> strategyClass;
            if (target.getClass().isAnnotationPresent(Identifier.class) && (strategyClass = target.getClass().getAnnotation(Identifier.class).value()) != IdentifierStrategy.class) {
                try {
                    strategy = strategyClass.newInstance();
                    this.strategies.put(target.getClass(), strategy);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error instantiating IdentifierStrategy for object " + target, ex);
                }
            }
            for (IdentifierStrategy s : this.registeredStrategies) {
                if (!s.canIdentify(target.getClass())) continue;
                strategy = s;
                this.strategies.put(target.getClass(), strategy);
                break;
            }
        }
        return strategy != null ? strategy.getIdentifier(target) : null;
    }

    public Set<IdentifierStrategy> getRegisteredStrategies() {
        return this.registeredStrategies;
    }

    public void setRegisteredStrategies(Set<IdentifierStrategy> registeredStrategies) {
        this.registeredStrategies = registeredStrategies;
    }
}

