/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.validation;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.validation.Validator;
import org.hibernate.validator.method.MethodConstraintViolation;
import org.hibernate.validator.method.MethodConstraintViolationException;
import org.hibernate.validator.method.MethodValidator;
import org.jboss.seam.validation.AutoValidating;

@AutoValidating
@Interceptor
public class ValidationInterceptor
implements Serializable {
    private static final long serialVersionUID = 604440259030722151L;
    @Inject
    private Validator validator;

    @AroundInvoke
    public Object validateMethodInvocation(InvocationContext ctx) throws Exception {
        Set violations = ((MethodValidator)this.validator.unwrap(MethodValidator.class)).validateAllParameters(ctx.getTarget(), ctx.getMethod(), ctx.getParameters(), new Class[0]);
        if (!violations.isEmpty()) {
            throw new MethodConstraintViolationException(this.getMessage(ctx.getMethod(), ctx.getParameters(), violations), violations);
        }
        Object result = ctx.proceed();
        violations = ((MethodValidator)this.validator.unwrap(MethodValidator.class)).validateReturnValue(ctx.getTarget(), ctx.getMethod(), result, new Class[0]);
        if (!violations.isEmpty()) {
            throw new MethodConstraintViolationException(this.getMessage(ctx.getMethod(), ctx.getParameters(), violations), violations);
        }
        return result;
    }

    private String getMessage(Method method, Object[] args, Set<? extends MethodConstraintViolation<?>> violations) {
        StringBuilder message = new StringBuilder();
        message.append(violations.size());
        message.append(" constraint violation(s) occurred during method invocation.");
        message.append("\nMethod: ");
        message.append(method);
        message.append("\nArgument values: ");
        message.append(Arrays.toString(args));
        message.append("\nConstraint violations: ");
        int i = 1;
        for (MethodConstraintViolation<?> oneConstraintViolation : violations) {
            message.append("\n  (");
            message.append(i);
            message.append(") Kind: ");
            message.append(oneConstraintViolation.getKind());
            message.append("\n      parameter index: ");
            message.append(oneConstraintViolation.getParameterIndex());
            message.append("\n      message: ");
            message.append(oneConstraintViolation.getMessage());
            message.append("\n      root bean: ");
            message.append(oneConstraintViolation.getRootBean());
            message.append("\n      property path: ");
            message.append(oneConstraintViolation.getPropertyPath());
            message.append("\n      constraint: ");
            message.append(oneConstraintViolation.getConstraintDescriptor().getAnnotation());
            ++i;
        }
        return message.toString();
    }
}

