package org.jboss.shrinkwrap.descriptor.impl.jboss51; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jboss51.MessagePropertiesType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jboss51.MethodType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.MethodTypeImpl;

/**
 * This class implements the <code> message-propertiesType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class MessagePropertiesTypeImpl<T> implements Child<T>, MessagePropertiesType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public MessagePropertiesTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public MessagePropertiesTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessagePropertiesType ElementName: xsd:string ElementType : class
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>class</code> element
    * @param clazz the value for the element <code>class</code> 
    * @return the current instance of <code>MessagePropertiesType<T></code> 
    */
   public MessagePropertiesType<T> clazz(String clazz)
   {
      childNode.getOrCreate("class").text(clazz);
      return this;
   }

   /**
    * Returns the <code>class</code> element
    * @return the node defined for the element <code>class</code> 
    */
   public String getClazz()
   {
      return childNode.getTextValueForPatternName("class");
   }

   /**
    * Removes the <code>class</code> element 
    * @return the current instance of <code>MessagePropertiesType<T></code> 
    */
   public MessagePropertiesType<T> removeClazz()
   {
      childNode.removeChildren("class");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessagePropertiesType ElementName: jboss:methodType ElementType : method
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>method</code> element with the given value will be created.
    * Otherwise, the existing <code>method</code> element will be returned.
    * @return  a new or existing instance of <code>MethodType<MessagePropertiesType<T>></code> 
    */
   public MethodType<MessagePropertiesType<T>> getOrCreateMethod()
   {
      Node node = childNode.getOrCreate("method");
      MethodType<MessagePropertiesType<T>> method = new MethodTypeImpl<MessagePropertiesType<T>>(this, "method", childNode, node);
      return method;
   }

   /**
    * Removes the <code>method</code> element 
    * @return the current instance of <code>MessagePropertiesType<T></code> 
    */
   public MessagePropertiesType<T> removeMethod()
   {
      childNode.removeChildren("method");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessagePropertiesType ElementName: xsd:string ElementType : delivery
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>delivery</code> element
    * @param delivery the value for the element <code>delivery</code> 
    * @return the current instance of <code>MessagePropertiesType<T></code> 
    */
   public MessagePropertiesType<T> delivery(String delivery)
   {
      childNode.getOrCreate("delivery").text(delivery);
      return this;
   }

   /**
    * Returns the <code>delivery</code> element
    * @return the node defined for the element <code>delivery</code> 
    */
   public String getDelivery()
   {
      return childNode.getTextValueForPatternName("delivery");
   }

   /**
    * Removes the <code>delivery</code> element 
    * @return the current instance of <code>MessagePropertiesType<T></code> 
    */
   public MessagePropertiesType<T> removeDelivery()
   {
      childNode.removeChildren("delivery");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessagePropertiesType ElementName: xsd:integer ElementType : priority
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>priority</code> element
    * @param priority the value for the element <code>priority</code> 
    * @return the current instance of <code>MessagePropertiesType<T></code> 
    */
   public MessagePropertiesType<T> priority(Integer priority)
   {
      childNode.getOrCreate("priority").text(priority);
      return this;
   }

   /**
    * Returns the <code>priority</code> element
    * @return the node defined for the element <code>priority</code> 
    */
   public Integer getPriority()
   {
      if (childNode.getTextValueForPatternName("priority") != null && !childNode.getTextValueForPatternName("priority").equals("null")) {
         return Integer.valueOf(childNode.getTextValueForPatternName("priority"));
      }
      return null;
   }

   /**
    * Removes the <code>priority</code> element 
    * @return the current instance of <code>MessagePropertiesType<T></code> 
    */
   public MessagePropertiesType<T> removePriority()
   {
      childNode.removeChildren("priority");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessagePropertiesType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>MessagePropertiesType<T></code> 
    */
   public MessagePropertiesType<T> id(String id)
   {
      childNode.attribute("id", id);
      return this;
   }

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
      public String getId()
   {
      return childNode.getAttribute("id");
   }

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>MessagePropertiesType<T></code> 
    */
   public MessagePropertiesType<T> removeId()
   {
      childNode.removeAttribute("id");
      return this;
   }
}
