package org.jboss.shrinkwrap.descriptor.impl.jboss51; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jboss51.PoolConfigType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;

/**
 * This class implements the <code> pool-configType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class PoolConfigTypeImpl<T> implements Child<T>, PoolConfigType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public PoolConfigTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public PoolConfigTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PoolConfigType ElementName: javaee:string ElementType : pool-value
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>pool-value</code> element
    * @param poolValue the value for the element <code>pool-value</code> 
    * @return the current instance of <code>PoolConfigType<T></code> 
    */
   public PoolConfigType<T> poolValue(String poolValue)
   {
      childNode.getOrCreate("pool-value").text(poolValue);
      return this;
   }

   /**
    * Returns the <code>pool-value</code> element
    * @return the node defined for the element <code>pool-value</code> 
    */
   public String getPoolValue()
   {
      return childNode.getTextValueForPatternName("pool-value");
   }

   /**
    * Removes the <code>pool-value</code> element 
    * @return the current instance of <code>PoolConfigType<T></code> 
    */
   public PoolConfigType<T> removePoolValue()
   {
      childNode.removeChildren("pool-value");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PoolConfigType ElementName: javaee:xsdIntegerType ElementType : pool-max-size
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>pool-max-size</code> element
    * @param poolMaxSize the value for the element <code>pool-max-size</code> 
    * @return the current instance of <code>PoolConfigType<T></code> 
    */
   public PoolConfigType<T> poolMaxSize(Integer poolMaxSize)
   {
      childNode.getOrCreate("pool-max-size").text(poolMaxSize);
      return this;
   }

   /**
    * Returns the <code>pool-max-size</code> element
    * @return the node defined for the element <code>pool-max-size</code> 
    */
   public Integer getPoolMaxSize()
   {
      if (childNode.getTextValueForPatternName("pool-max-size") != null && !childNode.getTextValueForPatternName("pool-max-size").equals("null")) {
         return Integer.valueOf(childNode.getTextValueForPatternName("pool-max-size"));
      }
      return null;
   }

   /**
    * Removes the <code>pool-max-size</code> element 
    * @return the current instance of <code>PoolConfigType<T></code> 
    */
   public PoolConfigType<T> removePoolMaxSize()
   {
      childNode.removeChildren("pool-max-size");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PoolConfigType ElementName: javaee:xsdIntegerType ElementType : pool-timeout
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>pool-timeout</code> element
    * @param poolTimeout the value for the element <code>pool-timeout</code> 
    * @return the current instance of <code>PoolConfigType<T></code> 
    */
   public PoolConfigType<T> poolTimeout(Integer poolTimeout)
   {
      childNode.getOrCreate("pool-timeout").text(poolTimeout);
      return this;
   }

   /**
    * Returns the <code>pool-timeout</code> element
    * @return the node defined for the element <code>pool-timeout</code> 
    */
   public Integer getPoolTimeout()
   {
      if (childNode.getTextValueForPatternName("pool-timeout") != null && !childNode.getTextValueForPatternName("pool-timeout").equals("null")) {
         return Integer.valueOf(childNode.getTextValueForPatternName("pool-timeout"));
      }
      return null;
   }

   /**
    * Removes the <code>pool-timeout</code> element 
    * @return the current instance of <code>PoolConfigType<T></code> 
    */
   public PoolConfigType<T> removePoolTimeout()
   {
      childNode.removeChildren("pool-timeout");
      return this;
   }
}
