package org.jboss.shrinkwrap.descriptor.impl.jboss51; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jboss51.PortComponentType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;

/**
 * This class implements the <code> port-componentType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class PortComponentTypeImpl<T> implements Child<T>, PortComponentType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public PortComponentTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public PortComponentTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentType ElementName: xsd:string ElementType : port-component-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>port-component-name</code> element
    * @param portComponentName the value for the element <code>port-component-name</code> 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> portComponentName(String portComponentName)
   {
      childNode.getOrCreate("port-component-name").text(portComponentName);
      return this;
   }

   /**
    * Returns the <code>port-component-name</code> element
    * @return the node defined for the element <code>port-component-name</code> 
    */
   public String getPortComponentName()
   {
      return childNode.getTextValueForPatternName("port-component-name");
   }

   /**
    * Removes the <code>port-component-name</code> element 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> removePortComponentName()
   {
      childNode.removeChildren("port-component-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentType ElementName: xsd:string ElementType : port-component-uri
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>port-component-uri</code> element
    * @param portComponentUri the value for the element <code>port-component-uri</code> 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> portComponentUri(String portComponentUri)
   {
      childNode.getOrCreate("port-component-uri").text(portComponentUri);
      return this;
   }

   /**
    * Returns the <code>port-component-uri</code> element
    * @return the node defined for the element <code>port-component-uri</code> 
    */
   public String getPortComponentUri()
   {
      return childNode.getTextValueForPatternName("port-component-uri");
   }

   /**
    * Removes the <code>port-component-uri</code> element 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> removePortComponentUri()
   {
      childNode.removeChildren("port-component-uri");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentType ElementName: xsd:string ElementType : auth-method
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>auth-method</code> element
    * @param authMethod the value for the element <code>auth-method</code> 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> authMethod(String authMethod)
   {
      childNode.getOrCreate("auth-method").text(authMethod);
      return this;
   }

   /**
    * Returns the <code>auth-method</code> element
    * @return the node defined for the element <code>auth-method</code> 
    */
   public String getAuthMethod()
   {
      return childNode.getTextValueForPatternName("auth-method");
   }

   /**
    * Removes the <code>auth-method</code> element 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> removeAuthMethod()
   {
      childNode.removeChildren("auth-method");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentType ElementName: xsd:string ElementType : transport-guarantee
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>transport-guarantee</code> element
    * @param transportGuarantee the value for the element <code>transport-guarantee</code> 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> transportGuarantee(String transportGuarantee)
   {
      childNode.getOrCreate("transport-guarantee").text(transportGuarantee);
      return this;
   }

   /**
    * Returns the <code>transport-guarantee</code> element
    * @return the node defined for the element <code>transport-guarantee</code> 
    */
   public String getTransportGuarantee()
   {
      return childNode.getTextValueForPatternName("transport-guarantee");
   }

   /**
    * Removes the <code>transport-guarantee</code> element 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> removeTransportGuarantee()
   {
      childNode.removeChildren("transport-guarantee");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentType ElementName: xsd:boolean ElementType : secure-wsdl-access
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>secure-wsdl-access</code> element
    * @param secureWsdlAccess the value for the element <code>secure-wsdl-access</code> 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> secureWsdlAccess(Boolean secureWsdlAccess)
   {
      childNode.getOrCreate("secure-wsdl-access").text(secureWsdlAccess);
      return this;
   }

   /**
    * Returns the <code>secure-wsdl-access</code> element
    * @return the node defined for the element <code>secure-wsdl-access</code> 
    */
   public Boolean isSecureWsdlAccess()
   {
      return Strings.isTrue(childNode.getTextValueForPatternName("secure-wsdl-access"));
   }

   /**
    * Removes the <code>secure-wsdl-access</code> element 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> removeSecureWsdlAccess()
   {
      childNode.removeChildren("secure-wsdl-access");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> id(String id)
   {
      childNode.attribute("id", id);
      return this;
   }

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
      public String getId()
   {
      return childNode.getAttribute("id");
   }

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> removeId()
   {
      childNode.removeAttribute("id");
      return this;
   }
}
