package org.jboss.shrinkwrap.descriptor.impl.jboss51; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jboss51.RemoteBindingType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;

/**
 * This class implements the <code> remote-bindingType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class RemoteBindingTypeImpl<T> implements Child<T>, RemoteBindingType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public RemoteBindingTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public RemoteBindingTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: RemoteBindingType ElementName: xsd:string ElementType : description
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>description</code> elements, 
    * a new <code>description</code> element 
    * @param values list of <code>description</code> objects 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> description(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("description").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>description</code> elements
    * @return list of <code>description</code> 
    */
public List<String> getAllDescription()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("description");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>description</code> element 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> removeAllDescription()
   {
      childNode.removeChildren("description");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: RemoteBindingType ElementName: xsd:token ElementType : jndi-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>jndi-name</code> element
    * @param jndiName the value for the element <code>jndi-name</code> 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> jndiName(String jndiName)
   {
      childNode.getOrCreate("jndi-name").text(jndiName);
      return this;
   }

   /**
    * Returns the <code>jndi-name</code> element
    * @return the node defined for the element <code>jndi-name</code> 
    */
   public String getJndiName()
   {
      return childNode.getTextValueForPatternName("jndi-name");
   }

   /**
    * Removes the <code>jndi-name</code> element 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> removeJndiName()
   {
      childNode.removeChildren("jndi-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: RemoteBindingType ElementName: javaee:string ElementType : client-bind-url
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>client-bind-url</code> element
    * @param clientBindUrl the value for the element <code>client-bind-url</code> 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> clientBindUrl(String clientBindUrl)
   {
      childNode.getOrCreate("client-bind-url").text(clientBindUrl);
      return this;
   }

   /**
    * Returns the <code>client-bind-url</code> element
    * @return the node defined for the element <code>client-bind-url</code> 
    */
   public String getClientBindUrl()
   {
      return childNode.getTextValueForPatternName("client-bind-url");
   }

   /**
    * Removes the <code>client-bind-url</code> element 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> removeClientBindUrl()
   {
      childNode.removeChildren("client-bind-url");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: RemoteBindingType ElementName: javaee:string ElementType : interceptor-stack
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>interceptor-stack</code> element
    * @param interceptorStack the value for the element <code>interceptor-stack</code> 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> interceptorStack(String interceptorStack)
   {
      childNode.getOrCreate("interceptor-stack").text(interceptorStack);
      return this;
   }

   /**
    * Returns the <code>interceptor-stack</code> element
    * @return the node defined for the element <code>interceptor-stack</code> 
    */
   public String getInterceptorStack()
   {
      return childNode.getTextValueForPatternName("interceptor-stack");
   }

   /**
    * Removes the <code>interceptor-stack</code> element 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> removeInterceptorStack()
   {
      childNode.removeChildren("interceptor-stack");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: RemoteBindingType ElementName: javaee:string ElementType : invoker-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>invoker-name</code> element
    * @param invokerName the value for the element <code>invoker-name</code> 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> invokerName(String invokerName)
   {
      childNode.getOrCreate("invoker-name").text(invokerName);
      return this;
   }

   /**
    * Returns the <code>invoker-name</code> element
    * @return the node defined for the element <code>invoker-name</code> 
    */
   public String getInvokerName()
   {
      return childNode.getTextValueForPatternName("invoker-name");
   }

   /**
    * Removes the <code>invoker-name</code> element 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> removeInvokerName()
   {
      childNode.removeChildren("invoker-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: RemoteBindingType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> id(String id)
   {
      childNode.attribute("id", id);
      return this;
   }

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
      public String getId()
   {
      return childNode.getAttribute("id");
   }

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> removeId()
   {
      childNode.removeAttribute("id");
      return this;
   }
}
