package org.jboss.shrinkwrap.descriptor.impl.jboss51; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ResourceManagersType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ResourceManagerType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.ResourceManagerTypeImpl;

/**
 * This class implements the <code> resource-managersType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ResourceManagersTypeImpl<T> implements Child<T>, ResourceManagersType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ResourceManagersTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ResourceManagersTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceManagersType ElementName: xsd:string ElementType : description
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>description</code> elements, 
    * a new <code>description</code> element 
    * @param values list of <code>description</code> objects 
    * @return the current instance of <code>ResourceManagersType<T></code> 
    */
   public ResourceManagersType<T> description(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("description").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>description</code> elements
    * @return list of <code>description</code> 
    */
public List<String> getAllDescription()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("description");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>description</code> element 
    * @return the current instance of <code>ResourceManagersType<T></code> 
    */
   public ResourceManagersType<T> removeAllDescription()
   {
      childNode.removeChildren("description");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceManagersType ElementName: jboss:resource-managerType ElementType : resource-manager
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resource-manager</code> element will be created and returned.
    * Otherwise, the first existing <code>resource-manager</code> element will be returned.
    * @return the instance defined for the element <code>resource-manager</code> 
    */
   public ResourceManagerType<ResourceManagersType<T>> getOrCreateResourceManager()
   {
      List<Node> nodeList = childNode.get("resource-manager");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ResourceManagerTypeImpl<ResourceManagersType<T>>(this, "resource-manager", childNode, nodeList.get(0));
      }
      return createResourceManager();
   }

   /**
    * Creates a new <code>resource-manager</code> element 
    * @return the new created instance of <code>ResourceManagerType<ResourceManagersType<T>></code> 
    */
   public ResourceManagerType<ResourceManagersType<T>> createResourceManager()
   {
      return new ResourceManagerTypeImpl<ResourceManagersType<T>>(this, "resource-manager", childNode);
   }

   /**
    * Returns all <code>resource-manager</code> elements
    * @return list of <code>resource-manager</code> 
    */
   public List<ResourceManagerType<ResourceManagersType<T>>> getAllResourceManager()
   {
      List<ResourceManagerType<ResourceManagersType<T>>> list = new ArrayList<ResourceManagerType<ResourceManagersType<T>>>();
      List<Node> nodeList = childNode.get("resource-manager");
      for(Node node: nodeList)
      {
         ResourceManagerType<ResourceManagersType<T>>  type = new ResourceManagerTypeImpl<ResourceManagersType<T>>(this, "resource-manager", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>resource-manager</code> elements 
    * @return the current instance of <code>ResourceManagerType<ResourceManagersType<T>></code> 
    */
   public ResourceManagersType<T> removeAllResourceManager()
   {
      childNode.removeChildren("resource-manager");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceManagersType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>ResourceManagersType<T></code> 
    */
   public ResourceManagersType<T> id(String id)
   {
      childNode.attribute("id", id);
      return this;
   }

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
      public String getId()
   {
      return childNode.getAttribute("id");
   }

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>ResourceManagersType<T></code> 
    */
   public ResourceManagersType<T> removeId()
   {
      childNode.removeAttribute("id");
      return this;
   }
}
